/*
 * Decompiled with CFR 0.152.
 */
package updater;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import updater.Util;

public class Updater {
    private static final Logger logger = Logger.getLogger("UPDATE");

    public static void main(String[] args) {
        try {
            FileHandler fh = new FileHandler("log/web_updater.log", true);
            fh.setFormatter(new SimpleFormatter());
            logger.addHandler(fh);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Util.setLog(logger);
        Updater.info("Entrou para update");
        Updater.log(Level.INFO, "Argumentos ", args);
        String nomeZip = "";
        String destino = "";
        if (Util.isIsLinux()) {
            Updater.info("Verificar se existe arquivo de parametros");
            if (Util.existeArquivoParametros()) {
                Updater.info("Existe arquivo de parametros, verificando arquivos");
                List<String> parametros = Util.lerParametros();
                if (parametros != null) {
                    Updater.info("Conteudo arquivo de parametros: " + String.join((CharSequence)" ", parametros));
                    nomeZip = parametros.get(0);
                    if (parametros.size() > 1) {
                        destino = parametros.get(1);
                    }
                } else {
                    Updater.info("Arquivo de parametros vazio ou n\u00e3o foi poss\u00edvel abrir");
                }
                try {
                    Util.deleteArquivoParametros();
                }
                catch (Exception ex) {
                    Updater.log(Level.SEVERE, "N\u00e3o foi poss\u00edvel excluir o arquivo de configura\u00e7\u00e3o do updater", ex);
                }
            } else if (args.length >= 1) {
                String arg0 = args[0];
                String arg1 = args.length > 1 ? args[1] : "";
                Updater.info("Salvando parametros: " + arg0 + " " + arg1);
                Util.salvarParametros(arg0, arg1);
                try {
                    Updater.info("Start servi\u00e7o updater");
                    Util.startServiceUpdater();
                    System.exit(0);
                }
                catch (Exception ex) {
                    Updater.log(Level.SEVERE, "N\u00e3o foi poss\u00edvel iniciar o servi\u00e7o updater", ex);
                }
            }
        } else {
            if (args.length == 1) {
                Updater.restart();
                return;
            }
            if (args.length == 2) {
                nomeZip = args[0];
                destino = args[1];
            }
        }
        if (nomeZip.isEmpty()) {
            Updater.info("Argumentos inv\u00e1lidos");
            System.exit(1);
        }
        Updater.info(nomeZip);
        Updater.info(destino);
        if (nomeZip.equalsIgnoreCase("restart")) {
            Updater.restart();
        } else {
            try {
                Updater.info("PARANDO O SERVI\u00c7O");
                boolean stop = Util.stopService();
                if (stop) {
                    Updater.info("Extraindo o arquivo");
                    Updater.unzip(nomeZip, destino);
                    boolean sucesso = Util.startService();
                    Updater.info("SUBIU SERVI\u00c7O: " + (sucesso ? "SIM" : "N\u00c3O"));
                    System.exit(0);
                } else {
                    Updater.info("N\u00e3o foi poss\u00edvel parar o servi\u00e7o.");
                    System.exit(1);
                }
            }
            catch (Exception ex) {
                Updater.info("Exce\u00e7\u00e3o ao parar o servi\u00e7o");
                Updater.log(Level.SEVERE, "Erro", ex);
            }
        }
    }

    private static void unzip(String zipFilePath, String destino) {
        Updater.info("DESTINO: " + destino);
        String osName = System.getProperty("os.name").toLowerCase();
        String osArch = System.getProperty("sun.arch.data.model");
        String path = osName.contains("windows") ? "win" : (osName.contains("linux") ? "linux" : "");
        path = path + (osArch.toLowerCase().contains("64") ? "/64/" : "/32/");
        try (ZipFile zipFile = new ZipFile(zipFilePath);){
            Enumeration<? extends ZipEntry> enu = zipFile.entries();
            while (enu.hasMoreElements()) {
                File file;
                ZipEntry zipEntry = enu.nextElement();
                String name = zipEntry.getName();
                if (name == null || name.equalsIgnoreCase("web-updater.jar")) continue;
                if (name.startsWith("arquivos")) {
                    if (!name.startsWith("arquivos/" + path) || zipEntry.isDirectory()) continue;
                    file = new File(destino + "/" + name);
                    if (!file.exists()) {
                        Updater.extrair(zipFile, zipEntry, destino);
                        continue;
                    }
                    boolean atualizar = !name.contains("nao_sobrescrever") && file.length() != zipEntry.getSize();
                    if (!atualizar) continue;
                    Updater.extrair(zipFile, zipEntry, destino);
                    continue;
                }
                if (zipEntry.isDirectory() && !(file = new File(destino + "/" + name)).mkdirs()) {
                    Updater.info("N\u00e3o foi poss\u00edvel criar os diret\u00f3rios.");
                }
                Updater.extrair(zipFile, zipEntry, destino);
            }
        }
        catch (IOException e) {
            Updater.log(Level.SEVERE, "Erro", e);
        }
        File file = new File(destino + File.separator + "uniplusweb-comclient.jar");
        if (file.exists()) {
            if (!(file.setReadable(true) && file.setExecutable(true) && file.setWritable(true))) {
                Updater.info("N\u00e3o foi poss\u00edvel setar a permiss\u00e3o de escrita.");
            }
        } else {
            Updater.info("JAR NAO ENCONTRADO.");
        }
    }

    private static void extrair(ZipFile zipFile, ZipEntry zipEntry, String destino) {
        String name = zipEntry.getName();
        try (InputStream is = zipFile.getInputStream(zipEntry);){
            Updater.info("Extraindo " + name);
            if (name.contains("/")) {
                name = name.substring(name.lastIndexOf("/") + 1);
            }
            Files.copy(is, Paths.get(destino + "/" + name, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable ex) {
            Updater.log(Level.SEVERE, "Erro", ex);
        }
    }

    public static void restart() {
        try {
            Updater.info("PARANDO O SERVI\u00c7O RESTART");
            boolean stop = Util.stopService();
            if (stop) {
                boolean sucesso = Util.startService();
                Updater.info("SUBIU SERVI\u00c7O: " + (sucesso ? "SIM" : "N\u00c3O"));
                System.exit(0);
            } else {
                Updater.info("N\u00e3o foi poss\u00edvel parar o servi\u00e7o.");
                System.exit(1);
            }
        }
        catch (Exception ex) {
            Updater.info("Exce\u00e7\u00e3o ao parar o servi\u00e7o");
            Updater.log(Level.SEVERE, "Erro", ex);
        }
    }

    private static void info(String txt) {
        logger.info(txt);
    }

    private static void log(Level level, String msg, Object[] params) {
        logger.log(level, msg, params);
    }

    private static void log(Level level, String msg, Throwable ex) {
        logger.log(level, msg, ex);
    }
}

