/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.core.metrics;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Gauge;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnExpression(value="false")
public class PostgresMetric {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    DataSource dataSource;
    private final Gauge gauge = ((Gauge.Builder)((Gauge.Builder)Gauge.build().name("postgres_connections")).help("numero de connections no postgres")).create();

    public PostgresMetric(CollectorRegistry registry) {
        registry.register((Collector)this.gauge);
    }

    @Async
    @Scheduled(fixedDelay=30000L)
    public void coletaMetricaPostgres() {
        this.log.debug("Metricas atualizadas");
        JdbcTemplate jt = new JdbcTemplate(this.dataSource);
        Integer retorno = (Integer)jt.queryForObject("select count(*) from pg_stat_activity", Integer.class);
        if (retorno != null) {
            this.gauge.set((double)retorno.intValue());
        }
    }
}

