/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.core.metrics;

import br.intelidata.uniplusweb.web.rest.app.client.thread.JobExecutorService;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Gauge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnExpression(value="false")
public class UnipluswebMetric {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private JobExecutorService jobExecutorService;
    private Gauge usuariosLogadosGauge = ((Gauge.Builder)((Gauge.Builder)Gauge.build().name("uniplusweb_usuarios_logados")).help("numero de usuarios logados no sistema")).create();
    private Gauge threadsJobExecutorGauge = ((Gauge.Builder)((Gauge.Builder)Gauge.build().name("uniplusweb_threads_jobexecutor")).help("numero de threads no jobexecutor")).create();

    public UnipluswebMetric(CollectorRegistry registry) {
        registry.register((Collector)this.usuariosLogadosGauge);
        registry.register((Collector)this.threadsJobExecutorGauge);
    }

    @Async
    @Scheduled(fixedDelay=30000L)
    public void coletaMetricaUniplusweb() {
        this.log.debug("Metricas atualizadas");
        this.threadsJobExecutorGauge.set((double)this.jobExecutorService.getPoolSize());
    }
}

