/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.core.sgbd;

import br.intelidata.commons.bridge.ConnectionHolder;
import br.intelidata.core.sgdb.IConnectionHandler;
import br.intelidata.uniplusweb.core.sgbd.ConnectionHandler;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component(value="connectionHandlerJob")
@Profile(value={"dev", "prod", "aws"})
public class ConnectionHandlerJob
implements IConnectionHandler {
    protected final Logger log = LoggerFactory.getLogger(ConnectionHandler.class);
    @Autowired
    private DataSource dataSource;

    public void createConnection(boolean readOnly) {
        ConnectionHolder connectionHolder = (ConnectionHolder)ConnectionHolder.holderJob.get();
        if (connectionHolder == null) {
            try {
                Connection connection = this.dataSource.getConnection();
                connectionHolder = new ConnectionHolder(connection, readOnly);
                ConnectionHolder.holderJob.set(connectionHolder);
                this.log.debug("CREATE CONNECTION executado (Batch)");
            }
            catch (SQLException e) {
                this.log.error("N\u00e3o foi poss\u00edvel adquirir uma conex\u00e3o ao banco (Batch)");
                throw new RuntimeException("N\u00e3o foi poss\u00edvel adquirir uma conex\u00e3o ao banco (Batch)");
            }
        } else {
            this.log.error("Thread atual j\u00e1 tem uma conex\u00e3o ao banco (Batch)");
            throw new RuntimeException("Thread atual j\u00e1 tem uma conex\u00e3o ao banco (Batch)");
        }
    }

    public void releaseConnection() {
        Connection connection = this.getConnection();
        try {
            connection.close();
            int openStatements = ConnectionHolder.getConnectionHolderJob().getOpenStatements();
            ConnectionHolder.holderJob.remove();
            this.log.debug("RELEASE CONNECTION executado (Batch)");
            if (openStatements != 0) {
                this.log.error("Transa\u00e7\u00e3o sem close detectada - revise o c\u00f3digo fonte (Batch)");
                throw new RuntimeException("Transa\u00e7\u00e3o sem close detectada - revise o c\u00f3digo fonte (Batch)");
            }
        }
        catch (SQLException e) {
            this.log.error("N\u00e3o foi poss\u00edvel liberar uma transa\u00e7\u00e3o (Batch)");
            throw new RuntimeException("N\u00e3o foi poss\u00edvel liberar uma transa\u00e7\u00e3o (Batch)", e);
        }
    }

    public Connection getConnection() {
        ConnectionHolder connectionHolder = (ConnectionHolder)ConnectionHolder.holderJob.get();
        if (connectionHolder == null) {
            this.log.error("A conex\u00e3o ao banco n\u00e3o foi adquirida. Verifique se o m\u00e9todo foi anotado com @DBUpdate ou @DBQuery  (Batch)");
            throw new RuntimeException("A conex\u00e3o ao banco n\u00e3o foi adquirida. Verifique se o m\u00e9todo foi anotado com @DBUpdate ou @DBQuery  (Batch)");
        }
        return connectionHolder.getCurrentConnection();
    }

    public ConnectionHolder getConnectionHolder() {
        ConnectionHolder connectionHolder = (ConnectionHolder)ConnectionHolder.holderJob.get();
        if (connectionHolder == null) {
            this.log.error("A conex\u00e3o ao banco n\u00e3o foi adquirida. Verifique se o m\u00e9todo foi anotado com @DBUpdate ou @DBQuery  (Batch)");
            throw new RuntimeException("A conex\u00e3o ao banco n\u00e3o foi adquirida. Verifique se o m\u00e9todo foi anotado com @DBUpdate ou @DBQuery  (Batch)");
        }
        return connectionHolder;
    }

    public void beginTransaction() {
        Connection connection = this.getConnection();
        try {
            connection.setAutoCommit(false);
            this.log.debug("BEGIN TRANSACTION executado  (Batch)");
        }
        catch (SQLException e) {
            this.log.error("N\u00e3o foi poss\u00edvel iniciar uma transa\u00e7\u00e3o  (Batch)");
            throw new RuntimeException("N\u00e3o foi poss\u00edvel iniciar uma transa\u00e7\u00e3o  (Batch)", e);
        }
    }

    public void commit() {
        Connection connection = this.getConnection();
        try {
            connection.commit();
            connection.setAutoCommit(true);
            this.log.debug("COMMIT executado  (Batch)");
        }
        catch (SQLException e) {
            this.log.error("N\u00e3o foi poss\u00edvel concluir uma transa\u00e7\u00e3o  (Batch)");
            throw new RuntimeException("N\u00e3o foi poss\u00edvel concluir uma transa\u00e7\u00e3o  (Batch)", e);
        }
    }

    public void commitAndContinue() {
        this.commit();
        this.beginTransaction();
    }

    public void rollback() {
        Connection connection = this.getConnection();
        try {
            connection.rollback();
            connection.setAutoCommit(true);
            this.log.debug("ROLLBACK executado (Batch)");
        }
        catch (SQLException e) {
            this.log.error("N\u00e3o foi poss\u00edvel fazer desfazer na transa\u00e7\u00e3o (Batch)");
            throw new RuntimeException("N\u00e3o foi poss\u00edvel fazer desfazer na transa\u00e7\u00e3o (Batch)", e);
        }
    }

    public boolean isConnected() {
        return ConnectionHolder.holderJob.get() != null;
    }

    public boolean isAutoCommit() {
        if (this.isConnected()) {
            Connection connection = this.getConnection();
            try {
                return connection.getAutoCommit();
            }
            catch (SQLException e) {
                this.log.error("N\u00e3o foi poss\u00edvel verificar o autocommit  (Batch)");
                throw new RuntimeException("N\u00e3o foi poss\u00edvel verificar o autocommit (Batch)", e);
            }
        }
        return false;
    }
}

