/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.core.spring.Cache;

import java.util.concurrent.Callable;
import org.mapdb.HTreeMap;
import org.springframework.cache.Cache;
import org.springframework.cache.support.AbstractValueAdaptingCache;
import org.springframework.util.Assert;

public class MapDbCache
extends AbstractValueAdaptingCache {
    private HTreeMap hTreeMap;
    private String name;

    protected MapDbCache(String name, HTreeMap hTreeMap, boolean allowNullValues) {
        super(allowNullValues);
        Assert.notNull((Object)name, (String)"Name nao pode ser null");
        Assert.notNull((Object)hTreeMap, (String)"hTreeMap nao pode ser null");
        this.hTreeMap = hTreeMap;
        this.name = name;
    }

    protected Object lookup(Object key) {
        Object value = this.hTreeMap.get(key);
        return value;
    }

    public String getName() {
        return this.name;
    }

    public Object getNativeCache() {
        return this.hTreeMap;
    }

    public <T> T get(Object key, Callable<T> valueLoader) {
        throw new RuntimeException("Nao implementado");
    }

    public void put(Object key, Object value) {
        this.hTreeMap.put(key, this.toStoreValue(value));
    }

    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        Object result = this.hTreeMap.putIfAbsent(key, this.toStoreValue(value));
        return this.toValueWrapper(result);
    }

    public void evict(Object key) {
        this.hTreeMap.remove(key);
    }

    public void clear() {
        this.hTreeMap.clearWithoutNotification();
    }
}

