/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.core.spring;

import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.uniplusweb.core.spring.JSR310LocalDateDeserializer;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;

public class JSR310LocalDateDeserializer
extends JsonDeserializer<LocalDate> {
    public static final JSR310LocalDateDeserializer INSTANCE = new JSR310LocalDateDeserializer();
    private static final DateTimeFormatter ISO_DATE_OPTIONAL_TIME = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalStart().appendLiteral('T').append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter();

    private JSR310LocalDateDeserializer() {
    }

    public LocalDate deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        switch (1.$SwitchMap$com$fasterxml$jackson$core$JsonToken[parser.getCurrentToken().ordinal()]) {
            case 1: {
                if (parser.nextToken() == JsonToken.END_ARRAY) {
                    return null;
                }
                int year = parser.getIntValue();
                parser.nextToken();
                int month = parser.getIntValue();
                parser.nextToken();
                int day = parser.getIntValue();
                if (parser.nextToken() != JsonToken.END_ARRAY) {
                    throw context.wrongTokenException(parser, JsonToken.END_ARRAY, "Expected array to end.");
                }
                return DataHoraFactory.of((int)year, (int)month, (int)day);
            }
            case 2: {
                String string = parser.getText().trim();
                if (string.length() == 0) {
                    return null;
                }
                return LocalDate.parse(string, ISO_DATE_OPTIONAL_TIME);
            }
        }
        throw context.wrongTokenException(parser, JsonToken.START_ARRAY, "Expected array or string.");
    }
}

