/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.core.spring.aop;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sistema.StatelessRequest;
import br.intelidata.core.aop.InterfaceAfterCommit;
import br.intelidata.uniplusweb.core.sgbd.ConnectionHandlerJob;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.stereotype.Component;

@Component
public class DBTransactionJobExecutor {
    private final ConnectionHandlerJob connectionHandler;

    public DBTransactionJobExecutor(ConnectionHandlerJob connectionHandler) {
        this.connectionHandler = connectionHandler;
    }

    public Object dbTransaction(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Object value;
        if (proceedingJoinPoint.getArgs().length > 0 && proceedingJoinPoint.getArgs()[0] instanceof StatelessRequest) {
            StatelessRequest req = (StatelessRequest)proceedingJoinPoint.getArgs()[0];
            Sessao sessao = req.getSessao();
            ContextoHolder.setSessao((Sessao)sessao);
        }
        try {
            this.connectionHandler.createConnection(false);
            this.connectionHandler.beginTransaction();
            value = proceedingJoinPoint.proceed();
            this.connectionHandler.commit();
            if (proceedingJoinPoint.getTarget() instanceof InterfaceAfterCommit) {
                InterfaceAfterCommit iac = (InterfaceAfterCommit)proceedingJoinPoint.getTarget();
                iac.afterCommit();
            }
        }
        catch (Throwable throwable) {
            this.connectionHandler.rollback();
            throw throwable;
        }
        finally {
            this.connectionHandler.releaseConnection();
        }
        return value;
    }
}

