/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.core.spring.multitenant;

import br.intelidata.commons.core.sql.SenhaBanco;
import br.intelidata.uniplusweb.config.UnipluswebProperties;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DataSourceFactory {
    @Autowired
    private UnipluswebProperties unipluswebProperties;

    public javax.sql.DataSource criaDataSource(String urlDatabase) {
        DataSource dataSource = new DataSource();
        dataSource.setUsername("uniplus-task");
        dataSource.setPassword(new SenhaBanco().getPwd());
        dataSource.setDriverClassName(this.unipluswebProperties.getDatasource().getDriver());
        dataSource.setUrl(urlDatabase);
        dataSource.setInitialSize(1);
        dataSource.setMaxActive(this.unipluswebProperties.getDatasource().getMaxActive());
        dataSource.setMaxIdle(this.unipluswebProperties.getDatasource().getMaxIdle());
        dataSource.setMinIdle(this.unipluswebProperties.getDatasource().getMinIdle());
        dataSource.setTestOnBorrow(true);
        dataSource.setValidationQuery("select 1");
        dataSource.setValidationInterval((long)this.unipluswebProperties.getDatasource().getValidationInterval());
        dataSource.setTimeBetweenEvictionRunsMillis(this.unipluswebProperties.getDatasource().getTimeBetweenEvictionRunsMillis());
        dataSource.setMinEvictableIdleTimeMillis(this.unipluswebProperties.getDatasource().getMinEvictableIdleTimeMillis());
        dataSource.setRemoveAbandoned(true);
        dataSource.setRemoveAbandonedTimeout(this.unipluswebProperties.getDatasource().getRemoveAbandonedTimeout());
        dataSource.setLogAbandoned(true);
        dataSource.setAbandonWhenPercentageFull(this.unipluswebProperties.getDatasource().getAbandonWhenPercentageFull());
        dataSource.setSuspectTimeout(this.unipluswebProperties.getDatasource().getSuspectTimeout());
        dataSource.setJdbcInterceptors("ResetAbandonedTimer");
        return dataSource;
    }
}

