/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.security;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.LicencaManager;
import br.intelidata.commons.core.sistema.CarregaMenuWeb;
import br.intelidata.commons.core.sistema.MenuSistemaManager;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.domain.pojo.ConfiguracaoEcommerce;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.Usuario;
import br.intelidata.commons.domain.pojo.enuns.AccessLogStatus;
import br.intelidata.commons.domain.pojo.enuns.NivelPoliticaSeguranca;
import br.intelidata.commons.domain.pojo.enuns.TipoAcesso;
import br.intelidata.commons.domain.pojo.enuns.TipoImagem;
import br.intelidata.commons.domain.regranegocio.AccessLogRN;
import br.intelidata.commons.domain.regranegocio.AcessoMenuUsuarioCommonRN;
import br.intelidata.commons.domain.regranegocio.ConfiguracaoEcommerceCommonRN;
import br.intelidata.commons.domain.regranegocio.ControleRN;
import br.intelidata.commons.domain.regranegocio.FilialCommonRN;
import br.intelidata.commons.domain.regranegocio.b2c.SessaoWebRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.LicencaRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.NotificacaoUsuarioRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.UsuarioRN;
import br.intelidata.commons.modulo.notafiscal.nfse.NfseManagerWeb;
import br.intelidata.commons.modulo.notafiscal.nfse.ProvedorWeb;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.config.UnipluswebProperties;
import br.intelidata.uniplusweb.core.service.CacheService;
import br.intelidata.uniplusweb.core.service.MenuService;
import br.intelidata.uniplusweb.core.util.BeanUtil;
import br.intelidata.uniplusweb.core.util.MenuManager;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.core.util.TipoCache;
import br.intelidata.uniplusweb.security.AccountController;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import br.intelidata.uniplusweb.service.LicencaService;
import br.intelidata.uniplusweb.service.ModuloService;
import br.intelidata.uniplusweb.service.PropriedadeService;
import br.intelidata.uniplusweb.service.StorageService;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.BaseController;
import br.intelidata.uniplusweb.web.rest.app.batch.wrappers.DadosDiscoWrapper;
import br.intelidata.uniplusweb.web.rest.app.client.schedulers.GerenciadorLicencaManager;
import br.intelidata.uniplusweb.web.rest.app.wrapper.LicencaWrapper;
import br.intelidata.uniplusweb.web.rest.app.wrapper.ValidadorLicencaWrapper;
import br.intelidata.uniplusweb.web.rest.menus.ItemMenuWeb;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import unico.pojo.Licenca;

@RestController
public class AccountController
extends BaseController {
    private final CacheService cacheService;
    private final MenuService menuService;
    private final StorageService saveFile;
    private final GerenciadorLicencaManager gerenciadorLicencaManager;
    private final UnipluswebProperties unipluswebProperties;
    private final LicencaService licencaService;
    private final PropriedadeService propriedadeService;
    private final ModuloService moduloService;
    private final FuncionalidadeService funcionalidadeService;
    private final HttpServletRequest httpServletRequest;

    @Autowired
    public AccountController(CacheService cacheService, MenuService menuService, StorageService saveFile, GerenciadorLicencaManager gerenciadorLicencaManager, UnipluswebProperties unipluswebProperties, LicencaService licencaService, PropriedadeService propriedadeService, ModuloService moduloService, FuncionalidadeService funcionalidadeService, HttpServletRequest httpServletRequest) {
        this.cacheService = cacheService;
        this.menuService = menuService;
        this.saveFile = saveFile;
        this.gerenciadorLicencaManager = gerenciadorLicencaManager;
        this.unipluswebProperties = unipluswebProperties;
        this.licencaService = licencaService;
        this.propriedadeService = propriedadeService;
        this.moduloService = moduloService;
        this.funcionalidadeService = funcionalidadeService;
        this.httpServletRequest = httpServletRequest;
    }

    @RequestMapping(value={"/api/savetopten"}, method={RequestMethod.POST})
    @DBTransaction
    public void saveTopTen(@RequestBody Map<Integer, Integer> acessos) throws UnicoMensagemUsuarioException {
        for (Map.Entry<Integer, Integer> entry : acessos.entrySet()) {
            AcessoMenuUsuarioCommonRN.getInstance().rankearPrograma(SessaoUtil.getSessao(), entry.getKey().intValue(), entry.getValue().intValue());
        }
    }

    @RequestMapping(value={"/api/account"})
    @DBTransaction
    public UsuarioCorrenteDTO getAccount() throws UnicoMensagemUsuarioException {
        Usuario usuario = SessaoUtil.getSessao().getUsuario();
        br.intelidata.commons.core.licenca.DadosLicenca dadosLicenca = this.licencaService.getDadosLicenca();
        ArrayList licencas = new ArrayList(dadosLicenca.getMapLicencas().keySet());
        Licenca licencaPrincipal = LicencaRN.getInstance().buscarLicencaPrincipal();
        if (licencaPrincipal == null && !dadosLicenca.isDemonstracao()) {
            dadosLicenca.setDemonstracao(true);
            dadosLicenca.setLicencas(new ArrayList());
            dadosLicenca.setMapLicencas(new HashMap());
        }
        LicencaWrapper licencaWrapper = licencaPrincipal != null ? new LicencaWrapper(licencaPrincipal) : null;
        ValidadorLicencaWrapper validadorLicenca = this.gerenciadorLicencaManager.getDadosLicenca(usuario, dadosLicenca.isDemonstracao());
        Filial filial = SessaoUtil.getSessao().getFilial();
        boolean exibirContrato = !ControleRN.getInstance().getRegistroControle().isUsuarioAdminViuContratoPLUS();
        DadosLicenca dadosLicencaResumido = new DadosLicenca(licencaWrapper, validadorLicenca, filial.getCnpj(), exibirContrato, null);
        List notificacoes = NotificacaoUsuarioRN.getInstance().buscaNotificaoesNaoLidas(usuario.getId());
        List acessosRapidos = AcessoMenuUsuarioCommonRN.getInstance().buscarAcessosComLimite(usuario.getId(), 10);
        ProvedorWeb provedorWeb = this.getProvedorWeb();
        Map propriedades = this.propriedadeService.getPropriedadeValor();
        Map modulos = this.moduloService.getMapModulosAtivos();
        Map funcionalidades = this.funcionalidadeService.getMapFuncionalidadeAtivas();
        boolean liberarPaf = FilialCommonRN.getInstance().liberarOsPorPerfilPaf(SessaoUtil.getSessao());
        List ecommercesAtivos = ConfiguracaoEcommerceCommonRN.getInstance().buscarListaAtivos().stream().map(ConfiguracaoEcommerce::getTipoIntegracao).collect(Collectors.toList());
        UsuarioCorrenteDTO usuarioCorrenteDTO = new UsuarioCorrenteDTO(usuario, SessaoUtil.autoridades(), filial, propriedades, notificacoes, licencas, this.getMenusAtivos(usuario), modulos, funcionalidades, dadosLicencaResumido, acessosRapidos, null, provedorWeb, ecommercesAtivos, liberarPaf, null);
        if (!StringUtil.stringNullOrEmpty((String)usuario.getCaminhoImagemUsuario())) {
            usuario.setCaminhoImagemUsuario(this.saveFile.publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Usuario, TipoImagem.Pequena, usuario.getCaminhoImagemUsuario()));
        }
        return usuarioCorrenteDTO;
    }

    @RequestMapping(value={"/api/logout"})
    @DBTransaction
    public void logout() throws UnicoMensagemUsuarioException {
        String ip = BeanUtil.getClientIP((HttpServletRequest)this.httpServletRequest);
        String navegador = BeanUtil.getUserAgent((HttpServletRequest)this.httpServletRequest);
        if (ControleRN.getInstance().getNivelPoliticaSeguranca() != NivelPoliticaSeguranca.BAIXA) {
            Usuario usuario = SessaoUtil.getSessao().getUsuario();
            String codigo = usuario.isUsuarioRemoto() ? usuario.getEmail() : usuario.getCodigo();
            AccessLogRN.getInstance().logarAcesso(SessaoUtil.getSessao(), usuario.getId(), codigo, ip, navegador, AccessLogStatus.LOGOUT, "Usu\u00e1rio efetuou logout");
        }
        SessaoWebRN.getInstance().apagaSessaoWeb(ContextoHolder.getJti());
    }

    @RequestMapping(value={"/api/change-place-work"})
    @DBTransaction
    public UsuarioCorrenteDTO alterarLocalTrabalho(@RequestParam(required=false) Long idFilial, @RequestParam(required=false) Long idLocalEstoque) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        if ((LicencaManager.getInstance().isEnterprise() || LicencaManager.getInstance().isDemonstracao()) && NumberUtil.longNullOuZero((Long)idFilial)) {
            throw new UnicoMensagemUsuarioException("WWW459", "Por favor informe a filial.");
        }
        if (NumberUtil.longNullOuZero((Long)idFilial)) {
            idFilial = sessao.getIdFilial();
        }
        Usuario usuario = sessao.getUsuario();
        if (this.funcionalidadeService.isAtiva(Funcionalidade.LOCAL_ESTOQUE)) {
            usuario.setIdLocalEstoqueTrabalho(idLocalEstoque);
            UsuarioRN.getInstance().alterarLocalTrabalho(sessao, idFilial, idLocalEstoque);
        } else {
            UsuarioRN.getInstance().alterarLocalTrabalho(sessao, idFilial);
        }
        this.cacheService.clear();
        return this.getAccount();
    }

    @GetMapping(value={"api/disco"})
    public DadosDiscoWrapper dadosDisco() {
        DadosDiscoWrapper dados = new DadosDiscoWrapper();
        File file = new File(".");
        double freeSpacePercentage = (double)file.getFreeSpace() / (double)file.getTotalSpace() * 100.0;
        dados.setDiskFreeSpace(Double.valueOf(freeSpacePercentage));
        return dados;
    }

    private ProvedorWeb getProvedorWeb() {
        ProvedorWeb provedorWeb;
        try {
            provedorWeb = NfseManagerWeb.getProvedorWeb((Sessao)SessaoUtil.getSessao());
        }
        catch (UnicoMensagemUsuarioException ex) {
            provedorWeb = null;
        }
        return provedorWeb;
    }

    private List<ItemMenuWeb> getMenusAtivos(Usuario usuario) {
        List menusPerfil;
        String idPerfil = TipoCache.ID_MENU_PERFIL.getId().concat(usuario.getIdPerfil().toString());
        if (usuario.isAdministrador()) {
            idPerfil = idPerfil + TipoCache.ID_ADMIN;
        }
        if (usuario.getTipoAcesso() != null && !TipoAcesso.USUARIO.equals((Object)usuario.getTipoAcesso())) {
            idPerfil = idPerfil + "_".concat(usuario.getTipoAcesso().name());
        }
        if ((menusPerfil = (List)this.getCache(idPerfil)) == null) {
            List menusExcluidos = CarregaMenuWeb.getProgramasExcluidos((Usuario)usuario, (boolean)this.unipluswebProperties.getAmbiente().isLocal());
            Map permissoes = MenuSistemaManager.getInstance().getMenuWeb(SessaoUtil.getSessao(), usuario.getIdPerfil(), menusExcluidos);
            menusPerfil = new MenuManager().mountMenu(this.menuService.menu, permissoes, usuario, null);
            this.cacheService.put((Object)idPerfil, (Object)menusPerfil);
        }
        menusPerfil.sort(Comparator.comparingInt(ItemMenuWeb::getPeso));
        return menusPerfil;
    }

    private Object getCache(String id) {
        SimpleValueWrapper valueCache = (SimpleValueWrapper)this.cacheService.get((Object)id);
        return valueCache != null ? valueCache.get() : null;
    }
}

