/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.security.oauth2;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.sql.Sql;
import br.intelidata.commons.core.sql.usql.ColunaUPD;
import br.intelidata.commons.core.sql.usql.UUpdate;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.EnumSimNao;
import br.intelidata.commons.domain.pojo.Controle;
import br.intelidata.commons.domain.pojo.Perfil;
import br.intelidata.commons.domain.pojo.Usuario;
import br.intelidata.commons.domain.pojo.enuns.AccessLogStatus;
import br.intelidata.commons.domain.pojo.enuns.NivelPoliticaSeguranca;
import br.intelidata.commons.domain.pojo.enuns.TipoAcesso;
import br.intelidata.commons.domain.pojo.enuns.TypeIpAccess;
import br.intelidata.commons.domain.regranegocio.AccessLogRN;
import br.intelidata.commons.domain.regranegocio.ControleRN;
import br.intelidata.commons.domain.regranegocio.IpAccessRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.PerfilRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.UsuarioRN;
import br.intelidata.core.sgdb.IConnectionHandler;
import br.intelidata.uniplusweb.config.UnipluswebProperties;
import br.intelidata.uniplusweb.core.spring.multitenant.TenantService;
import br.intelidata.uniplusweb.core.util.BeanUtil;
import br.intelidata.uniplusweb.core.util.JsonUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.security.AutenticacaoException;
import br.intelidata.uniplusweb.security.oauth2.CustomAuthenticationProvider;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import br.intelidata.uniplusweb.service.LicencaService;
import br.intelidata.uniplusweb.service.UsuarioRemotoService;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;

@Component
public class CustomAuthenticationProvider
implements AuthenticationProvider {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private HttpServletRequest httpServletRequest;
    @Autowired
    private IConnectionHandler connectionHandler;
    @Autowired
    private TenantService tenantService;
    @Autowired
    private UsuarioRemotoService usuarioRemotoService;
    @Autowired
    private LicencaService licencaService;
    @Autowired
    private FuncionalidadeService funcionalidadeService;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private UnipluswebProperties unipluswebProperties;

    private void registraAcessoConcedido(Usuario usuario, String ip, String navegador, NivelPoliticaSeguranca nivelPoliticaSeguranca) throws UnicoMensagemUsuarioException {
        if (nivelPoliticaSeguranca != NivelPoliticaSeguranca.BAIXA) {
            AccessLogRN.getInstance().logarAcesso(SessaoUtil.getSessao(), usuario.getId(), usuario.getCodigo(), ip, navegador, AccessLogStatus.SUCESSO, "Acesso concedido");
            usuario.setBloqueado(EnumSimNao.NAO.getId().intValue());
            usuario.setTentativasAcesso(0);
            usuario.setDataHoraDesbloqueio(null);
            usuario.setObservacaoBloqueio(null);
            UsuarioRN.getInstance().alterar(usuario, SessaoUtil.getSessao());
        }
    }

    private Response registraAcessoNegado(Usuario usuario, String ip, String navegador, NivelPoliticaSeguranca nivelPoliticaSeguranca, String mensagem, boolean bloquearLogin) throws UnicoMensagemUsuarioException {
        if (usuario != null && nivelPoliticaSeguranca != NivelPoliticaSeguranca.BAIXA) {
            String motivo = usuario.getInativo().equals(EnumSimNao.SIM.getId()) ? "Usu\u00e1rio inativo" : "Usu\u00e1rio e/ou senha incorretos";
            AccessLogStatus status = usuario.getBloqueado() == EnumSimNao.SIM.getId().intValue() ? AccessLogStatus.ACESSO_BLOQUEADO : AccessLogStatus.FALHA;
            AccessLogRN.getInstance().logarAcesso(SessaoUtil.getSessao(), usuario.getId(), usuario.getCodigo(), ip, navegador, status, motivo);
            int qtdAcessoPermitido = 120;
            if (AccessLogRN.getInstance().bloquearAcesso(ip, qtdAcessoPermitido)) {
                IpAccessRN.getInstance().save(SessaoUtil.getSessao(), ip, TypeIpAccess.GRAY);
            }
            if (usuario.getBloqueado() == EnumSimNao.NAO.getId().intValue()) {
                Sql sql;
                UUpdate updateUsuario;
                LocalDateTime dataHora = DataHoraFactory.getDataHora((Long)usuario.getIdFilialTrabalho());
                boolean somarAcesso = true;
                if (usuario.getDataHoraDesbloqueio() != null) {
                    Duration duration = Duration.between(dataHora, usuario.getDataHoraDesbloqueio());
                    if (Math.abs(duration.toHours()) > (long)this.unipluswebProperties.getAccessConfiguration().getMaxTimeInHours()) {
                        if (usuario.getBloqueado() == EnumSimNao.NAO.getId().intValue()) {
                            updateUsuario = new UUpdate(UsuarioRN.getInstance().getTabela(), usuario.getId(), new ColunaUPD[]{new ColunaUPD("bloqueado", Integer.valueOf(1))});
                            sql = new Sql(updateUsuario);
                            sql.executaUpdate(false);
                            sql.close();
                        }
                        mensagem = "O acesso foi bloqueado por v\u00e1rias tentativas incorretas. Por favor contate o administrador!";
                        somarAcesso = false;
                        bloquearLogin = true;
                    } else if (!dataHora.isEqual(usuario.getDataHoraDesbloqueio()) && dataHora.isBefore(usuario.getDataHoraDesbloqueio())) {
                        somarAcesso = false;
                        mensagem = this.getMensagemDuracao(dataHora, usuario.getDataHoraDesbloqueio());
                        bloquearLogin = true;
                    }
                }
                if (somarAcesso) {
                    int tentativas = usuario.getTentativasAcesso() + 1;
                    updateUsuario = new UUpdate(UsuarioRN.getInstance().getTabela(), usuario.getId(), new ColunaUPD[]{new ColunaUPD("tentativasacesso", Integer.valueOf(tentativas)), new ColunaUPD("observacaobloqueio", usuario.getInativo().equals(EnumSimNao.SIM.getId()) ? AccessLogStatus.USUARIO_INATIVO.getId() : AccessLogStatus.FALHA.getId())});
                    if (tentativas > 2 && tentativas % 3 == 0) {
                        LocalDateTime horaDesbloqueio = this.getHoraDesbloqueio(tentativas, usuario);
                        updateUsuario.getColunaUPDs().add(new ColunaUPD("datahoradesbloqueio", horaDesbloqueio));
                        mensagem = this.getMensagemDuracao(dataHora, horaDesbloqueio);
                        bloquearLogin = true;
                        Duration duration = Duration.between(dataHora, horaDesbloqueio);
                        if (Math.abs(duration.toHours()) >= (long)this.unipluswebProperties.getAccessConfiguration().getMaxTimeInHours() && usuario.getBloqueado() == EnumSimNao.NAO.getId().intValue()) {
                            updateUsuario.getColunaUPDs().add(new ColunaUPD("bloqueado", Integer.valueOf(1)));
                            mensagem = "Por favor contate o administrador!";
                            bloquearLogin = true;
                        }
                    } else {
                        mensagem = mensagem + " Voc\u00ea possui mais " + (tentativas == 1 ? "duas tentativas." : "uma tentativa.");
                    }
                    sql = new Sql(updateUsuario);
                    sql.executaUpdate(false);
                    sql.close();
                }
            }
        }
        return new Response(mensagem, bloquearLogin);
    }

    private String getMensagemDuracao(LocalDateTime dataHora, LocalDateTime horaDesbloqueio) {
        String mensagem;
        Duration duration = Duration.between(dataHora, horaDesbloqueio);
        long horas = Math.abs(duration.toHours());
        if (horas > 0L) {
            mensagem = duration.toMinutes() > 60L ? "Voc\u00ea pode fazer login novamente em " + String.format("%d hora e %02d minutos", duration.getSeconds() / 3600L, duration.getSeconds() % 3600L / 60L) + " ou contate o administrador!" : "Voc\u00ea pode fazer login novamente em " + horas + " hora ou contate o administrador!";
        } else {
            long minutos = Math.abs(duration.toMinutes());
            mensagem = "Voc\u00ea pode fazer login novamente em " + minutos + " minuto" + (minutos > 1L ? "s" : "") + " ou contate o administrador!";
        }
        return mensagem;
    }

    private LocalDateTime getHoraDesbloqueio(int numeroTentativas, Usuario usuario) {
        BigDecimal config = new BigDecimal(this.unipluswebProperties.getAccessConfiguration().getTimeInMinutes());
        BigDecimal minutos = config.divide(new BigDecimal(3), 10, 6).multiply(new BigDecimal(numeroTentativas));
        return DataHoraFactory.getDataHora((Long)usuario.getIdFilialTrabalho()).plusMinutes(minutos.intValue());
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        Usuario usuario = null;
        NivelPoliticaSeguranca nivelPoliticaSeguranca = null;
        String ip = BeanUtil.getClientIP((HttpServletRequest)this.httpServletRequest);
        String navegador = BeanUtil.getUserAgent((HttpServletRequest)this.httpServletRequest);
        String tenant = ContextoHolder.getTenant();
        String usuario_digitado = authentication.getName();
        String senha_digitada = authentication.getCredentials().toString();
        try {
            this.tenantService.validaTenant(tenant);
            this.tenantService.atualizaUltimoAcesso(tenant);
            this.connectionHandler.createConnection(true);
            Controle controle = ControleRN.getInstance().buscar();
            if (controle.isAtualizandoBase()) {
                throw new AutenticacaoException("A base de dados est\u00e1 sendo atualizada e estar\u00e1 dispon\u00edvel em alguns instantes.");
            }
            nivelPoliticaSeguranca = controle.getPoliticaSeguranca();
            if (nivelPoliticaSeguranca != NivelPoliticaSeguranca.BAIXA && this.funcionalidadeService.isAtiva(Funcionalidade.ACESSO_IP) && (controle.getTipoAcessoIp() == TypeIpAccess.WHITE && !IpAccessRN.getInstance().ipExists(BeanUtil.getClientIP((HttpServletRequest)this.httpServletRequest), TypeIpAccess.WHITE) || IpAccessRN.getInstance().ipExists(BeanUtil.getClientIP((HttpServletRequest)this.httpServletRequest), TypeIpAccess.BLACK))) {
                throw new AutenticacaoException("Acesso n\u00e3o permitido a partir desse IP. Por favor contate o admnistrador", true);
            }
            usuario = UsuarioRN.getInstance().buscarPorCodigoLoginWeb(usuario_digitado);
            if (usuario == null && StringUtil.emailValido((String)usuario_digitado)) {
                usuario = this.usuarioRemotoService.buscarUsuarioRemoto(usuario_digitado, senha_digitada);
            }
            if (usuario == null || usuario.getId().equals(UsuarioRN.ID_USUARIO_DEFAULT)) {
                throw new AutenticacaoException("Usu\u00e1rio ou senha inv\u00e1lidos.");
            }
            if (usuario.getInativo() == 1) {
                throw new AutenticacaoException("Usu\u00e1rio inativo.");
            }
            if (!this.passwordEncoder.matches((CharSequence)senha_digitada, usuario.getSenha())) {
                throw new AutenticacaoException("Usu\u00e1rio ou senha inv\u00e1lidos.");
            }
            if (usuario.getIdFilialTrabalho() == null || FilialRN.getInstance().buscarPorId(usuario.getIdFilialTrabalho()) == null) {
                throw new AutenticacaoException("Filial de trabalho n\u00e3o definida. Contate o administrador.");
            }
            if (TipoAcesso.TECNICO.equals((Object)usuario.getTipoAcesso())) {
                UsernamePasswordAuthenticationToken user = (UsernamePasswordAuthenticationToken)authentication;
                LinkedHashMap m = (LinkedHashMap)authentication.getDetails();
                m.put("tecnico", "true");
            }
            this.licencaService.getSistema();
            this.licencaService.getDadosLicenca();
            if (nivelPoliticaSeguranca != NivelPoliticaSeguranca.BAIXA) {
                LocalDateTime dataHora = DataHoraFactory.getDataHora((Long)usuario.getIdFilialTrabalho());
                if (usuario.getBloqueado() == EnumSimNao.SIM.getId().intValue()) {
                    throw new AutenticacaoException("Por favor contate o administrador!");
                }
                if (usuario.getDataHoraDesbloqueio() != null && !dataHora.isEqual(usuario.getDataHoraDesbloqueio()) && dataHora.isBefore(usuario.getDataHoraDesbloqueio())) {
                    Duration duration = Duration.between(DataHoraFactory.getDataHora((Long)usuario.getIdFilialTrabalho()), usuario.getDataHoraDesbloqueio());
                    long horas = Math.abs(duration.toHours());
                    if (horas != 0L) {
                        throw new AutenticacaoException("O acesso ao sistema est\u00e1 bloqueado, por favor aguarde " + horas + " horas, ou contate o administrador.");
                    }
                    throw new AutenticacaoException("O acesso ao sistema est\u00e1 bloqueado, por favor aguarde " + Math.abs(duration.toMinutes()) + " minutos, ou contate o administrador.");
                }
                if (!usuario.isAdministrador() && !PerfilRN.getInstance().validarHorarioAcessoWeb((Perfil)PerfilRN.getInstance().buscarPorId(usuario.getIdPerfil()), dataHora)) {
                    throw new AutenticacaoException("O acesso ao sistema n\u00e3o est\u00e1 dispon\u00edvel para esse hor\u00e1rio.");
                }
            }
            this.registraAcessoConcedido(usuario, ip, navegador, nivelPoliticaSeguranca);
            List<SimpleGrantedAuthority> grantedAuthorities = Collections.singletonList(new SimpleGrantedAuthority("ROLE_USER"));
            User user = new User(usuario.getId().toString(), "", new ArrayList());
            UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = new UsernamePasswordAuthenticationToken((Object)user, (Object)senha_digitada, grantedAuthorities);
            return usernamePasswordAuthenticationToken;
        }
        catch (AutenticacaoException ex) {
            Response response;
            try {
                response = usuario != null && !NumberUtil.longNullOuZero((Long)usuario.getIdFilialTrabalho()) ? this.registraAcessoNegado(usuario, ip, navegador, nivelPoliticaSeguranca, ex.getMessage(), ex.isBloquearLogin()) : new Response(ex.getMessage(), false);
            }
            catch (UnicoMensagemUsuarioException exAcessoNegado) {
                this.log.error("Erro ao registro o acesso negado", (Throwable)exAcessoNegado);
                response = new Response("O servidor n\u00e3o pode validar o usu\u00e1rio e/ou senha", true);
            }
            throw new AutenticacaoException(JsonUtil.toJson((Object)response));
        }
        catch (UnicoMensagemUsuarioException exAcessoConcedido) {
            this.log.error("Erro ao registro o acesso concedido", (Throwable)exAcessoConcedido);
            Response response = new Response("O servidor n\u00e3o pode validar o usu\u00e1rio e/ou senha", true);
            throw new AutenticacaoException(JsonUtil.toJson((Object)response));
        }
        catch (Throwable ex) {
            this.log.error("N\u00e3o foi poss\u00edvel prosseguir com a autentica\u00e7\u00e3o", ex);
            throw new AutenticacaoException("O servidor n\u00e3o pode validar o usu\u00e1rio e/ou senha", true);
        }
        finally {
            if (this.connectionHandler.isConnected()) {
                this.connectionHandler.releaseConnection();
            }
        }
    }

    public boolean supports(Class<?> authentication) {
        return authentication.equals(UsernamePasswordAuthenticationToken.class);
    }
}

