/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.service;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.FormacaoPreco;
import br.intelidata.commons.domain.pojo.enuns.ModoCalculoPreco;
import br.intelidata.commons.domain.pojo.enuns.TipoValorCalculoCusto;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import java.math.BigDecimal;
import org.springframework.stereotype.Service;

@Service
public class FormacaoPrecoService {
    public void validarFormacaoPreco(FormacaoPreco formacaoPreco) throws UnicoMensagemUsuarioException {
        String descProduto = "";
        if (formacaoPreco.getProduto() != null) {
            descProduto = "do produto " + formacaoPreco.getProduto().getCodigo() + " - " + formacaoPreco.getProduto().getDescricao() + " ";
        }
        Filial filial = (Filial)FilialRN.getInstance().buscarPorId(formacaoPreco.getIdFilial());
        if (!PropriedadeRN.getInstance().getPropriedadeBoolean(filial, 665)) {
            if (formacaoPreco.getPrecoUltimaCompra().compareTo(BigDecimal.ZERO) == 0) {
                if (formacaoPreco.getTipoValorCalculoCusto() == TipoValorCalculoCusto.CUSTO_MEDIO) {
                    throw new UnicoMensagemUsuarioException("WPRC21", "O custo m\u00e9dio " + descProduto + "deve ser maior que zero");
                }
                throw new UnicoMensagemUsuarioException("WPRC22", "O pre\u00e7o de compra " + descProduto + "deve ser maior que zero");
            }
            if (formacaoPreco.getCustoCompra().compareTo(BigDecimal.ZERO) == 0) {
                throw new UnicoMensagemUsuarioException("WPRC23", "O custo da compra " + descProduto + " deve ser maior que zero");
            }
        }
        if (formacaoPreco.getModoCalculoPreco() == ModoCalculoPreco.MARGEM_CONTRIBUICAO && formacaoPreco.getSomaPercentuaisPreco(Boolean.valueOf(PropriedadeRN.getInstance().getPropriedadeBoolean(filial, 877))).compareTo(NumberUtil.CEM) > 0) {
            throw new UnicoMensagemUsuarioException("WPRC24", "Total dos percentuais " + descProduto + " n\u00e3o pode ser maior ou igual a 100");
        }
        if (!PropriedadeRN.getInstance().getPropriedadeBoolean(filial, 1027) && formacaoPreco.getPrecoVendaAjustado().compareTo(BigDecimal.ZERO) == 0) {
            throw new UnicoMensagemUsuarioException("WPRC18", "O pre\u00e7o de venda ajustado " + descProduto + "deve ser maior que zero");
        }
    }
}

