/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.service.monitor;

import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.uniplusweb.core.util.DateUtil;
import br.intelidata.uniplusweb.core.util.FileUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.monitor.DadosCPUWrapper;
import br.intelidata.uniplusweb.service.monitor.MonitorEndPointWrapper;
import br.intelidata.uniplusweb.service.monitor.MonitorTenantWrapper;
import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Service;

@Service
public class MonitorService {
    private final List<MonitorTenantWrapper> monitoramento = new ArrayList();
    private final DadosCPUWrapper monitorCpu = new DadosCPUWrapper();

    public void executar(String tenant, ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        long t1 = System.currentTimeMillis();
        chain.doFilter(request, response);
        long t2 = System.currentTimeMillis();
        if (!StringUtil.stringNullOrEmpty((String)tenant) && request instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            long tempo = t2 - t1;
            String method = httpRequest.getMethod();
            String baseUri = httpRequest.getRequestURI().replaceAll("/\\d+", "") + "_" + method;
            boolean achouRotaIgnorada = this.rotasIgnoradas().stream().anyMatch(p -> baseUri.toLowerCase().contains(p.toLowerCase()));
            if (!achouRotaIgnorada) {
                boolean deuFalha = false;
                if (response instanceof HttpServletResponse) {
                    HttpServletResponse hsr = (HttpServletResponse)response;
                    deuFalha = hsr.getStatus() != 200 && hsr.getStatus() != 500;
                }
                MonitorTenantWrapper monitorTenant = this.monitoramento.stream().filter(t -> t.getTenant().equalsIgnoreCase(tenant)).findFirst().orElseGet(() -> {
                    MonitorTenantWrapper novoTenant = new MonitorTenantWrapper(tenant, new ArrayList());
                    this.monitoramento.add(novoTenant);
                    return novoTenant;
                });
                MonitorEndPointWrapper monitorEndPoint = monitorTenant.getMonitoresEndPoint().stream().filter(m -> m != null && m.getEndpoint().equalsIgnoreCase(baseUri)).findFirst().orElseGet(() -> {
                    MonitorEndPointWrapper novoEndPoint = new MonitorEndPointWrapper(baseUri);
                    monitorTenant.getMonitoresEndPoint().add(novoEndPoint);
                    return novoEndPoint;
                });
                monitorEndPoint.addTempo(tempo);
                monitorEndPoint.addContador();
                if (deuFalha) {
                    monitorEndPoint.addContadorPerda();
                }
            }
        }
    }

    public void monitorarCpu(int totalThread, int threadsAtivas, Instant start) {
        this.monitorCpu.setAvailableProcessors(ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors());
        String SOVersion = ManagementFactory.getOperatingSystemMXBean().getName() + " " + ManagementFactory.getOperatingSystemMXBean().getVersion() + " (" + ManagementFactory.getOperatingSystemMXBean().getArch() + ")";
        this.monitorCpu.setSOVersion(SOVersion);
        this.monitorCpu.setThreads(totalThread - threadsAtivas);
        this.monitorCpu.setTotalThreads(totalThread);
        long segundos = Duration.between(start, Instant.now()).getSeconds();
        this.monitorCpu.setTempoExecucao(DateUtil.formataDataHora((Temporal)DataHoraFactory.ofInstantUTC((Instant)Instant.ofEpochSecond(segundos)), (String)"HH:mm:ss"));
        Double percCpu = ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getSystemCpuLoad();
        String hora = DateUtil.formataDataHora((Temporal)DataHoraFactory.ofInstant((Instant)Instant.now()), (String)"HH:mm:ss");
        DadosCPUWrapper.Cpu cpu = new DadosCPUWrapper.Cpu(percCpu, hora);
        this.monitorCpu.getListaCpu().adicionar((Object)cpu);
        File file = new File(".");
        this.monitorCpu.setDiskFreeSpace(FileUtil.toGB((Long)file.getFreeSpace()));
        this.monitorCpu.setDiskTotalSpace(FileUtil.toGB((Long)file.getTotalSpace()));
    }

    public List<MonitorTenantWrapper> getMonitoramento() {
        return this.monitoramento;
    }

    public DadosCPUWrapper getMonitorCpu() {
        return this.monitorCpu;
    }

    private List<String> rotasIgnoradas() {
        ArrayList<String> rotas = new ArrayList<String>();
        rotas.add("gerenciador-licencas");
        rotas.add("batch");
        rotas.add("configuracoes");
        return rotas;
    }
}

