/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.batch;

import br.intelidata.api.batch.CreateTask;
import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.InvalidCronExpressionException;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.JSONUtil;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.cron.Cron;
import br.intelidata.commons.cron.CronExpression;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.domain.pojo.batch.Queue;
import br.intelidata.commons.domain.pojo.batch.Task;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.pojo.enuns.batch.TaskStatus;
import br.intelidata.commons.domain.pojo.enuns.batch.TypeQueue;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.wrapper.ArquivoInfoWrapper;
import br.intelidata.uniplusweb.adm.SystemStatusService;
import br.intelidata.uniplusweb.adm.job.Database;
import br.intelidata.uniplusweb.config.UnipluswebProperties;
import br.intelidata.uniplusweb.core.grid.FilterField;
import br.intelidata.uniplusweb.core.grid.Operator;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.spring.multitenant.Tenant;
import br.intelidata.uniplusweb.core.spring.multitenant.TenantService;
import br.intelidata.uniplusweb.core.util.BeanUtil;
import br.intelidata.uniplusweb.core.util.DateUtil;
import br.intelidata.uniplusweb.core.util.FileUtil;
import br.intelidata.uniplusweb.core.util.JsonUtil;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.SystemUtil;
import br.intelidata.uniplusweb.service.ConnectionOAuth2Service;
import br.intelidata.uniplusweb.service.StorageService;
import br.intelidata.uniplusweb.service.monitor.DadosCPUWrapper;
import br.intelidata.uniplusweb.service.monitor.MonitorService;
import br.intelidata.uniplusweb.service.monitor.MonitorTenantWrapper;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.batch.BatchController;
import br.intelidata.uniplusweb.web.rest.app.batch.Periodo;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.batch.serices.QueueService;
import br.intelidata.uniplusweb.web.rest.app.batch.serices.TaskService;
import br.intelidata.uniplusweb.web.rest.app.batch.wrappers.DadosMemoriaWrapper;
import br.intelidata.uniplusweb.web.rest.app.batch.wrappers.EstatisticasWraper;
import br.intelidata.uniplusweb.web.rest.app.batch.wrappers.FiltroAvancadoWrapper;
import br.intelidata.uniplusweb.web.rest.app.client.schedulers.backup.BackupPrimarioScheduler;
import br.intelidata.uniplusweb.web.rest.app.client.thread.TaskProcessor;
import br.intelidata.uniplusweb.web.rest.app.crud.recursoexterno.ParamsRecursoExterno;
import br.intelidata.uniplusweb.web.rest.app.crud.recursoexterno.RecursoExternoJob;
import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/jobs-admin/batch"})
public class BatchController {
    private static final Logger log = LoggerFactory.getLogger(BatchController.class);
    private final TaskManager taskManager;
    private final TaskService taskService;
    private final QueueService queueService;
    private final TaskProcessor taskProcessor;
    private final StorageService storageService;
    private final TenantService tenantService;
    private final MonitorService monitorService;
    private final ResponseEntityService responseEntityService;
    private final ConnectionOAuth2Service connectionOAuth2Service;
    private final UnipluswebProperties unipluswebProperties;

    public BatchController(TaskService taskService, QueueService queueService, TaskProcessor taskProcessor, StorageService storageService, TaskManager taskManager, TenantService tenantService, ResponseEntityService responseEntityService, ConnectionOAuth2Service connectionOAuth2Service, UnipluswebProperties unipluswebProperties, MonitorService monitorService) {
        this.taskService = taskService;
        this.queueService = queueService;
        this.taskProcessor = taskProcessor;
        this.storageService = storageService;
        this.taskManager = taskManager;
        this.tenantService = tenantService;
        this.monitorService = monitorService;
        this.responseEntityService = responseEntityService;
        this.connectionOAuth2Service = connectionOAuth2Service;
        this.unipluswebProperties = unipluswebProperties;
    }

    @PostMapping(value={"/pause/{paused}"})
    public void pauseProcessor(@PathVariable boolean paused) {
        this.taskProcessor.pause(paused);
    }

    @PostMapping(value={"/queues/pause/{code}/{paused}"})
    public void pause(@PathVariable int code, @PathVariable boolean paused) {
        this.queueService.pause(code, paused);
    }

    @GetMapping(value={"/queues"})
    public List<Queue> getQueues() {
        return this.queueService.getQueues();
    }

    @GetMapping(value={"/tarefas-recorrentes-combo"})
    public List<Task> getTarefasRecorrentesCombo() {
        return this.taskService.getTasks(null, new TaskStatus[]{TaskStatus.SCHEDULED, TaskStatus.INACTIVE});
    }

    @PostMapping(value={"/tasks"})
    public List<Task> getTasks(@RequestBody FiltroAvancadoWrapper filtro) {
        List tasks = this.taskService.getTasks(filtro);
        tasks.forEach(task -> {
            if (task.getTaskStatus().equals((Object)TaskStatus.SCHEDULED)) {
                if (task.getTipo().equalsIgnoreCase("MANUAL")) {
                    LocalDateTime dateTime = task.getT0();
                    char tipo = task.getCronExpression().charAt(task.getCronExpression().length() - 1);
                    int intervalo = Integer.parseInt(Util.apenasNumeros((String)task.getCronExpression()));
                    dateTime = tipo == 'm' ? dateTime.plusMinutes(intervalo) : dateTime.plusHours(intervalo);
                    task.setProxima(dateTime.withSecond(0));
                } else if (task.getTipo().equalsIgnoreCase("FIXO")) {
                    LocalDateTime nextLaunch;
                    String[] hora = task.getCronExpression().split(":");
                    LocalTime horaTask = LocalTime.of(Integer.parseInt(hora[0]), Integer.parseInt(hora[1]));
                    LocalDateTime agora = LocalDateTime.now();
                    if (agora.isAfter(nextLaunch = LocalDateTime.of(task.getT0().toLocalDate(), horaTask))) {
                        nextLaunch = nextLaunch.plusDays(1L);
                    }
                    task.setProxima(nextLaunch);
                } else {
                    CronExpression cronExpression = CronExpression.create((String)task.getCronExpression());
                    LocalDateTime proxima = DataHoraFactory.ofInstantUTC((Instant)cronExpression.next(task.getT0().toInstant(ZoneOffset.UTC), (ZoneId)ZoneOffset.UTC));
                    task.setProxima(proxima);
                }
            }
        });
        return tasks;
    }

    @PostMapping(value={"/tasks/pause/{taskUuid}/{paused}/{isTask}"})
    public void pauseScheduled(@PathVariable UUID taskUuid, @PathVariable boolean paused, @PathVariable boolean isTask) {
        if (isTask) {
            this.taskProcessor.pauseTask(taskUuid, paused);
        } else {
            this.taskProcessor.pauseSchedule(taskUuid, paused);
        }
    }

    @PostMapping(value={"/tasks/update"})
    public void updateTask(@RequestBody Task task) throws UnicoMensagemUsuarioException {
        try {
            if (task.getTipo().equalsIgnoreCase("CRON")) {
                CronExpression.create((String)task.getCronExpression());
            }
        }
        catch (InvalidCronExpressionException e) {
            throw new UnicoMensagemUsuarioException("BATCH2", "Express\u00e3o Cron inv\u00e1lida.");
        }
        this.taskService.update(task);
    }

    @PostMapping(value={"/tasks/delete/{taskUuid}"})
    public void deleteTask(@PathVariable UUID taskUuid) throws UnicoMensagemUsuarioException {
        this.taskProcessor.interrupt(taskUuid);
    }

    @RequestMapping(value={"/restaurar-backup/{tenant}"}, method={RequestMethod.POST})
    public void restaurarBkp(@RequestPart(value="file") MultipartFile multipartFile, @PathVariable(value="tenant") String codigoTenant) throws UnicoMensagemUsuarioException {
        Tenant tenant = this.tenantService.getTenant(codigoTenant, false);
        if (tenant.getInicializado() == 1) {
            throw new UnicoMensagemUsuarioException("BATCH3", "Tenant j\u00e1 inicializado. A restaura\u00e7\u00e3o n\u00e3o pode ser concluida.");
        }
        1 iCreateTask = new /* Unavailable Anonymous Inner Class!! */;
        iCreateTask.createTask((Object)codigoTenant);
    }

    @GetMapping(value={"/cpu"})
    public DadosCPUWrapper dadosCPU() {
        return this.monitorService.getMonitorCpu();
    }

    @GetMapping(value={"/memoria"})
    public DadosMemoriaWrapper dadosMemoria() {
        DadosMemoriaWrapper dados = new DadosMemoriaWrapper();
        dados.setMemoryTotalSpace(FileUtil.toGB((Long)((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getTotalPhysicalMemorySize()));
        dados.setMemoryFreeSpace(FileUtil.toGB((Long)((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getFreePhysicalMemorySize()));
        dados.setJavaHeapMax(FileUtil.toGB((Long)ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax()));
        dados.setJavaHeapUsed(FileUtil.toMB((Long)ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed()));
        dados.setJavaNonHeapUsed(FileUtil.toMB((Long)ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage().getUsed()));
        return dados;
    }

    @GetMapping(value={"/total-tenants"})
    public int totalTeanats() {
        return this.taskService.getTenants().size();
    }

    @GetMapping(value={"/total-tarefas-fila"})
    public int totalTarefasNaFila() {
        return this.taskManager.getTasks(new TaskStatus[]{TaskStatus.ENQUEUED}).size();
    }

    @GetMapping(value={"/total-recorrente-pausada"})
    public int totalTarefasRecorrentesPausadas() {
        return this.taskManager.getTasks(new TaskStatus[]{TaskStatus.PAUSE_SCHEDULE}).size();
    }

    @GetMapping(value={"/total-fila-pausada"})
    public int totalFilaPausadas() {
        return (int)this.queueService.getQueues().stream().filter(Queue::isPaused).count();
    }

    @GetMapping(value={"/total-tarefas-falhas"})
    public int totalTarefasFalhas() {
        FiltroAvancadoWrapper filtro = new FiltroAvancadoWrapper();
        FilterField filterPeriodo = new FilterField();
        filterPeriodo.setField("periodo");
        filterPeriodo.setFilter(Operator.OPERADOR_IGUAL.getDescricao());
        filterPeriodo.setType("String");
        filterPeriodo.setValue1(Periodo._24H.name());
        FilterField filterStatus = new FilterField();
        filterStatus.setField("taskStatus");
        filterStatus.setFilter(Operator.OPERADOR_IGUAL.getDescricao());
        filterStatus.setType("String");
        filterStatus.setValue1(TaskStatus.FAILED.name());
        filtro.getFilterField().add(filterPeriodo);
        filtro.getFilterField().add(filterStatus);
        List tasks = this.taskService.getTasks(filtro);
        return tasks != null ? tasks.size() : 0;
    }

    @GetMapping(value={"/proximo-agendamento"})
    public String proximoAgendamento() {
        LocalDateTime[] proximaMaisPerto = new LocalDateTime[]{null};
        List tasks = this.taskManager.getTasks(new TaskStatus[]{TaskStatus.SCHEDULED});
        tasks.forEach(task -> {});
        return "";
    }

    @GetMapping(value={"/instancia"})
    public String instancia() {
        return this.unipluswebProperties.getAmbiente().getInstancia().concat(" - ").concat(this.unipluswebProperties.getAmbiente().getAwsami());
    }

    @PostMapping(value={"/metricas"})
    public List<EstatisticasWraper> metricas(@RequestBody FiltroAvancadoWrapper filtro, @RequestParam String group) {
        List tasks = this.taskService.getTasks(filtro);
        HashMap<String, long[]> grupo = new HashMap<String, long[]>();
        Long[] tempoTotal = new Long[]{0L};
        tasks.forEach(task -> {
            String key;
            switch (group) {
                case "FILA": {
                    TypeQueue type = (TypeQueue)EnumUtils.getPorId(TypeQueue.class, (Object)task.getQueue());
                    key = type.getDescricao();
                    break;
                }
                case "TENANT": {
                    key = task.getTenant();
                    break;
                }
                default: {
                    key = task.getTipoJob().getDescricao();
                }
            }
            if (!grupo.containsKey(key)) {
                grupo.put(key, new long[]{0L, 0L, 0L});
            }
            long duracao = ChronoUnit.MILLIS.between(task.getT1(), task.getT2());
            long latencia = ChronoUnit.MILLIS.between(task.getT0(), task.getT1());
            tempoTotal[0] = tempoTotal[0] + duracao;
            long[] valores = (long[])grupo.get(key);
            valores[0] = valores[0] + 1L;
            valores[1] = valores[1] + duracao;
            valores[2] = valores[2] + latencia;
        });
        long tempTotal = tempoTotal[0];
        ArrayList<EstatisticasWraper> estatisticas = new ArrayList<EstatisticasWraper>();
        grupo.forEach((key, value) -> {
            BigDecimal valor2 = BigDecimal.valueOf((double)value[1] / (double)tempTotal * 100.0).setScale(2, RoundingMode.HALF_EVEN);
            String valor3 = DateUtil.formataDataHora((Temporal)DataHoraFactory.ofInstantUTC((Instant)Instant.ofEpochMilli(value[2] / value[0])), (String)"HH:mm:ss.SSS");
            String valor4 = DateUtil.formataDataHora((Temporal)DataHoraFactory.ofInstantUTC((Instant)Instant.ofEpochMilli(value[1] / value[0])), (String)"HH:mm:ss.SSS");
            String valor5 = DateUtil.formataDataHora((Temporal)DataHoraFactory.ofInstantUTC((Instant)Instant.ofEpochMilli(value[1])), (String)"HH:mm:ss.SSS");
            estatisticas.add(new EstatisticasWraper(key, BigDecimal.valueOf(value[0]), valor2, valor3, valor4, valor5));
        });
        return estatisticas;
    }

    @GetMapping(value={"/forcar-atualizacao-todos-tenants"})
    public void atualizarRecursosExternosTodosTenants() {
        Task task = CreateTask.create((Long)TypeQueue.RECURRING_QUEUE.getId(), RecursoExternoJob.class, (String)TipoJob.RECURSOS_EXTERNOS.getDescricao(), (String)Cron.daily(), (TipoJob)TipoJob.RECURSOS_EXTERNOS, (TaskStatus)TaskStatus.SCHEDULED);
        Sessao sessao = SessaoUtil.getSessao();
        JobMetadata metadata = new JobMetadata();
        String parametros = JsonUtil.toJson((Object)new ParamsRecursoExterno());
        metadata.setIdUsuario(sessao.getIdUsuario());
        metadata.setIdFilial(sessao.getIdFilial());
        task.setMetadata(metadata.to());
        task.setParameters(parametros);
        for (Tenant tenant : this.tenantService.getTenants(true)) {
            this.taskManager.launch(CreateTask.createFromRecurring((Task)task, (String)tenant.getCodigo()));
        }
    }

    @GetMapping(value={"/backup"})
    public void agendarBackup(@RequestParam List<String> tenants) throws UnicoMensagemUsuarioException {
        if (ListMapUtil.listNullOrEmpty(tenants)) {
            throw new UnicoMensagemUsuarioException("BATCH4", "Nenhum tenant foi selecionado");
        }
        Task task = CreateTask.create((Long)TypeQueue.RECURRING_QUEUE.getId(), BackupPrimarioScheduler.class, (String)TipoJob.BACKUP.getDescricao(), (String)Cron.daily(), (TipoJob)TipoJob.BACKUP, (TaskStatus)TaskStatus.SCHEDULED);
        Sessao sessao = SessaoUtil.getSessao();
        JobMetadata metadata = new JobMetadata();
        metadata.setIdUsuario(sessao.getIdUsuario());
        metadata.setIdFilial(sessao.getIdFilial());
        task.setMetadata(metadata.to());
        task.setResumo("Backup gerado manualmente");
        for (String tenant : tenants) {
            this.taskManager.launch(CreateTask.createFromRecurring((Task)task, (String)tenant));
        }
    }

    @RequestMapping(value={"/tenants/combo"})
    public List<String> getComboTenants(@RequestParam(required=false) boolean apenasAtivo) {
        List tenants = this.tenantService.getTenants();
        if (apenasAtivo) {
            tenants = tenants.stream().filter(Tenant::isAtivo).collect(Collectors.toList());
        }
        return tenants.stream().map(Tenant::getCodigo).collect(Collectors.toList());
    }

    @RequestMapping(value={"/tenants"})
    public List<Tenant> getTenants() {
        SystemStatusService systemStatusService = (SystemStatusService)BeanUtil.getBean((String)"systemStatusService");
        List databaseList = systemStatusService.getSystemStatus().getDatabaseList();
        List tenants = this.tenantService.getTenants();
        tenants.forEach(tenant -> {
            Optional<Database> base = databaseList.stream().filter(database -> database.getTenant().equals(tenant.getCodigo())).findFirst();
            base.ifPresent(database -> tenant.setSize(database.getSize()));
        });
        return tenants;
    }

    @RequestMapping(value={"/arquivos"})
    @DBAutoCommit
    public List<ArquivoInfoWrapper> getArquivos() throws UnicoMensagemUsuarioException {
        try {
            List tenantsPortal;
            List tenants = this.tenantService.getTenants();
            HashMap<String, String> parametros = new HashMap<String, String>();
            parametros.put("tenant", ContextoHolder.getTenant());
            parametros.put("usuario", SessaoUtil.getSessao().getUsuario().getEmail());
            JSONObject elem = JSONUtil.getJSONObject(parametros);
            ResponseEntity response = this.connectionOAuth2Service.execute("/api/", "/tenant/lista-por-tenant/", elem, List.class, HttpMethod.POST, new Object[0]);
            if (response != null && response.getStatusCode() == HttpStatus.OK && (tenantsPortal = (List)response.getBody()) != null) {
                tenants.removeIf(t -> !tenantsPortal.contains(t.getCodigo()));
            }
            ArrayList<String> backups = new ArrayList<String>();
            ArrayList<ArquivoInfoWrapper> arquivos = new ArrayList<ArquivoInfoWrapper>();
            for (Tenant tenant : tenants) {
                List paths = FileUtil.buscarListaBackup((String)FileUtil.DIRETORIO_BACKUP, (String)tenant.getCodigo());
                ArquivoInfoWrapper arquivoPai = new ArquivoInfoWrapper();
                String descricao = tenant.getCodigo() + " - " + tenant.getDescricao();
                arquivoPai.setNome(descricao);
                arquivoPai.setTenant(descricao);
                arquivos.add(arquivoPai);
                for (Path path : paths) {
                    BasicFileAttributes attr = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
                    LocalDateTime dataCriacaoArquivo = DataHoraFactory.long2LocalDateTime((long)attr.lastModifiedTime().to(TimeUnit.MILLISECONDS));
                    String nome = "";
                    if (path.getFileName() != null) {
                        nome = path.getFileName().toString();
                        backups.add(nome);
                    }
                    ArquivoInfoWrapper arquivoFilho = new ArquivoInfoWrapper(path.toString(), nome, dataCriacaoArquivo, attr.size());
                    arquivoFilho.setTenant(descricao);
                    arquivos.add(arquivoFilho);
                }
            }
            List pathOutros = FileUtil.buscarTodosArquivos((String)FileUtil.DIRETORIO_BACKUP);
            ArrayList<ArquivoInfoWrapper> outrosArquivos = new ArrayList<ArquivoInfoWrapper>();
            String descricaoOutros = "Outros arquivos";
            for (Path path : pathOutros) {
                String nome;
                if (path.getFileName() == null || backups.contains(nome = path.getFileName().toString())) continue;
                BasicFileAttributes attr = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
                LocalDateTime dataCriacaoArquivo = DataHoraFactory.long2LocalDateTime((long)attr.lastModifiedTime().to(TimeUnit.MILLISECONDS));
                ArquivoInfoWrapper arquivo = new ArquivoInfoWrapper(path.toString(), nome, dataCriacaoArquivo, attr.size());
                arquivo.setTenant(descricaoOutros);
                outrosArquivos.add(arquivo);
            }
            if (!outrosArquivos.isEmpty()) {
                ArquivoInfoWrapper arquivoPaiOutros = new ArquivoInfoWrapper();
                arquivoPaiOutros.setNome(descricaoOutros);
                arquivoPaiOutros.setTenant(descricaoOutros);
                arquivos.add(arquivoPaiOutros);
                arquivos.addAll(outrosArquivos);
            }
            return arquivos;
        }
        catch (IOException e) {
            throw new UnicoMensagemUsuarioException("WWW399", "N\u00e3o foi poss\u00edvel recuperar os aquivos", (Throwable)e);
        }
    }

    @RequestMapping(value={"/download"}, method={RequestMethod.POST})
    public ResponseEntity<Resource> download(@RequestBody ArquivoInfoWrapper backup) throws UnicoMensagemUsuarioException {
        try {
            Path path = Paths.get(backup.getPath(), new String[0]);
            UrlResource resource = new UrlResource(path.toUri());
            if (!resource.exists()) {
                throw new UnicoMensagemUsuarioException("WWW400", "Arquivo n\u00e3o encontrado.");
            }
            String nomeArquivo = "Backup_" + backup.getTenant().toUpperCase().replace(" ", "_").replace("'", "_").replace(",", "_").replace("\"", "_").concat(".backup");
            return this.responseEntityService.createSourceResponse((Resource)resource, nomeArquivo);
        }
        catch (IOException e) {
            throw new UnicoMensagemUsuarioException("WWW401", "N\u00e3o foi poss\u00edvel realizar o download do arquivo.");
        }
    }

    @RequestMapping(value={"/xml-nfse"})
    public List<ArquivoInfoWrapper> getArquivoXMLNFSe() throws UnicoMensagemUsuarioException {
        List tenants = this.tenantService.getTenants();
        ArrayList<ArquivoInfoWrapper> arquivos = new ArrayList<ArquivoInfoWrapper>();
        for (Tenant tenant : tenants) {
            List arquivosFilhos = this.storageService.getArquivos(tenant.getCodigo(), TipoArquivoArmazenado.NFSE, "");
            if (ListMapUtil.listNullOrEmpty((List)arquivosFilhos)) continue;
            String descricao = tenant.getCodigo() + " - " + tenant.getDescricao();
            ArquivoInfoWrapper arquivoPai = new ArquivoInfoWrapper();
            arquivoPai.setNome(descricao);
            arquivoPai.setTenant(tenant.getCodigo());
            arquivos.add(arquivoPai);
            for (ArquivoInfoWrapper path : arquivosFilhos) {
                path.setTenant(tenant.getCodigo());
                arquivos.add(path);
            }
        }
        return arquivos;
    }

    @RequestMapping(value={"/download-xml"}, method={RequestMethod.POST})
    public ResponseEntity<byte[]> downloadXml(@RequestBody ArquivoInfoWrapper xml) throws UnicoMensagemUsuarioException {
        File file = this.storageService.downloadFile(xml.getTenant(), TipoArquivoArmazenado.NFSE, xml.getPath(), false, true);
        return this.responseEntityService.createFileResponse(FileUtil.file2ByteArray((File)file), MediaType.APPLICATION_OCTET_STREAM, xml.getNome());
    }

    @RequestMapping(value={"/excluir-xml"}, method={RequestMethod.POST})
    public void excluirXml(@RequestBody ArquivoInfoWrapper xml) {
        this.storageService.excluirArquivo(xml.getTenant(), TipoArquivoArmazenado.NFSE, xml.getPath(), false, false);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public void delete(@RequestBody ArquivoInfoWrapper backup) throws UnicoMensagemUsuarioException {
        File file = new File(backup.getPath());
        if (!file.exists()) {
            throw new UnicoMensagemUsuarioException("WWW402", "Arquivo n\u00e3o encontrado.");
        }
        try {
            FileUtils.forceDelete((File)file);
        }
        catch (IOException e) {
            throw new UnicoMensagemUsuarioException("WWW403", "N\u00e3o foi poss\u00edvel excluir o arquivo.");
        }
    }

    @RequestMapping(value={"/restart"})
    private void restartServer() {
        try {
            String DIRETORIO = SystemUtil.getDiretorioAplicacao();
            String comando = SystemUtil.isLinux() ? "java -jar web-updater.jar restart" : "\"" + DIRETORIO + "\\jre\\bin\\javaw.exe\" -jar \"" + DIRETORIO + "\\web-updater.jar restart\"";
            log.info("COMANDO: {}", (Object)comando);
            if (SystemUtil.isLinux()) {
                ProcessBuilder p = new ProcessBuilder("/bin/sh", "-c", comando);
                p.directory(new File(DIRETORIO));
                p.redirectErrorStream(true);
                p.redirectOutput(new File(DIRETORIO + File.separator + "log_restartServer.txt"));
                p.inheritIO().start();
            } else {
                new ProcessBuilder(comando).inheritIO().start();
            }
        }
        catch (Throwable ex) {
            log.error("N\u00e3o foi poss\u00edvel executar o updater", ex);
        }
    }

    @GetMapping(value={"/monitor-endpoint"})
    public List<MonitorTenantWrapper> carregarMonitoramentoEndpoint() {
        return this.monitorService.getMonitoramento();
    }

    static /* synthetic */ TaskManager access$000(BatchController x0) {
        return x0.taskManager;
    }

    static /* synthetic */ StorageService access$100(BatchController x0) {
        return x0.storageService;
    }
}

