/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.client.crud;

import br.intelidata.api.batch.AbstractJob;
import br.intelidata.api.batch.CreateTask;
import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.domain.pojo.batch.Task;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.pojo.enuns.batch.TypeQueue;
import br.intelidata.uniplusweb.core.util.JsonUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;

public interface ICreateTask {
    public TipoJob getTipoJob();

    public Class<? extends AbstractJob> job();

    public TaskManager taskManager();

    default public String getDescricao() {
        return "";
    }

    default public void getOutPut(Task task) throws UnicoMensagemUsuarioException {
    }

    default public JobMetadata setMetaData(Object wrapper) {
        return new JobMetadata();
    }

    default public TypeQueue getQueue() {
        return TypeQueue.RECURRING_QUEUE;
    }

    default public void createTask(Object wrapper) throws UnicoMensagemUsuarioException {
        this.createTask(wrapper, null, "", false);
    }

    default public void createTask(Object wrapper, String resumo) throws UnicoMensagemUsuarioException {
        this.createTask(wrapper, null, resumo, false);
    }

    default public void createTask(Object wrapper, String uuidTask, String resumo, boolean validarFila) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        JobMetadata metadata = this.setMetaData(wrapper);
        if (metadata == null) {
            metadata = new JobMetadata();
        }
        metadata.setIdUsuario(sessao.getIdUsuario());
        metadata.setIdFilial(sessao.getIdFilial());
        String parametros = JsonUtil.toJson((Object)wrapper);
        String descricao = this.getDescricao();
        if (this.getTipoJob().equals((Object)TipoJob.REPORT)) {
            descricao = this.getTipoJob().getDescricao() + " - " + this.getDescricao();
        }
        if (this.getTipoJob().equals((Object)TipoJob.EMAIL)) {
            descricao = StringUtil.stringNullOrEmpty((String)descricao) ? this.getTipoJob().getDescricao() : "E-mail: " + this.getDescricao();
        }
        if (StringUtil.stringNullOrEmpty((String)descricao)) {
            descricao = this.getTipoJob().getDescricao();
        }
        Task task = CreateTask.create((Long)this.getQueue().getId(), (Class)this.job(), (String)descricao, (String)ContextoHolder.getTenant(), (String)parametros, (JobMetadata)metadata, (TipoJob)this.getTipoJob());
        task.setUuidTask(uuidTask);
        task.setResumo(resumo);
        this.getOutPut(task);
        if (validarFila && this.taskManager().verificaSeExistePorTipoTenant(task.getTipoJob(), task.getTenant(), true)) {
            throw new UnicoMensagemUsuarioException("BATCH13", "J\u00e1 existe uma tarefa desse tipo em andamento. Aguarde o processamento antes de agendar uma nova.");
        }
        this.taskManager().launch(task);
    }
}

