/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.client.schedulers;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.cron.Cron;
import br.intelidata.commons.domain.pojo.Empresa;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.pojo.enuns.batch.TaskStatus;
import br.intelidata.commons.domain.regranegocio.CustoMedioDiarioCommonRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.EmpresaRN;
import br.intelidata.uniplusweb.web.rest.app.client.schedulers.AbstractPrepareScheduler;
import java.util.List;

public class CalculoCustoMedioScheduller
extends AbstractPrepareScheduler {
    public CalculoCustoMedioScheduller() {
        super(TipoJob.CALCULO_CUSTO_MEDIO_PENDENTES.getDescricao() + " (agendado)", Cron.daily((int)2), TipoJob.CALCULO_CUSTO_MEDIO_PENDENTES);
    }

    public void execute() throws Exception {
        List empresas = EmpresaRN.getInstance().buscarLista();
        for (Empresa empresa : empresas) {
            List registrosPendentes = CustoMedioDiarioCommonRN.getInstance().buscarRegistrosPendentesEmpresaOrdenadaAnoMes(empresa.getId());
            boolean temRegistroSemFilial = registrosPendentes.stream().anyMatch(cmd -> cmd.getIdFilial() == null);
            if (temRegistroSemFilial) {
                throw new UnicoMensagemUsuarioException("WYODA29", "Existem registros de custo m\u00e9dio sem filial relacionada.");
            }
            CustoMedioDiarioCommonRN.getInstance().iniciarCalculoJob(registrosPendentes, SessaoUtil.getSessao());
        }
    }

    public boolean abstractControlTransaction() {
        return false;
    }

    public void onFailure(Exception ex) {
    }

    public boolean isAtivo() {
        return true;
    }

    public TaskStatus getStatusDefault() {
        return TaskStatus.PAUSE_SCHEDULE;
    }
}

