/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.client.thread;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.EnumSimNao;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.JobExecutor;
import br.intelidata.commons.domain.pojo.JobExecutorFile;
import br.intelidata.commons.domain.pojo.enuns.StatusJob;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.pojo.enuns.TipoNotificacaoSimples;
import br.intelidata.commons.modulo.cadastros.regranegocio.JobExecutorFileRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.JobExecutorRN;
import br.intelidata.uniplusweb.core.util.BeanUtil;
import br.intelidata.uniplusweb.core.util.JsonUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.StorageService;
import br.intelidata.uniplusweb.service.socket.NotificationService;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.client.thread.Job;
import br.intelidata.uniplusweb.web.rest.app.client.thread.Notificacao;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.google.common.base.Throwables;
import java.io.File;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JobPersistent
extends Job {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected ObjectMetadata metadata;
    private TipoJob tipoJob;
    private String classe;
    private String parametroSerializado;
    private File file;
    private String mensagemRetorno;
    private String stackTrace;
    private boolean gzip;

    public JobPersistent(String nome, TipoJob tipoJob, String classe, String parametroSerializado, String detalhes, String tenant, Long idUsuario, Long idFilial, boolean recreate) throws UnicoMensagemUsuarioException {
        this(nome, tipoJob, classe, parametroSerializado, detalhes, tenant, idUsuario, idFilial, recreate, true, null);
    }

    public JobPersistent(String nome, TipoJob tipoJob, String classe, String parametroSerializado, String detalhes, String tenant, Long idUsuario, Long idFilial, boolean recreate, boolean gzip, ObjectMetadata metadata) throws UnicoMensagemUsuarioException {
        super(nome, tenant, idUsuario, idFilial);
        this.tipoJob = tipoJob;
        this.classe = classe;
        this.parametroSerializado = parametroSerializado;
        this.gzip = gzip;
        this.metadata = metadata;
        this.mensagemRetorno = "";
        this.stackTrace = "";
        if (!recreate) {
            JobExecutor jobExecutor = new JobExecutor();
            jobExecutor.setIdUsuario(super.getIdUsuario());
            jobExecutor.setStatus(StatusJob.PENDENTE);
            jobExecutor.setTipoJob(this.tipoJob);
            jobExecutor.setClasse(this.classe);
            jobExecutor.setParametrosSerializado(this.parametroSerializado);
            jobExecutor.setNome(nome);
            jobExecutor.setPossuiArquivo(EnumSimNao.NAO);
            jobExecutor.setIdUsuario(idUsuario);
            jobExecutor.setIdFilial(idFilial);
            jobExecutor.setResumoFiltros(detalhes);
            jobExecutor.setGzip(this.gzip);
            this.setJobId(JobExecutorRN.getInstance().gravar(0, (AbstractPojo)jobExecutor, super.getSessao()));
        }
    }

    public JobPersistent(String tenant, JobExecutor jobExecutor) {
        super(jobExecutor.getResumoFiltros(), tenant, jobExecutor.getIdUsuario(), jobExecutor.getIdFilial());
    }

    public TipoJob getTipoJob() {
        return this.tipoJob;
    }

    public String getClasse() {
        return this.classe;
    }

    public String getParametroSerializado() {
        return this.parametroSerializado;
    }

    private void end(boolean sucesso) throws Exception {
        this.log.info("Finalizando job id " + super.getJobId() + " | sucesso? " + sucesso);
        JobExecutor jobExecutor = (JobExecutor)JobExecutorRN.getInstance().buscarPorId(super.getJobId());
        jobExecutor.setDataHoraInicial(super.getDataHoraInicio());
        jobExecutor.setDataHoraFinal(super.getDataHoraFim());
        jobExecutor.setStatus(sucesso ? StatusJob.PROCESSADO_SUCESSO : StatusJob.PROCESSADO_ERRO);
        jobExecutor.setPossuiArquivo(this.file == null ? EnumSimNao.NAO : EnumSimNao.SIM);
        jobExecutor.setRetorno(this.mensagemRetorno);
        jobExecutor.setStackTrace(this.stackTrace);
        JobExecutorRN.getInstance().alterar((AbstractPojo)jobExecutor, super.getSessao());
        this.log.info("Alterou o job ap\u00f3s finalizado.. possui arquivo no job? " + jobExecutor.getPossuiArquivo().getDescricao());
        if (this.file != null) {
            this.uploadFile(jobExecutor);
        }
        this.notification(jobExecutor, sucesso);
    }

    private void notification(JobExecutor jobExecutor, boolean sucesso) {
        Notificacao notificacao;
        NotificationService notificationService = (NotificationService)BeanUtil.getBean((String)"notificationService");
        TipoNotificacaoSimples tipoNotificacao = null;
        if (sucesso) {
            notificacao = this.getNotificacaoSucesso(jobExecutor);
            if (notificacao != null) {
                tipoNotificacao = notificacao.getTipoNotificacao() == null ? TipoNotificacaoSimples.SUCCESS : notificacao.getTipoNotificacao();
            }
        } else {
            notificacao = this.getNotificacaoErro(jobExecutor);
            if (notificacao != null) {
                TipoNotificacaoSimples tipoNotificacaoSimples = tipoNotificacao = notificacao.getTipoNotificacao() == null ? TipoNotificacaoSimples.ERROR : notificacao.getTipoNotificacao();
            }
        }
        if (notificacao != null) {
            notificationService.notifyUser(jobExecutor.getIdUsuario(), notificacao.getMsg(), tipoNotificacao);
        }
    }

    protected abstract Notificacao getNotificacaoSucesso(JobExecutor var1);

    protected abstract Notificacao getNotificacaoErro(JobExecutor var1);

    protected void tratarErro(Exception ex) throws UnicoMensagemUsuarioException {
    }

    void success() throws Exception {
        this.file = this.getFile();
        this.end(true);
    }

    void error(Exception ex) throws Exception {
        this.addMensagemRetorno(ex.getMessage());
        this.stackTrace = Throwables.getStackTraceAsString((Throwable)ex);
        this.tratarErro(ex);
        this.file = this.getFile();
        this.end(false);
    }

    protected File getFile() throws Exception {
        return null;
    }

    private void uploadFile(JobExecutor jobExecutor) throws Exception {
        this.log.info("Carregando storageService");
        StorageService storageService = (StorageService)BeanUtil.getBean((String)"storageService");
        String url = storageService.saveFile(super.getTenant(), TipoArquivoArmazenado.JobExecutor, this.file, this.gzip, this.metadata, true);
        this.log.info("Salvou arquvivo com a URL: " + url);
        JobExecutorFile file = new JobExecutorFile();
        file.setIdJobExecutor(jobExecutor.getId());
        file.setUrl(url);
        Long idJobFile = JobExecutorFileRN.getInstance().incluir((AbstractPojo)file, super.getSessao());
        this.log.info("Gravou JobExecutorFile com o id: " + idJobFile);
    }

    protected void addMensagemRetorno(String mensagem) {
        this.addMensagemRetorno(null, mensagem);
    }

    protected void addMensagemRetorno(String codigo, String mensagem) {
        if (this.mensagemRetorno.length() > 0) {
            this.mensagemRetorno = this.mensagemRetorno + "\n";
        }
        this.mensagemRetorno = this.mensagemRetorno + mensagem;
        if (!StringUtil.stringNullOrEmpty((String)codigo)) {
            this.mensagemRetorno = this.mensagemRetorno + " (" + codigo + ")";
        }
    }

    protected <T> T getObjetoDeserializado(Class<T> clazz) throws UnicoMensagemUsuarioException {
        Object c = JsonUtil.fromJson((String)this.getParametroSerializado(), clazz);
        if (c == null) {
            throw new UnicoMensagemUsuarioException("WWW284", "Erro ao deserializar parametros");
        }
        return (T)c;
    }

    protected <T> List<T> getListaSerializada(Class<T> clazz) throws UnicoMensagemUsuarioException {
        List c = JsonUtil.fromJsonList((String)this.getParametroSerializado(), clazz);
        if (c == null) {
            throw new UnicoMensagemUsuarioException("WWW630", "Erro ao deserializar parametros");
        }
        return c;
    }
}

