/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.administradoracartao.relacionabandeira;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.Coalesce;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.RelacionaBandeira;
import br.intelidata.commons.domain.pojo.pafecf.BandeiraAdmCartaoTaxa;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.pdv.regranegocio.BandeiraAdmCartaoTaxaRN;
import br.intelidata.commons.modulo.pdv.regranegocio.RelacionaBandeiraRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.administradoracartao.relacionabandeira.BandeiraRelacionadaWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/bandeiras-relacionadas"})
public class BandeiraRelacionadaCrudController
extends CrudController<RelacionaBandeira, RelacionaBandeiraRN> {
    private ResponseEntityService responseEntityService;

    public BandeiraRelacionadaCrudController(ResponseEntityService responseEntityService) {
        super((AbstractRegraNegocio)RelacionaBandeiraRN.getInstance(), RelacionaBandeira::new, false, false, false);
        this.responseEntityService = responseEntityService;
    }

    @RequestMapping(value={"/por-administradora"})
    @DBAutoCommit
    public List<RelacionaBandeira> getComboAutoComplete(@RequestParam Long idAdm, @RequestParam(required=false) String query, @RequestParam(required=false, defaultValue="0") int limit) {
        return RelacionaBandeiraRN.getInstance().getAutoCompletePorAdminstradoraWeb(idAdm, query, limit);
    }

    @RequestMapping(value={"/buscas-taxa-relacionamento"})
    @DBAutoCommit
    public List<BandeiraAdmCartaoTaxa> getTaxasAdm(@RequestParam Long idRelacionamento, @RequestParam(required=false, defaultValue="0") Long idFilial) {
        return BandeiraAdmCartaoTaxaRN.getInstance().getPorIdRelacionamento(idRelacionamento, idFilial);
    }

    @RequestMapping(value={"/gravar-taxa-relacionamento"}, method={RequestMethod.POST})
    @DBTransaction
    public void gravarTaxas(@RequestBody List<BandeiraAdmCartaoTaxa> taxas, @RequestParam Long idRelacionamento, @RequestParam(required=false, defaultValue="0") Long idFilial) throws UnicoMensagemUsuarioException {
        BandeiraAdmCartaoTaxaRN.getInstance().gravarLista(idRelacionamento, idFilial, taxas, SessaoUtil.getSessao());
    }

    @RequestMapping(value={"/incluir"}, method={RequestMethod.POST})
    @DBTransaction
    public ResponseEntity<String> gravarDados(@RequestBody BandeiraRelacionadaWrapper wrapper) throws UnicoMensagemUsuarioException {
        BandeiraAdmCartaoTaxa bandeiraAdmCartaoTaxa = wrapper.getBandeiraAdmCartaoTaxa();
        RelacionaBandeira relacionaBandeira = wrapper.getRelacionaBandeira();
        relacionaBandeira.setListTaxas(Collections.singletonList(bandeiraAdmCartaoTaxa));
        Long idRelacionar = super.create((AbstractPojo)relacionaBandeira, Optional.empty());
        Long idAdmTaxa = BandeiraAdmCartaoTaxaRN.getInstance().buscarPorIdBandeiraAdmNumeroParcelas(idRelacionar, bandeiraAdmCartaoTaxa.getNumeroParcelas()).getId();
        String json = "{\"id\":".concat(idRelacionar.toString()).concat(", \"idItem\":").concat(idAdmTaxa.toString()).concat("}");
        return this.responseEntityService.createJSONResponse(json);
    }

    protected void beforeUpdate(RelacionaBandeira relacionaBandeira, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        relacionaBandeira.setListTaxas(BandeiraAdmCartaoTaxaRN.getInstance().getPorIdRelacionamento(relacionaBandeira.getId()));
    }

    @RequestMapping(value={"/buscar-taxas-adm"}, method={RequestMethod.POST})
    @DBTransaction
    public List<BandeiraAdmCartaoTaxa> carregarTaxasAdm(@RequestBody RelacionaBandeira relacionaBandeira) throws UnicoMensagemUsuarioException {
        List taxas = BandeiraAdmCartaoTaxaRN.getInstance().getTaxasAdm(relacionaBandeira.getIdAdministradora());
        taxas.sort(Comparator.comparingInt(BandeiraAdmCartaoTaxa::getNumeroParcelas));
        relacionaBandeira.setListTaxas(taxas);
        if (NumberUtil.longNullOuZero((Long)relacionaBandeira.getId())) {
            super.create((AbstractPojo)relacionaBandeira, Optional.empty());
        } else {
            BandeiraAdmCartaoTaxaRN.getInstance().excluirTaxas(SessaoUtil.getSessao(), relacionaBandeira.getId());
            RelacionaBandeiraRN.getInstance().gravar(1, relacionaBandeira, SessaoUtil.getSessao());
        }
        return taxas;
    }

    protected GridBuilder<RelacionaBandeiraRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idAdministradora", "idAdministradora", 0, false));
        colunas.add(new ColunaSQL("nome", "nomeBandeira", "Bandeira", 0, true, new String[]{"fk_relaciona_bandeira"}));
        colunas.add(new ColunaSQL("manual", "Tipo cart\u00e3o", 0, true));
        colunas.add(new ColunaSQL("prazoVencimentoCredito", "Prazo vencimento cr\u00e9dito", 0, true));
        colunas.add(new ColunaSQL("prazoVencimentoDebito", "Prazo vencimento d\u00e9bito", 0, true));
        colunas.add(new ColunaSQL("prazoVencimentoCredParc", "Prazo vencimento cr\u00e9dito parcelado", 0, true));
        GridBuilder grid = new GridBuilder(RelacionaBandeiraRN.getInstance().getTabela(), colunas);
        grid.addReferenciaDefault(new Referencia(new Coalesce("inativo", "0"), "inativo", new String[]{"fk_relaciona_bandeira"}));
        grid.addCodicaoDefault(new Condicao("inativo", Operador.IGUAL, "0"));
        return grid;
    }

    protected String getCacheId() {
        return "bandeiras-relacionadas";
    }
}

