/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.blocox;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.modulo.pdv.blocox.CredenciamentoBlocoX;
import br.intelidata.commons.modulo.pdv.regranegocio.EnvioBlocoXRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.service.GravacaoArquivoBlocoXService;
import br.intelidata.uniplusweb.web.rest.app.crud.blocox.BlocoXInfoWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import unipaf.geracaoarquivo.blocox.GravacaoArquivoBlocoX;
import unipaf.geracaoarquivo.blocox.transmissao.AssinaBlocoX;
import unipaf.geracaoarquivo.blocox.transmissao.InfoCertificadoBlocoX;

public abstract class BlocoXController {
    @Autowired
    protected GravacaoArquivoBlocoXService gravacaoArquivoBlocoXService;

    @RequestMapping(value={"/info"})
    @DBAutoCommit
    public BlocoXInfoWrapper getInformacoes() {
        Sessao sessao = SessaoUtil.getSessao();
        InfoCertificadoBlocoX infoCertificado = AssinaBlocoX.getInstance().getInfoCertificadoBlocoX(sessao, null);
        return new BlocoXInfoWrapper(infoCertificado, CredenciamentoBlocoX.getMenorDataInicioBlocoX((Filial)sessao.getFilial()), CredenciamentoBlocoX.isFilialObrigadaTransmitirBlocoX((Filial)sessao.getFilial()));
    }

    protected void limparEnvios(Sessao sessao) throws UnicoMensagemUsuarioException {
        EnvioBlocoXRN.getInstance().removerEnviosSemObjeto(sessao);
        EnvioBlocoXRN.getInstance().removerObjectosDuplicado(sessao, (GravacaoArquivoBlocoX)this.gravacaoArquivoBlocoXService);
    }
}

