/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.configuracaopainelpreco;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.RSS;
import br.intelidata.commons.domain.pojo.ConfiguracaoPainelDePreco;
import br.intelidata.commons.domain.pojo.enuns.TipoImagem;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.tabelapreco.regranegocio.ConfiguracaoPainelDePrecoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import java.util.List;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/configuracao-painel-preco"})
@SubMenuMapping(MENU="SubMenuCadastroAuxiliarTabelaPreco", NOME="Configura\u00e7\u00f5es do painel de pre\u00e7os", ROTA="/cadastros/configuracao-painel-preco", ICONE="icon-funcoes-auxiliares", PROGRAMA=107)
public class ConfiguracaoPainelDePrecoCrudController
extends SimpleCrudController<ConfiguracaoPainelDePreco, ConfiguracaoPainelDePrecoRN> {
    public ConfiguracaoPainelDePrecoCrudController() {
        super((AbstractRegraNegocio)ConfiguracaoPainelDePrecoRN.getInstance());
    }

    @DBAutoCommit
    public ConfiguracaoPainelDePreco get(Long parentId) throws UnicoMensagemUsuarioException {
        ConfiguracaoPainelDePreco config = ConfiguracaoPainelDePrecoRN.getInstance().buscarPorIdFilial(SessaoUtil.getSessao().getIdFilial());
        if (!StringUtil.stringNullOrEmpty((String)config.getCaminhoImagem())) {
            config.setCaminhoImagem(this.getStorageService().publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.LOGO_TABELA_PRECO, TipoImagem.TamanhoOriginal, config.getCaminhoImagem()));
        }
        return config;
    }

    public void beforeUpdate(ConfiguracaoPainelDePreco configuracaoPainelDePreco) throws UnicoMensagemUsuarioException {
        String caminhoOriginal = (String)ConfiguracaoPainelDePrecoRN.getInstance().buscarValorPorID(configuracaoPainelDePreco.getId(), "caminhoimagem");
        if (!StringUtil.stringNullOrEmpty((String)caminhoOriginal)) {
            String arquivoRelativo = this.saveFile.publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Entidade, TipoImagem.TamanhoOriginal, caminhoOriginal);
            if (StringUtil.stringNullOrEmpty((String)configuracaoPainelDePreco.getCaminhoImagem()) || !configuracaoPainelDePreco.getCaminhoImagem().equals(arquivoRelativo)) {
                this.saveFile.excluirImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Usuario, caminhoOriginal);
            } else {
                configuracaoPainelDePreco.setCaminhoImagem(caminhoOriginal);
            }
        }
    }

    public TipoArquivoArmazenado getTipoArmazenamento() {
        return TipoArquivoArmazenado.LOGO_TABELA_PRECO;
    }

    @RequestMapping(value={"/testar-rss"})
    public String testarFeed(@RequestParam String url) throws UnicoMensagemUsuarioException {
        List mensagens = RSS.lerMensagens((String)url, (int)1);
        if (!mensagens.isEmpty()) {
            return (String)mensagens.get(0);
        }
        return "Nenhuma not\u00edcia para exibir.";
    }
}

