/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.conhecimentotransporte.conhecimentotransportesaida;

import br.intelidata.api.batch.AbstractJob;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Malote;
import br.intelidata.commons.core.util.Notificacao;
import br.intelidata.commons.core.util.TipoNotificacao;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.conhecimento.ConhecimentoTransporte;
import br.intelidata.commons.domain.pojo.enuns.AbstractEnum;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.pojo.enuns.TipoNotificacaoSimples;
import br.intelidata.commons.domain.pojo.enuns.batch.TypeQueue;
import br.intelidata.commons.domain.pojo.enuns.conhecimento.StatusConhecimento;
import br.intelidata.commons.domain.wrapper.NotificacaoCompartilhamento;
import br.intelidata.commons.modulo.cte.CTeManagerRN;
import br.intelidata.commons.modulo.cte.CteManagerWeb;
import br.intelidata.commons.modulo.cte.ImprimirDacte;
import br.intelidata.commons.modulo.cte.regranegocio.ConhecimentoTransporteRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.JsonUtil;
import br.intelidata.uniplusweb.service.socket.NotificationService;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CompartilhamentoController;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CreateTaskEmail;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ICreateTask;
import br.intelidata.uniplusweb.web.rest.app.crud.conhecimentotransporte.ConhecimentoTransporteSaidaComponent;
import br.intelidata.uniplusweb.web.rest.app.crud.conhecimentotransporte.conhecimentotransportesaida.ConhecimentoTransporteSaidaTaskJobController;
import br.intelidata.uniplusweb.web.rest.app.crud.conhecimentotransporte.conhecimentotransportesaida.JobTransmissaoCte;
import br.intelidata.uniplusweb.wrapper.ParametrosEmailWeb;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import javax.activation.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/jobs/jobs-cte"})
public class ConhecimentoTransporteSaidaTaskJobController
extends CompartilhamentoController<NotificacaoCompartilhamento>
implements ICreateTask {
    private final NotificationService notificationService;
    private final ResponseEntityService responseEntityService;
    private final ConhecimentoTransporteSaidaComponent conhecimentoTransporteSaidaComponent;

    @Autowired
    public ConhecimentoTransporteSaidaTaskJobController(TaskManager taskManager, NotificationService notificationService, ResponseEntityService responseEntityService, ConhecimentoTransporteSaidaComponent conhecimentoTransporteSaidaComponent) {
        super(taskManager);
        this.notificationService = notificationService;
        this.responseEntityService = responseEntityService;
        this.conhecimentoTransporteSaidaComponent = conhecimentoTransporteSaidaComponent;
    }

    public TipoJob getTipoJob() {
        return TipoJob.TRANSMISSAO_CTE;
    }

    public Class<? extends AbstractJob> job() {
        return JobTransmissaoCte.class;
    }

    public TaskManager taskManager() {
        return this.taskManager;
    }

    public TypeQueue getQueue() {
        return TypeQueue.RECURRING_QUEUE;
    }

    @RequestMapping(value={"/transmissao"}, method={RequestMethod.POST})
    @DBTransaction
    public ResponseEntity<String> transmitirCTE(@RequestBody Long idConhecimento) throws UnicoMensagemUsuarioException {
        if (Util.longNullOuZero((Long)idConhecimento)) {
            throw new UnicoMensagemUsuarioException("CTE166", "Por favor informe um CT-e.");
        }
        boolean autorizou = false;
        try {
            ConhecimentoTransporte conhecimentoTransporte = (ConhecimentoTransporte)ConhecimentoTransporteRN.getInstance().buscarPorId(idConhecimento);
            ConhecimentoTransporteRN.getInstance().validaTransmissao(SessaoUtil.getSessao(), conhecimentoTransporte);
            CteManagerWeb cteManagerWeb = this.conhecimentoTransporteSaidaComponent.getCteManagerWeb();
            cteManagerWeb.processar(idConhecimento);
            conhecimentoTransporte = (ConhecimentoTransporte)ConhecimentoTransporteRN.getInstance().buscarPorId(idConhecimento);
            if (PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 473) && StatusConhecimento.CTE_AUTORIZADA.equals((Object)conhecimentoTransporte.getStatus())) {
                this.agendarEmailCteCompleto(conhecimentoTransporte);
            }
            ConhecimentoTransporteRN.getInstance().depoisTransmitir(SessaoUtil.getSessao(), conhecimentoTransporte);
            autorizou = StatusConhecimento.CTE_AUTORIZADA.equals((Object)conhecimentoTransporte.getStatus());
        }
        catch (UnicoMensagemUsuarioException ex) {
            this.notificationService.notifyCteNow(ex.getMensagemSemCodigo());
        }
        return this.responseEntityService.createJSONResponse(JsonUtil.toJson((Object)autorizou));
    }

    @RequestMapping(value={"/gerar-dacte"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> gerarDacte(@RequestBody Long idCte) throws UnicoMensagemUsuarioException {
        ConhecimentoTransporte conhecimentoTransporte = (ConhecimentoTransporte)ConhecimentoTransporteRN.getInstance().buscarPorId(idCte);
        if (conhecimentoTransporte == null) {
            throw new UnicoMensagemUsuarioException("CTE163", "N\u00e3o foi selecionado CT-e para a impress\u00e3o! Verifique.");
        }
        return this.responseEntityService.createPDFResponse(ImprimirDacte.getInstance().geraDacte(conhecimentoTransporte), "DACTE-".concat(conhecimentoTransporte.getChaveAcesso()));
    }

    @RequestMapping(value={"/previsualizar-dacte"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> preVisualizarCte(@RequestBody Long idCte) throws UnicoMensagemUsuarioException {
        return this.responseEntityService.createPDFResponse(ImprimirDacte.getInstance().preVisualizarDacte(idCte, SessaoUtil.getSessao()), "DACTE-" + System.currentTimeMillis());
    }

    @RequestMapping(value={"/agendar-transmissao"}, method={RequestMethod.POST})
    @DBTransaction
    public void agendarCte(@RequestBody Long idCte) throws UnicoMensagemUsuarioException {
        this.conhecimentoTransporteSaidaComponent.verificarValidadeCertificado(new CteManagerWeb(SessaoUtil.getSessao(), null));
        String detalhe = "Transmiss\u00e3o da Cte-e " + ConhecimentoTransporteRN.getInstance().buscarValoresPorID(idCte, new String[]{"numeroconhecimento"}).get("numeroConhecimento") + ".";
        this.createTask((Object)idCte, detalhe);
    }

    protected List<Notificacao> getNotificacoes(Sessao sessao, NotificacaoCompartilhamento compartilhamento) throws UnicoMensagemUsuarioException {
        Notificacao notificacao = new Notificacao();
        notificacao.setFone(compartilhamento.getCelular());
        notificacao.setEmail(compartilhamento.getEmail());
        notificacao.setEmailCopia(compartilhamento.getCopiaPara());
        notificacao.setAssunto(compartilhamento.getAssunto());
        notificacao.setMsg(compartilhamento.getMensagem());
        Malote malote = new Malote();
        ConhecimentoTransporte conhecimento = (ConhecimentoTransporte)ConhecimentoTransporteRN.getInstance().buscarPorId((Long)compartilhamento.getIdsDocumentos().get(0));
        List dataSources = ConhecimentoTransporteRN.getInstance().getAnexosEmail(conhecimento);
        notificacao.setDataSources(dataSources.toArray(new DataSource[0]));
        for (DataSource source : dataSources) {
            try {
                malote.inclui(source.getName(), Util.inputStream2ByteArray((InputStream)source.getInputStream()));
            }
            catch (IOException e) {
                throw new UnicoMensagemUsuarioException("WWW568", "Erro ao anexar documento " + source.getName() + ".");
            }
        }
        notificacao.setMalote(malote);
        return Collections.singletonList(notificacao);
    }

    protected void createJobEmail(Sessao sessao, ParametrosEmailWeb parametrosEmail, NotificacaoCompartilhamento compartilhamento) throws UnicoMensagemUsuarioException {
        ConhecimentoTransporte conhecimento = (ConhecimentoTransporte)ConhecimentoTransporteRN.getInstance().buscarPorId((Long)compartilhamento.getIdsDocumentos().get(0));
        CreateTaskEmail taskEmail = new CreateTaskEmail(this.taskManager, parametrosEmail, "CT-e - ".concat(conhecimento.getNumeroConhecimento()));
        taskEmail.createTask((Object)parametrosEmail, parametrosEmail.getAssunto());
    }

    protected void validarCompartilhamento(NotificacaoCompartilhamento compartilhamento) throws UnicoMensagemUsuarioException {
        ConhecimentoTransporte conhecimentoTransporte = (ConhecimentoTransporte)ConhecimentoTransporteRN.getInstance().buscarPorId((Long)compartilhamento.getIdsDocumentos().get(0));
        if (conhecimentoTransporte == null) {
            throw new UnicoMensagemUsuarioException("CTE164", "N\u00e3o foi selecionado CT-e para envio de e-mail! Verifique.");
        }
        if (!conhecimentoTransporte.getStatus().in(new AbstractEnum[]{StatusConhecimento.CTE_AUTORIZADA})) {
            throw new UnicoMensagemUsuarioException("CTE165", "O CT-e selecionado deve estar autorizado! Verifique.");
        }
    }

    private void agendarEmailCteCompleto(ConhecimentoTransporte conhecimento) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        Entidade emailPara = null;
        Entidade remetente = (Entidade)EntidadeRN.getInstance().buscarPorId(conhecimento.getIdRemetente());
        Entidade destinatario = (Entidade)EntidadeRN.getInstance().buscarPorId(conhecimento.getIdDestinatario());
        if (conhecimento.isSimplificado()) {
            emailPara = (Entidade)EntidadeRN.getInstance().buscarPorId(conhecimento.getIdTomadorOutros());
        } else {
            switch (1.$SwitchMap$br$intelidata$commons$domain$pojo$enuns$conhecimento$TomadorServico[conhecimento.getTomadorServico().ordinal()]) {
                case 1: {
                    emailPara = (Entidade)EntidadeRN.getInstance().buscarPorId(conhecimento.getIdRemetente());
                    remetente = null;
                    break;
                }
                case 2: {
                    emailPara = (Entidade)EntidadeRN.getInstance().buscarPorId(conhecimento.getIdExpedidor());
                    break;
                }
                case 3: {
                    emailPara = (Entidade)EntidadeRN.getInstance().buscarPorId(conhecimento.getIdRecebedor());
                    break;
                }
                case 4: {
                    emailPara = (Entidade)EntidadeRN.getInstance().buscarPorId(conhecimento.getIdDestinatario());
                    destinatario = null;
                    break;
                }
                case 5: {
                    emailPara = (Entidade)EntidadeRN.getInstance().buscarPorId(conhecimento.getIdTomadorOutros());
                }
            }
        }
        String emailDe = null;
        if (emailPara == null || Util.stringNullOrEmpty((String)emailPara.getEmail())) {
            this.notificationService.notifyUser("E-mail n\u00e3o encontrado para envio.", TipoNotificacaoSimples.WARNING);
            return;
        }
        emailDe = emailPara.getEmail();
        String emailCCPadrao = (String)PropriedadeRN.getInstance().getPropriedade(SessaoUtil.getSessao().getFilial(), 854);
        NotificacaoCompartilhamento notificacaoCompartilhamento = new NotificacaoCompartilhamento();
        notificacaoCompartilhamento.setIdsDocumentos(Collections.singletonList(conhecimento.getId()));
        notificacaoCompartilhamento.setTipoNotificacao(TipoNotificacao.EMAIL);
        notificacaoCompartilhamento.setEmail(emailDe);
        String nomeEmpresa = sessao.getFilial().getRazaoSocialCompleta();
        String numero = conhecimento.getNumeroConhecimento();
        String valor = Util.bigDecimal2String((BigDecimal)conhecimento.getValorTotalPrestacaoServicos(), (String)"###,####,##0.00");
        String mensagem = CTeManagerRN.TEXTO_EMAIL;
        mensagem = mensagem.replace("@numero", numero);
        mensagem = mensagem.replace("@nomeEmpresa", nomeEmpresa);
        mensagem = mensagem.replace("@valor", valor);
        notificacaoCompartilhamento.setMensagem(mensagem);
        String emailCC = "";
        if (remetente != null) {
            emailCC = remetente.getEmail();
        }
        if (destinatario != null) {
            emailCC = emailCC + (!Util.stringNullOrEmpty((String)emailCC) ? ";" : "") + destinatario.getEmail();
        }
        if (!Util.stringNullOrEmpty((String)emailCCPadrao)) {
            emailCC = emailCC + (!Util.stringNullOrEmpty((String)emailCC) ? ";" : "") + emailCCPadrao;
        }
        notificacaoCompartilhamento.setCopiaPara(emailCC);
        String assunto = "Conhecimento de transporte eletr\u00f4nico (CT-e) " + conhecimento.getNumeroConhecimento() + " de " + sessao.getFilial().getRazaoSocialCompleta();
        notificacaoCompartilhamento.setAssunto(assunto);
        this.compartilhar(notificacaoCompartilhamento);
    }
}

