/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.contacorrente.acaocobranca;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.financeiro.ContaCorrenteAcaoCobranca;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.financeiro.regranegocio.ContaCorrenteAcaoCobrancaRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/acoes-cobranca"})
public class ContaCorrenteAcaoCobrancaCrudController
extends CrudController<ContaCorrenteAcaoCobranca, ContaCorrenteAcaoCobrancaRN> {
    public ContaCorrenteAcaoCobrancaCrudController() {
        super((AbstractRegraNegocio)ContaCorrenteAcaoCobrancaRN.getInstance(), ContaCorrenteAcaoCobranca::new);
        this.dependsOn("idContaCorrente");
    }

    @RequestMapping(value={"/por-conta-corrente"})
    @DBAutoCommit
    public List<ContaCorrenteAcaoCobranca> getCombo(@RequestParam Long idContaCorrente) throws UnicoMensagemUsuarioException {
        List acoes = ContaCorrenteAcaoCobrancaRN.getInstance().buscarListaPorContaCorrente(SessaoUtil.getSessao(), idContaCorrente);
        if (!ListMapUtil.listNullOrEmpty((List)acoes)) {
            acoes.forEach(acao -> acao.setDescricaoAcaoCobranca(acao.toString()));
        }
        return acoes;
    }

    protected GridBuilder<ContaCorrenteAcaoCobrancaRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idContaCorrente", "idContaCorrente", 0, false));
        colunas.add(new ColunaSQL("codigoAcaoCobranca", "C\u00f3digo da a\u00e7\u00e3o", 30, true));
        colunas.add(new ColunaSQL("descricaoAcaoCobranca", "Descri\u00e7\u00e3o da A\u00e7\u00e3o", 30, true));
        colunas.add(new ColunaSQL("acaoProcessamentoRetorno", "A\u00e7\u00e3o processamento", 30, true));
        colunas.add(new ColunaSQL("instrucaoCodificada", "Instru\u00e7\u00e3o", 30, true));
        return new GridBuilder(ContaCorrenteAcaoCobrancaRN.getInstance().getTabela(), colunas);
    }

    protected void beforeSave(ContaCorrenteAcaoCobranca acao, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (NumberUtil.longNullOuZero((Long)acao.getIdContaCorrente())) {
            throw new UnicoMensagemUsuarioException("WWW75", "Informe a conta corrente.");
        }
        if (StringUtil.stringNullOrEmpty((String)acao.getCodigoAcaoCobranca())) {
            throw new UnicoMensagemUsuarioException("WFIN248", "Informe o c\u00f3digo da a\u00e7\u00e3o de cobran\u00e7a.");
        }
        if (StringUtil.stringNullOrEmpty((String)acao.getDescricaoAcaoCobranca())) {
            throw new UnicoMensagemUsuarioException("WFIN249", "Informe a a\u00e7\u00e3o de cobran\u00e7a.");
        }
        List listContaAcao = ContaCorrenteAcaoCobrancaRN.getInstance().buscarListaPorContaCorrente(SessaoUtil.getSessao(), acao.getIdContaCorrente());
        for (ContaCorrenteAcaoCobranca ccac : listContaAcao) {
            if (!ccac.getCodigoAcaoCobranca().equals(acao.getCodigoAcaoCobranca()) || !ccac.getDescricaoAcaoCobranca().equals(acao.getDescricaoAcaoCobranca()) || acao.getInstrucaoCodificada() != null && !ccac.getInstrucaoCodificada().equals(acao.getInstrucaoCodificada())) continue;
            throw new UnicoMensagemUsuarioException("WFIN250", "C\u00f3digo " + acao.getCodigoAcaoCobranca() + ", a\u00e7\u00e3o " + acao + (StringUtil.stringNullOrEmpty((String)acao.getInstrucaoCodificada()) ? "" : " e instru\u00e7\u00e3o " + acao.getInstrucaoCodificada()) + ", j\u00e1 foram adicionados.");
        }
    }

    protected String getCacheId() {
        return "acoes-cobranca";
    }
}

