/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.contrato;

import br.intelidata.api.batch.AbstractJob;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.Sql;
import br.intelidata.commons.core.sql.usql.ColunaUPD;
import br.intelidata.commons.core.sql.usql.UUpdate;
import br.intelidata.commons.domain.pojo.enuns.StatusJobItem;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.pojo.vendas.ContratoVenda;
import br.intelidata.commons.domain.pojo.vendas.ContratoVendaNotaFiscal;
import br.intelidata.commons.modulo.contrato.regranegocio.ContratoVendaRN;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ICreateTask;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.contrato.ContratoFiltroWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.contrato.JobContrato;
import br.intelidata.uniplusweb.web.rest.app.crud.contrato.TipoManutencaoContrato;
import br.intelidata.uniplusweb.web.rest.app.crud.contrato.notafiscalcontrato.ContratoNotaFiscalWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.contrato.notafiscalcontrato.JobContratoNotaFiscal;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/jobs/contratos"})
public class ContratoJobSimpleCrudController
extends SimpleCrudController<ContratoVenda, ContratoVendaRN>
implements ICreateTask {
    private final TaskManager taskManager;
    private TipoJob tipoJob;
    private String descricao;
    private Class<? extends AbstractJob> job;

    public ContratoJobSimpleCrudController(TaskManager taskManager) {
        this.taskManager = taskManager;
    }

    public TipoJob getTipoJob() {
        return this.tipoJob;
    }

    public Class<? extends AbstractJob> job() {
        return this.job;
    }

    public TaskManager taskManager() {
        return this.taskManager;
    }

    public String getDescricao() {
        return this.descricao;
    }

    @RequestMapping(value={"/agendar-relatorio-contratos"}, method={RequestMethod.POST})
    @DBTransaction
    public void agendarRelatorioContratos(@RequestBody ContratoNotaFiscalWrapper wrapper) throws UnicoMensagemUsuarioException {
        if (ListMapUtil.listNullOrEmpty((List)wrapper.getNotasFiscais())) {
            throw new UnicoMensagemUsuarioException("WWW243", "Os contratos n\u00e3o foram informados.");
        }
        String operacao = (wrapper.isEnviarEmail() ? "Envio de e-mail" : "Relat\u00f3rio an\u00e1litico") + " das seguintes notas: ";
        operacao = operacao + wrapper.getNotasFiscais().stream().map(ContratoVendaNotaFiscal::getNumeroNotaFiscal).collect(Collectors.joining(",")) + ".";
        this.tipoJob = TipoJob.RELATORIO_NOTAS_FATURADAS_CONTRATO;
        this.job = JobContratoNotaFiscal.class;
        this.createTask((Object)wrapper, operacao);
    }

    @RequestMapping(value={"/agendar-manutencoes"}, method={RequestMethod.POST})
    @DBTransaction
    public void agendarManutencaoContratos(@RequestBody ContratoFiltroWrapper wrapper) throws UnicoMensagemUsuarioException {
        TipoJob tipoJob;
        if (ListMapUtil.listNullOrEmpty((List)wrapper.getContratos())) {
            throw new UnicoMensagemUsuarioException("WWW220", "Os contratos n\u00e3o foram informados.");
        }
        if (wrapper.getTipoManutencao() == null) {
            throw new UnicoMensagemUsuarioException("WWW225", "Os contratos n\u00e3o foram informados.");
        }
        if (wrapper.getTipoManutencao().equals((Object)TipoManutencaoContrato.REAJUSTAR) && NumberUtil.bigDecimalNullOrZero((BigDecimal)wrapper.getPercentualReajuste())) {
            throw new UnicoMensagemUsuarioException("WCTR5", "N\u00e3o foi informado percentual de reajuste! Verifique.");
        }
        if (wrapper.getTipoManutencao().equals((Object)TipoManutencaoContrato.PRORROGAR) && wrapper.getProrrogacao() == 0) {
            throw new UnicoMensagemUsuarioException("WCTR35", "N\u00e3o foi informado a quantidade de  " + (wrapper.getTipoProrrogacao() == 1 ? "meses" : "anos") + " para prorrogar! Verifique.");
        }
        List idsContratos = wrapper.getContratos().stream().map(ContratoVenda::getId).collect(Collectors.toList());
        String codigoContrato = ContratoVendaRN.getInstance().verificarJobWeb(idsContratos);
        if (!StringUtil.stringNullOrEmpty((String)codigoContrato)) {
            throw new UnicoMensagemUsuarioException("WWW342", "O contrato " + codigoContrato + " j\u00e1 foi agendado para outro processo. Por favor aguarde a conclus\u00e3o.");
        }
        for (Long idContrato : idsContratos) {
            Sql sql = new Sql(new UUpdate("contratovenda", idContrato, new ColunaUPD[]{new ColunaUPD("statusjob", StatusJobItem.PENDENTE.getId())}));
            sql.executaUpdate();
            sql.close();
        }
        TipoJob tipoJob2 = wrapper.getTipoManutencao().equals((Object)TipoManutencaoContrato.REAJUSTAR) ? TipoJob.REAJUSTE_CONTRATO : (tipoJob = wrapper.getTipoManutencao().equals((Object)TipoManutencaoContrato.PRORROGAR) ? TipoJob.PRORROGAR_CONTRATO : TipoJob.FATURAR_CONTRATO);
        String prefixo = tipoJob == TipoJob.REAJUSTE_CONTRATO ? "Reajuste" : (tipoJob == TipoJob.PRORROGAR_CONTRATO ? "Prorroga\u00e7\u00e3o" : "Faturamento");
        String operacao = prefixo + " dos seguintes contratos: ";
        operacao = operacao + wrapper.getContratos().stream().map(ContratoVenda::getCodigo).collect(Collectors.joining(","));
        this.descricao = prefixo + " de contrato";
        this.tipoJob = tipoJob;
        this.job = JobContrato.class;
        this.createTask((Object)wrapper, operacao);
    }
}

