/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.contrato;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.Sql;
import br.intelidata.commons.core.sql.usql.ColunaUPD;
import br.intelidata.commons.core.sql.usql.UUpdate;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.domain.pojo.batch.Task;
import br.intelidata.commons.domain.pojo.enuns.StatusJobItem;
import br.intelidata.commons.domain.pojo.vendas.ContratoVenda;
import br.intelidata.commons.modulo.contrato.regranegocio.ContratoVendaRN;
import br.intelidata.uniplusweb.web.rest.app.client.thread.AbstractPrepareJob;
import br.intelidata.uniplusweb.web.rest.app.client.thread.Notificacao;
import br.intelidata.uniplusweb.web.rest.app.crud.contrato.ContratoFiltroWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.contrato.JobContrato;
import java.util.List;
import java.util.stream.Collectors;

public class JobContrato
extends AbstractPrepareJob {
    private String notifica;

    public JobContrato(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    public void onFailure(Exception ex) {
        try {
            this.atualizarStatus();
        }
        catch (UnicoMensagemUsuarioException e) {
            this.addMensagemRetorno("Erro ao atualizar contrato " + e.getMessage());
        }
    }

    public void execute() throws Exception {
        ContratoFiltroWrapper wrapper = (ContratoFiltroWrapper)this.getObjetoDeserializado(ContratoFiltroWrapper.class);
        switch (1.$SwitchMap$br$intelidata$uniplusweb$web$rest$app$crud$contrato$TipoManutencaoContrato[wrapper.getTipoManutencao().ordinal()]) {
            case 1: {
                this.notifica = "reajuste";
                ContratoVendaRN.getInstance().reajustarContratos(SessaoUtil.getSessaoJob(), wrapper.getContratos(), wrapper.getPercentualReajuste());
                this.addMensagemRetorno("Contratos reajustados com sucesso");
                break;
            }
            case 2: {
                this.notifica = "prorroga\u00e7\u00e3o";
                int quantidadeMeses = wrapper.getProrrogacao() * (wrapper.getTipoProrrogacao() == 1 ? 12 : 1);
                ContratoVendaRN.getInstance().prorrogarContratos(SessaoUtil.getSessaoJob(), wrapper.getContratos(), quantidadeMeses);
                this.addMensagemRetorno("Contratos prorrogados com sucesso");
                break;
            }
            default: {
                this.notifica = "faturamento";
                ContratoVendaRN.getInstance().gerarNotasFiscais(SessaoUtil.getSessaoJob(), wrapper.getContratos());
                this.addMensagemRetorno("Faturamento foi gerada com sucesso");
            }
        }
        this.atualizarStatus();
    }

    protected Notificacao getNotificacaoSucesso(Task task) {
        return new Notificacao("A fun\u00e7\u00e3o de " + this.notifica + " foi executada com sucesso");
    }

    protected Notificacao getNotificacaoErro(Task task) {
        return new Notificacao("Falhou ao executar a fun\u00e7\u00e3o de " + this.notifica);
    }

    private void atualizarStatus() throws UnicoMensagemUsuarioException {
        ContratoFiltroWrapper wrapper = (ContratoFiltroWrapper)this.getObjetoDeserializado(ContratoFiltroWrapper.class);
        List idsContratos = wrapper.getContratos().stream().map(ContratoVenda::getId).collect(Collectors.toList());
        for (Long idContrato : idsContratos) {
            Sql sql = new Sql(new UUpdate("contratovenda", idContrato, new ColunaUPD[]{new ColunaUPD("statusjob", StatusJobItem.PROCESSADO.getId())}));
            sql.executaUpdate();
            sql.close();
        }
    }

    public boolean abstractControlTransaction() {
        return false;
    }
}

