/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.documentoauxiliarfaturamento.orcamentofaturamento;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.execoes.UnicoPerguntaUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractFaturamento;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.DescontoInterface;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.ItemWeb;
import br.intelidata.commons.domain.pojo.OrcamentoFaturamento;
import br.intelidata.commons.domain.pojo.OrcamentoFaturamentoItem;
import br.intelidata.commons.domain.pojo.ProdutoDTOWeb;
import br.intelidata.commons.domain.pojo.ProdutoItemWeb;
import br.intelidata.commons.domain.pojo.edi.EDIProcessado;
import br.intelidata.commons.domain.pojo.enuns.CstIPI;
import br.intelidata.commons.domain.pojo.enuns.QuantidadeCampoExtra;
import br.intelidata.commons.domain.pojo.enuns.StatusDAV;
import br.intelidata.commons.domain.pojo.enuns.TipoDocumentoDAV;
import br.intelidata.commons.domain.pojo.enuns.TipoNotaFiscal;
import br.intelidata.commons.domain.pojo.enuns.TipoValorPreco;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscal;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscalItem;
import br.intelidata.commons.domain.pojo.pvdav.AbstractDav;
import br.intelidata.commons.domain.regranegocio.AbstractFaturamentoItemRN;
import br.intelidata.commons.domain.regranegocio.AbstractFaturamentoRN;
import br.intelidata.commons.domain.regranegocio.DescontoRN;
import br.intelidata.commons.domain.wrapper.NotificacaoCompartilhamento;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.documentoauxiliarfaturamento.regranegocio.OrcamentoFaturamentoItemRN;
import br.intelidata.commons.modulo.documentoauxiliarfaturamento.regranegocio.OrcamentoFaturamentoRN;
import br.intelidata.commons.modulo.entidade.regranegocio.LimiteCreditoRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalItemRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.vendas.regranegocio.CondicaoPagamentoRN;
import br.intelidata.commons.modulo.vendas.regranegocio.PromocaoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.ConfiguracaoCampoExtra;
import br.intelidata.uniplusweb.core.coreinterfaces.ProdutoItemInterface;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.AtacarejoService;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import br.intelidata.uniplusweb.service.ModuloService;
import br.intelidata.uniplusweb.service.socket.NotificationType;
import br.intelidata.uniplusweb.web.rest.app.calculoimposto.CalculoImpostoService;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ImportacaoDadosColetor;
import br.intelidata.uniplusweb.web.rest.app.crud.documentoauxiliarfaturamento.FaturamentoCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.documentoauxiliarfaturamento.FaturamentoTratamentoImposto;
import br.intelidata.uniplusweb.web.rest.app.crud.documentoauxiliarfaturamento.orcamentofaturamento.FaturamentoOrcamentoWrapper;
import br.intelidata.uniplusweb.web.rest.app.wrapper.FaturamentoWrapper;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Component(value="orcamento_faturamento")
@ConfiguracaoCampoExtra(TABELA="orcamento_faturamento", QUANTIDADE=QuantidadeCampoExtra.DAF)
@RestController
@RequestMapping(value={"/api/orcamentos-faturamentos"})
@SubMenuMapping(MENU="SubMenuVendasGeral", NOME="Or\u00e7amentos de faturamento", ROTA="/vendas/orcamentos-faturamentos", ICONE="icon-orcamento", PROGRAMA=146)
public class OrcamentoFaturamentoCrudController
extends FaturamentoCrudController<OrcamentoFaturamento, OrcamentoFaturamentoRN, OrcamentoFaturamentoItem, OrcamentoFaturamentoItem, OrcamentoFaturamentoItemRN>
implements ProdutoItemInterface<OrcamentoFaturamentoItem> {
    @Autowired
    public OrcamentoFaturamentoCrudController(CalculoImpostoService<OrcamentoFaturamentoItem> calculoImpostoService, FuncionalidadeService funcionalidadeService, AtacarejoService atacarejoService, ModuloService moduloService, FaturamentoTratamentoImposto tratamentoImposto) {
        super((AbstractFaturamentoRN)OrcamentoFaturamentoRN.getInstance(), (AbstractFaturamentoItemRN)OrcamentoFaturamentoItemRN.getInstance(), calculoImpostoService, funcionalidadeService, atacarejoService, moduloService, OrcamentoFaturamento::new, TipoDocumentoDAV.ORCAMENTO_FATURAMENTO, tratamentoImposto);
        this.setItemSupplier(OrcamentoFaturamentoItem::new);
    }

    @RequestMapping(value={"/gerar-pedido-faturamento"}, method={RequestMethod.POST})
    @DBTransaction
    public Long gerarPedidoFaturamento(@RequestBody Long idOrcamento) throws UnicoMensagemUsuarioException {
        OrcamentoFaturamento orcamento = (OrcamentoFaturamento)OrcamentoFaturamentoRN.getInstance().buscarPorId(idOrcamento);
        if (orcamento != null) {
            boolean verificarLimiteCredito;
            boolean bl = verificarLimiteCredito = PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 479) && !PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 501);
            if (verificarLimiteCredito) {
                boolean considerarVendasAVista = PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 711);
                if (CondicaoPagamentoRN.getInstance().isCondicaoPagamentoAVista(orcamento.getIdcondicaopagamento()) && !considerarVendasAVista) {
                    verificarLimiteCredito = false;
                }
            }
            if (verificarLimiteCredito) {
                try {
                    LimiteCreditoRN.getInstance().validarLimiteCredito(SessaoUtil.getSessao(), (AbstractDav)orcamento);
                }
                catch (UnicoPerguntaUsuarioException ex) {
                    throw new UnicoMensagemUsuarioException("COM280079", "Esta venda excedeu o valor dispon\u00edvel de cr\u00e9dito. Venda n\u00e3o permitida.", (Throwable)ex);
                }
            }
        }
        return OrcamentoFaturamentoRN.getInstance().transformarOrcamentoEmPedido(SessaoUtil.getSessao(), idOrcamento);
    }

    @RequestMapping(value={"/faturar"}, method={RequestMethod.POST})
    @DBTransaction
    public FaturamentoWrapper faturarOrcamento(@RequestBody FaturamentoOrcamentoWrapper wrapper) throws UnicoMensagemUsuarioException {
        OrcamentoFaturamento orcamento = (OrcamentoFaturamento)OrcamentoFaturamentoRN.getInstance().buscarPorId(wrapper.getIdOrcamento());
        if (orcamento == null) {
            throw new UnicoMensagemUsuarioException("WDAF85", "Or\u00e7amento n\u00e3o encontrado.");
        }
        if (!StatusDAV.FECHADO.equals((Object)orcamento.getStatus())) {
            throw new UnicoMensagemUsuarioException("WDAF86", "O status do or\u00e7amento \u00e9 inv\u00e1lido para faturamento.");
        }
        Sessao sessao = SessaoUtil.getSessao();
        NotaFiscal notaFiscal = NotaFiscalRN.getInstance().importarOrcamento(sessao, wrapper.getIdOrcamento(), TipoNotaFiscal.SAIDA, wrapper.getIdOperacaoFiscal());
        Filial filialNotaFiscal = (Filial)FilialRN.getInstance().buscarPorId(notaFiscal.getIdFilial());
        for (NotaFiscalItem item : notaFiscal.getNotaFiscalItens()) {
            item.setItemPermiteDesconto(NotaFiscalItemRN.getInstance().permiteDescontoSubtotal(item, sessao.getFilial()));
        }
        for (int i = 0; i < notaFiscal.getNotaFiscalItens().size(); ++i) {
            ((NotaFiscalItem)notaFiscal.getNotaFiscalItens().get(i)).setId(Long.valueOf(Long.parseLong(String.valueOf(-(i + 1)))));
        }
        Map criticas = NotaFiscalItemRN.getInstance().gerarCriticasFaturamentoWeb(filialNotaFiscal, notaFiscal.getNotaFiscalItens(), true);
        return new FaturamentoWrapper(Collections.singletonList(wrapper.getIdOrcamento()), notaFiscal, criticas);
    }

    @RequestMapping(value={"/gerar-orcamentos-dav"}, method={RequestMethod.POST})
    @DBTransaction
    public void gerarOrcamentosDav(@RequestBody List<Long> ids) throws UnicoMensagemUsuarioException {
        for (Long idOrcamento : ids) {
            OrcamentoFaturamento orcamento = (OrcamentoFaturamento)OrcamentoFaturamentoRN.getInstance().buscarPorId(idOrcamento);
            if (orcamento == null) {
                throw new UnicoMensagemUsuarioException("WDAF91", "Or\u00e7amento n\u00e3o encontrado.");
            }
            OrcamentoFaturamentoRN.getInstance().gerarDavOrcamento(SessaoUtil.getSessao(), orcamento);
        }
    }

    @RequestMapping(method={RequestMethod.POST})
    @DBTransaction
    public Long create(@RequestBody OrcamentoFaturamento orcamento, @PathVariable Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        return super.create((AbstractPojo)orcamento, parentId);
    }

    @RequestMapping(method={RequestMethod.PUT})
    @DBTransaction
    public Long update(@RequestBody OrcamentoFaturamento orcamento, @PathVariable Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        return super.update((AbstractPojo)orcamento, parentId);
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.DELETE})
    @DBTransaction
    public void delete(@PathVariable Long id) throws UnicoMensagemUsuarioException {
        super.verificaSePermiteCancelamento(id);
        OrcamentoFaturamentoRN.getInstance().cancelarOrcamentoFaturamento(SessaoUtil.getSessao(), id);
        this.dashBoardRabbitService.sendMessage(ContextoHolder.getTenant());
        this.notificationService.notifyTenantNow(NotificationType.DASH_BOARD, "");
    }

    protected String getCacheId() {
        return "orcamentos-faturamentos".concat("_ID_FILIAL_").concat(SessaoUtil.getSessao().getFilial().getId().toString());
    }

    public ProdutoItemWeb<OrcamentoFaturamentoItem> carregarDadosItem(ProdutoDTOWeb produto, MultiValueMap<String, String> parametros) throws UnicoMensagemUsuarioException {
        ProdutoItemWeb produtoItem = new ProdutoItemWeb();
        OrcamentoFaturamentoItem item = new OrcamentoFaturamentoItem();
        item.setQuantidade(BigDecimal.ONE);
        item.setSituacaoTributariaIPI(CstIPI.SAIDA_TRIBUTADA);
        produtoItem.setItem((ItemWeb)item);
        produtoItem.setProduto(produto);
        super.carregarDadosItem(produtoItem, parametros);
        return produtoItem;
    }

    @PostMapping(value={"/preparar-compartilhamento"})
    @DBAutoCommit
    public NotificacaoCompartilhamento prepararEnvioEmail(@RequestBody List<Long> idsOrcamentos, @RequestParam(required=false) Long idTextoGenerico) throws UnicoMensagemUsuarioException {
        Long idEntidade = null;
        if (Util.listNullOrEmpty(idsOrcamentos)) {
            throw new UnicoMensagemUsuarioException("WWW561", "Por favor selecione um ou mais or\u00e7amentos.");
        }
        List orcamentos = OrcamentoFaturamentoRN.getInstance().buscarListaPorIds(idsOrcamentos);
        for (OrcamentoFaturamento orcamento : orcamentos) {
            if (Util.longNullOuZero(idEntidade)) {
                idEntidade = orcamento.getIdCliente();
            }
            if (orcamento.getIdCliente() == null || orcamento.getIdCliente().equals(idEntidade)) continue;
            throw new UnicoMensagemUsuarioException("WWW562", "Os or\u00e7amentos selecionados devem pertencer ao mesmo cliente.");
        }
        NotificacaoCompartilhamento notificacaoCompartilhamento = this.verificaCompartilhamento(orcamentos, "Or\u00e7amento", "Or\u00e7amentos");
        if (!NumberUtil.longNullOuZero((Long)idTextoGenerico)) {
            notificacaoCompartilhamento.setMensagem(this.reescreveTextoMensagem(orcamentos, idTextoGenerico));
        }
        return notificacaoCompartilhamento;
    }

    @PostMapping(value={"/preparar-texto-compartilhamento"})
    @DBAutoCommit
    public String prepararTextoEmail(@RequestBody List<Long> idsOrcamentos, @RequestParam Long idTextoGenerico) {
        List orcamentos = OrcamentoFaturamentoRN.getInstance().buscarListaPorIds(idsOrcamentos);
        if (ListMapUtil.listNullOrEmpty((List)orcamentos)) {
            return null;
        }
        return this.reescreveTextoMensagem(orcamentos, idTextoGenerico);
    }

    protected void beforeRead(OrcamentoFaturamento orcamentoFaturamento, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        super.beforeRead((AbstractFaturamento)orcamentoFaturamento, modo, parentId);
        if (7 == modo) {
            orcamentoFaturamento.setDataInclusao(DataHoraFactory.getDataHora());
            orcamentoFaturamento.setItens(this.buscarItens(orcamentoFaturamento.getId(), true, false));
            orcamentoFaturamento.setId(null);
        }
    }

    protected void beforeSave(OrcamentoFaturamento orcamento, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        orcamento.setTipodocumento(TipoDocumentoDAV.ORCAMENTO_FATURAMENTO);
        orcamento.setTituloDav(TipoDocumentoDAV.ORCAMENTO_FATURAMENTO.getDescricao().toUpperCase());
        orcamento.setVerificarCredito(LimiteCreditoRN.getInstance().isVerificarLimiteCredito(SessaoUtil.getSessao(), (AbstractDav)orcamento));
        super.beforeSave((AbstractFaturamento)orcamento, parentId);
    }

    @DBAutoCommit
    public EDIProcessado importarArquivoEdi(MultipartFile file, Long idEdi, @RequestParam MultiValueMap<String, String> parameters) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        Long pautaPreco = StringUtil.convertFirstValueMapToLong(parameters, (String)"pauta");
        Long idCondicaoPagamento = StringUtil.convertFirstValueMapToLong(parameters, (String)"idCondicaoPgmto");
        TipoValorPreco tipo = null;
        if (this.funcionalidadeService.isAtiva(Funcionalidade.CALCULAR_IMPOSTOS_PEDIDO_ORCAMENTO_FATURAMENTO)) {
            boolean utilizaOperacaoFiscal = PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 372);
            Long idCfop = StringUtil.convertFirstValueMapToLong(parameters, (String)"idParametro");
            tipo = this.calculoImpostoService.getTipoValorPreco(idCfop, utilizaOperacaoFiscal);
        }
        ImportacaoDadosColetor importacao = new ImportacaoDadosColetor(OrcamentoFaturamentoItem.class, idEdi, file, idCondicaoPagamento, pautaPreco, tipo);
        importacao.importar();
        for (OrcamentoFaturamentoItem item : importacao.getEDIProcessado().getOrcamentoItens()) {
            ProdutoItemWeb produtoItem = new ProdutoItemWeb();
            ProdutoDTOWeb produto = ProdutoRN.getInstance().buscarProdutoDTOWeb(sessao, item.getIdproduto());
            produtoItem.setItem((ItemWeb)item);
            produtoItem.setProduto(produto);
            super.carregarDadosItem(produtoItem, parameters, true, false);
            item.setItemPermiteDesconto(DescontoRN.getInstance().isItemPermiteDesconto(sessao.getFilial(), (DescontoInterface)item, !NumberUtil.longNullOuZero((Long)item.getIdPromocao()) ? PromocaoRN.getInstance().buscarPorId(item.getIdPromocao()) : null));
        }
        return importacao.getEDIProcessado();
    }
}

