/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.entidade.cliente.anexo;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.domain.pojo.EntidadeAnexo;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeAnexoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.FileUtil;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.io.File;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/anexos-entidade"})
public class EntidadeAnexoCrudController
extends CrudController<EntidadeAnexo, EntidadeAnexoRN> {
    private final ResponseEntityService responseEntityService;

    @Autowired
    public EntidadeAnexoCrudController(ResponseEntityService responseEntityService) {
        super((AbstractRegraNegocio)EntidadeAnexoRN.getInstance(), EntidadeAnexo::new, false);
        this.responseEntityService = responseEntityService;
        this.dependsOn("idEntidade");
    }

    protected void beforeCreate(EntidadeAnexo entidadeAnexo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        entidadeAnexo.setData(DataHoraFactory.getData());
    }

    protected void beforeDelete(EntidadeAnexo entidadeAnexo) throws UnicoMensagemUsuarioException {
        if (!StringUtil.stringNullOrEmpty((String)entidadeAnexo.getCaminho())) {
            this.saveFile.excluirArquivo(ContextoHolder.getTenant(), TipoArquivoArmazenado.EntidadeAnexo, entidadeAnexo.getCaminho(), false);
        }
    }

    public void loadFile(MultipartFile[] files, EntidadeAnexo entidadeAnexo) throws UnicoMensagemUsuarioException {
        Object[] split;
        MultipartFile file;
        String nomeArquivo;
        if (!(ListMapUtil.arrayNullOrEmpty((Object[])files) || StringUtil.stringNullOrEmpty((String)(nomeArquivo = (file = files[0]).getOriginalFilename())) || ListMapUtil.arrayNullOrEmpty((Object[])(split = nomeArquivo.split("\\|"))))) {
            entidadeAnexo.setCaminho(this.saveFile.saveFile(ContextoHolder.getTenant(), TipoArquivoArmazenado.EntidadeAnexo, file, false));
            entidadeAnexo.setNomeArquivo((String)split[1]);
        }
    }

    @RequestMapping(value={"/download"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> download(@RequestBody Long id) throws UnicoMensagemUsuarioException {
        EntidadeAnexo anexo = (EntidadeAnexo)EntidadeAnexoRN.getInstance().buscarPorId(id);
        File file = this.saveFile.downloadFile(ContextoHolder.getTenant(), TipoArquivoArmazenado.EntidadeAnexo, anexo.getCaminho(), false, true);
        return this.responseEntityService.createFileResponse(FileUtil.file2ByteArray((File)file), MediaType.APPLICATION_OCTET_STREAM, anexo.getNomeArquivo());
    }

    protected GridBuilder<EntidadeAnexoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "id", 0, false));
        colunas.add(new ColunaSQL("idEntidade", "idEntidade", 0, false));
        colunas.add(new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 0, true));
        colunas.add(new ColunaSQL("data", "Inclus\u00e3o/Altera\u00e7\u00e3o", 0, true));
        return new GridBuilder(EntidadeAnexoRN.getInstance().getTabela(), colunas);
    }

    protected String getCacheId() {
        return "anexos-entidade";
    }
}

