/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.entidade.cliente.historicolimitecredito;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.LimiteCreditoEntidade;
import br.intelidata.commons.domain.pojo.entidade.LimiteCreditoHistorico;
import br.intelidata.commons.domain.pojo.enuns.TipoPessoa;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeDependenteRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.entidade.regranegocio.LimiteCreditoHistoricoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/historicos-limite-credito"})
public class LimiteCreditoHistoricoCrudController
extends CrudController<LimiteCreditoHistorico, LimiteCreditoHistoricoRN> {
    public LimiteCreditoHistoricoCrudController() {
        super((AbstractRegraNegocio)LimiteCreditoHistoricoRN.getInstance(), LimiteCreditoHistorico::new);
        this.dependsOn("idCliente");
    }

    @RequestMapping(value={"/validar"})
    @DBAutoCommit
    public boolean liberarLimiteCreditoPorDependente(@RequestParam Long idCliente, @RequestParam BigDecimal valorPretendido) throws UnicoMensagemUsuarioException {
        Entidade depPai = EntidadeDependenteRN.getInstance().getPaiDoDependente(idCliente);
        if (depPai != null) {
            LimiteCreditoEntidade limiteCreditoPai = EntidadeRN.getInstance().buscaLimiteCredito(depPai.getId());
            if (limiteCreditoPai == null) {
                throw new UnicoMensagemUsuarioException("WENT61", "N\u00e3o \u00e9 poss\u00edvel informar o limite de cr\u00e9dito, o depente pai n\u00e3o possui limite.");
            }
            if (valorPretendido.compareTo(limiteCreditoPai.getLimiteCredito()) >= 0) {
                throw new UnicoMensagemUsuarioException("WENT62", "O valor do limite de cr\u00e9dito n\u00e3o pode ser maior ou igual que o limite do dependente pai.");
            }
        }
        return true;
    }

    protected void beforeSave(LimiteCreditoHistorico historicoLimite, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (NumberUtil.longNullOuZero((Long)historicoLimite.getIdCliente())) {
            throw new UnicoMensagemUsuarioException("WWW57", "Entidade n\u00e3o informada.");
        }
        if (historicoLimite.isLiberacaoEspecial()) {
            if (historicoLimite.getValorLimiteCreditoEspecial().compareTo(SessaoUtil.getSessao().getUsuario().getValorLimiteCredito()) == 1) {
                throw new UnicoMensagemUsuarioException("WENT29", "O valor pretendido para o limite de cr\u00e9dito especial \u00e9 maior que o autorizado! Verifique.");
            }
            if (historicoLimite.getDataLiberacaoEspecialInicial() == null) {
                throw new UnicoMensagemUsuarioException("WENT30", "Data inicial para a libera\u00e7\u00e3o especial n\u00e3o foi informada! Verifique.");
            }
            if (historicoLimite.getDataLiberacaoEspecialFinal() == null) {
                throw new UnicoMensagemUsuarioException("WENT31", "Data final para a libera\u00e7\u00e3o especial n\u00e3o foi informada! Verifique.");
            }
            if (historicoLimite.getDataLiberacaoEspecialInicial().compareTo(historicoLimite.getDataLiberacaoEspecialFinal()) == 1) {
                throw new UnicoMensagemUsuarioException("WENT32", "Data inicial para a libera\u00e7\u00e3o especial \u00e9 maior que a data final! Verifique.");
            }
            this.liberarLimiteCreditoPorDependente(historicoLimite.getIdCliente(), historicoLimite.getValorLimiteCreditoEspecial());
        } else {
            this.liberarLimiteCreditoPorDependente(historicoLimite.getIdCliente(), historicoLimite.getValorLimiteCredito());
            Entidade entidade = (Entidade)EntidadeRN.getInstance().buscarPorId(historicoLimite.getIdCliente());
            if (historicoLimite.getValorLimiteCredito().compareTo(SessaoUtil.getSessao().getUsuario().getValorLimiteCredito()) == 1 && (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.LIMITE_CREDITO_FORMA_PGMTO) || !TipoPessoa.FISICA.equals((Object)entidade.getTipoPessoa()) || PropriedadeRN.getInstance().getPropriedadeInt(SessaoUtil.getSessao().getFilial(), 599) <= 0)) {
                throw new UnicoMensagemUsuarioException("WENT33", "O valor pretendido para o limite de cr\u00e9dito \u00e9 maior que o autorizado! Verifique.");
            }
            historicoLimite.setDataLiberacaoEspecialInicial(null);
            historicoLimite.setDataLiberacaoEspecialFinal(null);
        }
        if (NumberUtil.longNullOuZero((Long)historicoLimite.getIdUsuarioResponsavel())) {
            historicoLimite.setIdUsuarioResponsavel(SessaoUtil.getSessao().getIdUsuario());
        }
        historicoLimite.setDataInclusao(DataHoraFactory.getData());
    }

    protected void afterSave(LimiteCreditoHistorico historicoLimite, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        Entidade entidade = (Entidade)EntidadeRN.getInstance().buscarPorId(historicoLimite.getIdCliente());
        if (historicoLimite.isLiberacaoEspecial()) {
            entidade.setLimiteCreditoEspecial(historicoLimite.getValorLimiteCreditoEspecial());
            entidade.setValidadeInicialCreditoEspecial(historicoLimite.getDataLiberacaoEspecialInicial());
            entidade.setValidadeFinalCreditoEspecial(historicoLimite.getDataLiberacaoEspecialFinal());
        } else {
            entidade.setLimiteCredito(historicoLimite.getValorLimiteCredito());
        }
        EntidadeRN.getInstance().gravar(1, entidade, SessaoUtil.getSessao());
    }

    protected GridBuilder<LimiteCreditoHistoricoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idCliente", "idCliente", 0, false));
        colunas.add(new ColunaSQL("idFormaPgmto", "idFormaPgmto", 0, false));
        colunas.add(new ColunaSQL("idFormaPgmtoEspecial", "idFormaPgmtoEspecial", 0, false));
        colunas.add(new ColunaSQL("idUsuarioResponsavel", "idUsuarioResponsavel", 0, false));
        colunas.add(new ColunaSQL("dataInclusao", "Data", 150, true));
        colunas.add(new ColunaSQL("valorLimiteCredito", "Valor", 150, true));
        colunas.add(new ColunaSQL("valorLimiteCreditoEspecial", "Libera\u00e7\u00e3o especial", 150, true));
        colunas.add(new ColunaSQL("dataLiberacaoEspecialInicial", "Validade inicial", 150, true));
        colunas.add(new ColunaSQL("dataLiberacaoEspecialFinal", "Validade final", 150, true));
        colunas.add(new ColunaSQL("nome", "usuarioResponsavel", "Usu\u00e1rio respons\u00e1vel", 150, true, new String[]{"fk_limitecreditohis_usuario"}));
        colunas.add(new ColunaSQL("descricao", "formaPgmto", "Meio de Pgto", 150, true, new String[]{"fk_limitecreditohis_pgmto"}));
        colunas.add(new ColunaSQL("descricao", "formaPgmtoEspecial", "Meio de Pgto Especial", 150, true, new String[]{"fk_limitecreditohis_pgmtoespc"}));
        GridBuilder grid = new GridBuilder(LimiteCreditoHistoricoRN.getInstance().getTabela(), colunas);
        grid.setOrdemDefault(new Ordem("id", true));
        return grid;
    }

    protected String getCacheId() {
        return "historicos-limite-credito";
    }
}

