/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.entidade.cliente.limitecreditoformapagamento;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.entidade.LimiteCreditoFormaPgmto;
import br.intelidata.commons.domain.pojo.enuns.TipoPessoa;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeDependenteRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.entidade.regranegocio.LimiteCreditoFormaPgmtoRN;
import br.intelidata.commons.modulo.entidade.regranegocio.LimiteCreditoHistoricoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.entidade.cliente.limitecreditoformapagamento.LimiteCreditoFormaPgmtoWrapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/limites-credito-forma-pgmto"})
public class LimiteCreditoFormaPgmtoCrudController
extends CrudController<LimiteCreditoFormaPgmto, LimiteCreditoFormaPgmtoRN> {
    public LimiteCreditoFormaPgmtoCrudController() {
        super((AbstractRegraNegocio)LimiteCreditoFormaPgmtoRN.getInstance(), LimiteCreditoFormaPgmto::new);
        this.dependsOn("idCliente");
    }

    @RequestMapping(value={"/buscar-limites"})
    @DBAutoCommit
    public LimiteCreditoFormaPgmtoWrapper buscarLimites(@RequestParam Long idCliente) throws UnicoMensagemUsuarioException {
        return new LimiteCreditoFormaPgmtoWrapper(LimiteCreditoFormaPgmtoRN.getInstance().buscaPorCliente(idCliente), LimiteCreditoHistoricoRN.getInstance().buscarHistoricoLimitesPorIdCliente(idCliente));
    }

    @RequestMapping(value={"/validar"})
    @DBAutoCommit
    public boolean liberarLimiteCreditoPorDependente(@RequestParam Long idCliente, @RequestParam BigDecimal valorPretendido, @RequestParam Long idFormPagamento) throws UnicoMensagemUsuarioException {
        Entidade depPai = EntidadeDependenteRN.getInstance().getPaiDoDependente(idCliente);
        if (depPai != null) {
            boolean consideraOrdensServicoLimiteCredito = PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 776);
            boolean consideraPedidosLimiteCredito = PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 479);
            boolean consideraOrcamentosLimiteCredito = PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 501);
            boolean consideraVendasAVistaLimiteCredito = PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 711);
            List listForPag = LimiteCreditoFormaPgmtoRN.getInstance().buscaLimitesFormaPgmtoDisponivel(depPai.getId(), consideraPedidosLimiteCredito, consideraOrcamentosLimiteCredito, consideraOrdensServicoLimiteCredito, consideraVendasAVistaLimiteCredito);
            LimiteCreditoFormaPgmto lcfp = null;
            for (LimiteCreditoFormaPgmto limitFormPag : listForPag) {
                if (!limitFormPag.getIdFormaPgmto().equals(idFormPagamento)) continue;
                lcfp = limitFormPag;
                break;
            }
            if (lcfp == null) {
                throw new UnicoMensagemUsuarioException("WENT59", "N\u00e3o \u00e9 poss\u00edvel liberar cr\u00e9dito para este meio de pagamento, pois o dependente pai n\u00e3o possui libera\u00e7\u00e3o do o mesmo");
            }
            if (valorPretendido.compareTo(lcfp.getValorLimiteCredito()) >= 0) {
                throw new UnicoMensagemUsuarioException("WENT60", "O valor do limite de cr\u00e9dito n\u00e3o pode ser maior ou igual que o limite do dependente pai");
            }
        }
        return true;
    }

    protected void beforeSave(LimiteCreditoFormaPgmto limiteFormPgmto, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (NumberUtil.longNullOuZero((Long)limiteFormPgmto.getIdCliente())) {
            throw new UnicoMensagemUsuarioException("WWW410", "Entidade n\u00e3o informada.");
        }
        if (NumberUtil.longNullOuZero((Long)limiteFormPgmto.getIdFormaPgmto())) {
            throw new UnicoMensagemUsuarioException("WWW58", "Meio de pagamento n\u00e3o informado.");
        }
        if (limiteFormPgmto.isLiberacaoEspecial()) {
            if (limiteFormPgmto.getValorLimiteCreditoEspecial().compareTo(SessaoUtil.getSessao().getUsuario().getValorLimiteCredito()) == 1) {
                throw new UnicoMensagemUsuarioException("WENT82", "O valor pretendido para o limite de cr\u00e9dito especial \u00e9 maior que o autorizado! Verifique.");
            }
            if (limiteFormPgmto.getDataLiberacaoEspecialInicial() == null) {
                throw new UnicoMensagemUsuarioException("WENT83", "Data inicial para a libera\u00e7\u00e3o especial n\u00e3o foi informada! Verifique.");
            }
            if (limiteFormPgmto.getDataLiberacaoEspecialFinal() == null) {
                throw new UnicoMensagemUsuarioException("WENT84", "Data final para a libera\u00e7\u00e3o especial n\u00e3o foi informada! Verifique.");
            }
            if (limiteFormPgmto.getDataLiberacaoEspecialInicial().compareTo(limiteFormPgmto.getDataLiberacaoEspecialFinal()) == 1) {
                throw new UnicoMensagemUsuarioException("WENT85", "Data inicial para a libera\u00e7\u00e3o especial \u00e9 maior que a data final! Verifique.");
            }
            this.liberarLimiteCreditoPorDependente(limiteFormPgmto.getIdCliente(), limiteFormPgmto.getValorLimiteCreditoEspecial(), limiteFormPgmto.getIdFormaPgmto());
        } else {
            this.liberarLimiteCreditoPorDependente(limiteFormPgmto.getIdCliente(), limiteFormPgmto.getValorLimiteCredito(), limiteFormPgmto.getIdFormaPgmto());
            Entidade entidade = (Entidade)EntidadeRN.getInstance().buscarPorId(limiteFormPgmto.getIdCliente());
            if (limiteFormPgmto.getValorLimiteCredito().compareTo(SessaoUtil.getSessao().getUsuario().getValorLimiteCredito()) == 1 && (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.LIMITE_CREDITO_FORMA_PGMTO) || !TipoPessoa.FISICA.equals((Object)entidade.getTipoPessoa()) || PropriedadeRN.getInstance().getPropriedadeInt(SessaoUtil.getSessao().getFilial(), 599) <= 0)) {
                throw new UnicoMensagemUsuarioException("WENT86", "O valor pretendido para o limite de cr\u00e9dito \u00e9 maior que o autorizado! Verifique.");
            }
            limiteFormPgmto.setDataLiberacaoEspecialInicial(null);
            limiteFormPgmto.setDataLiberacaoEspecialFinal(null);
        }
        if (NumberUtil.longNullOuZero((Long)limiteFormPgmto.getIdUsuarioResponsavel())) {
            limiteFormPgmto.setIdUsuarioResponsavel(SessaoUtil.getSessao().getIdUsuario());
        }
        limiteFormPgmto.setDataInclusao(DataHoraFactory.getData());
    }

    @DBTransaction
    public Long create(@RequestBody LimiteCreditoFormaPgmto limiteCreditoFormaPgmto, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        this.beforeSave(limiteCreditoFormaPgmto, parentId);
        Long id = this.gravarLimite(limiteCreditoFormaPgmto);
        this.gravarAuditoriaRegistro(null, (AbstractPojo)limiteCreditoFormaPgmto, 0);
        this.afterCreate((AbstractPojo)limiteCreditoFormaPgmto, parentId);
        this.afterSave((AbstractPojo)limiteCreditoFormaPgmto, parentId);
        this.dashBoardRabbitService.sendMessage(ContextoHolder.getTenant());
        return id;
    }

    @DBTransaction
    public Long update(@RequestBody LimiteCreditoFormaPgmto limiteCreditoFormaPgmto, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        this.validarCurrentTimeMillis((AbstractPojo)limiteCreditoFormaPgmto);
        this.beforeSave(limiteCreditoFormaPgmto, parentId);
        this.gravarAuditoriaRegistro(limiteCreditoFormaPgmto.getId(), (AbstractPojo)limiteCreditoFormaPgmto, 1);
        Long id = this.gravarLimite(limiteCreditoFormaPgmto);
        this.afterUpdate((AbstractPojo)limiteCreditoFormaPgmto, parentId);
        this.afterSave((AbstractPojo)limiteCreditoFormaPgmto, parentId);
        this.dashBoardRabbitService.sendMessage(ContextoHolder.getTenant());
        return id;
    }

    protected GridBuilder<LimiteCreditoFormaPgmtoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idCliente", "idCliente", 0, false));
        colunas.add(new ColunaSQL("idFormaPgmto", "idFormaPgmto", 0, false));
        colunas.add(new ColunaSQL("dataInclusao", "Data", 150, true));
        colunas.add(new ColunaSQL("idUsuarioResponsavel", "idUsuarioResponsavel", 0, false));
        colunas.add(new ColunaSQL("valorLimiteCredito", "Valor", 150, true));
        colunas.add(new ColunaSQL("valorLimiteCreditoEspecial", "Valor Libera\u00e7\u00e3o especial", 150, true));
        colunas.add(new ColunaSQL("bloquearCliente", "Bloquear cliente", 150, true));
        colunas.add(new ColunaSQL("liberacaoespecial", "Libera\u00e7\u00e3o especial", 150, true));
        colunas.add(new ColunaSQL("liberarclientecomatraso", "Liberar cliente com atraso", 150, true));
        colunas.add(new ColunaSQL("dataLiberacaoEspecialInicial", "Validade inicial", 150, true));
        colunas.add(new ColunaSQL("dataLiberacaoEspecialFinal", "Validade final", 150, true));
        colunas.add(new ColunaSQL("nome", "usuarioResponsavel", "Usu\u00e1rio respons\u00e1vel", 150, true, new String[]{"limite_forma_pgmto_usu"}));
        colunas.add(new ColunaSQL("descricao", "formaPgmto", "Meio de Pgto", 150, true, new String[]{"limite_forma_pgmto"}));
        return new GridBuilder(LimiteCreditoFormaPgmtoRN.getInstance().getTabela(), colunas);
    }

    protected String getCacheId() {
        return "limites-credito-forma-pgmto";
    }

    private Long gravarLimite(LimiteCreditoFormaPgmto limiteCreditoFormaPgmto) throws UnicoMensagemUsuarioException {
        LimiteCreditoFormaPgmto limiteExistente = LimiteCreditoFormaPgmtoRN.getInstance().buscaPorCliente(limiteCreditoFormaPgmto.getIdCliente(), limiteCreditoFormaPgmto.getIdFormaPgmto());
        if (limiteExistente != null) {
            if (limiteCreditoFormaPgmto.isLiberacaoEspecial()) {
                limiteExistente.setValorLimiteCreditoEspecial(limiteCreditoFormaPgmto.getValorLimiteCreditoEspecial());
                limiteExistente.setDataLiberacaoEspecialInicial(limiteCreditoFormaPgmto.getDataLiberacaoEspecialInicial());
                limiteExistente.setDataLiberacaoEspecialFinal(limiteCreditoFormaPgmto.getDataLiberacaoEspecialFinal());
            } else {
                limiteExistente.setValorLimiteCredito(limiteCreditoFormaPgmto.getValorLimiteCredito());
            }
            limiteExistente.setDataInclusao(limiteCreditoFormaPgmto.getDataInclusao());
            limiteExistente.setLiberacaoEspecial(limiteCreditoFormaPgmto.isLiberacaoEspecial());
            limiteExistente.setIdUsuarioResponsavel(limiteCreditoFormaPgmto.getIdUsuarioResponsavel());
            LimiteCreditoFormaPgmtoRN.getInstance().gravar(1, (AbstractPojo)limiteExistente, SessaoUtil.getSessao());
            return limiteExistente.getId();
        }
        return LimiteCreditoFormaPgmtoRN.getInstance().gravar(0, (AbstractPojo)limiteCreditoFormaPgmto, SessaoUtil.getSessao());
    }
}

