/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.entidade.historicocliente;

import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.LimiteCreditoEntidade;
import br.intelidata.commons.domain.pojo.entidade.LimiteCreditoFormaPgmto;
import br.intelidata.commons.domain.pojo.enuns.TipoRetornoDataValorCompraCliente;
import br.intelidata.commons.domain.pojo.financeiro.TipoFinanceiro;
import br.intelidata.commons.domain.pojo.pvdav.Dav;
import br.intelidata.commons.modulo.devolucao.regranegocio.DevolucaoRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeDependenteRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.entidade.regranegocio.LimiteCreditoFormaPgmtoRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.FinanceiroDadoRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.FinanceiroLancamentoRN;
import br.intelidata.commons.modulo.pvdav.regranegocio.DavRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.entidade.historicocliente.HistoricoClienteWrapper;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/historico-cliente"})
public class HistoricoClienteSimpleController
extends SimpleCrudController<Entidade, EntidadeRN> {
    @RequestMapping(value={"/buscar-historico"})
    @DBAutoCommit
    public HistoricoClienteWrapper buscarHistorico(@RequestParam Long idCliente) {
        LimiteCreditoEntidade limiteCredito;
        Dav menorPedido;
        Dav maiorPedido;
        Dav ultimoPedido;
        HistoricoClienteWrapper historico = new HistoricoClienteWrapper();
        Entidade entidade = (Entidade)EntidadeRN.getInstance().buscarPorId(idCliente);
        if (entidade != null) {
            historico.setDataCadastro(entidade.getDataCadastro());
        }
        if ((ultimoPedido = DavRN.getInstance().buscarUltimoPedido(idCliente)) != null) {
            historico.setDataUltimoPedido(ultimoPedido.getData());
            historico.setValorUltimoPedido(ultimoPedido.getValor() != null ? ultimoPedido.getValor() : BigDecimal.ZERO);
        }
        if ((maiorPedido = DavRN.getInstance().buscarMaiorPedido(idCliente)) != null) {
            historico.setDataMaiorPedido(maiorPedido.getData());
            historico.setValorMaiorPedido(maiorPedido.getValor() != null ? maiorPedido.getValor() : BigDecimal.ZERO);
        }
        if ((menorPedido = DavRN.getInstance().buscarMenorPedido(idCliente)) != null) {
            historico.setDataMenorPedido(menorPedido.getData());
            historico.setValorMenorPedido(menorPedido.getValor() != null ? menorPedido.getValor() : BigDecimal.ZERO);
        }
        historico.setQuantidadeTotalPedido(DavRN.getInstance().buscarQuantidadePedidos(idCliente));
        historico.setValorMedioPedido(DavRN.getInstance().buscarValorMedioPedidos(idCliente));
        historico.setTotalCompras(EntidadeRN.getInstance().buscaValorFaturadoPorEntidadeNotaCupom(Contexto.getInstance().getSessao(), idCliente));
        historico.setTotalPagamentos(FinanceiroLancamentoRN.getInstance().buscarValorPorEntidade(idCliente, TipoFinanceiro.RECEBER));
        historico.setListaLimites(new ArrayList());
        BigDecimal creditoUtilizadoFormaPgmto = BigDecimal.ZERO;
        boolean consideraOrdensServicoLimiteCredito = PropriedadeRN.getInstance().getPropriedadeBoolean(Contexto.getInstance().getSessao().getFilial(), 776);
        boolean consideraPedidosLimiteCredito = PropriedadeRN.getInstance().getPropriedadeBoolean(Contexto.getInstance().getSessao().getFilial(), 479);
        boolean consideraOrcamentosLimiteCredito = PropriedadeRN.getInstance().getPropriedadeBoolean(Contexto.getInstance().getSessao().getFilial(), 501);
        boolean consideraVendasAVistaLimiteCredito = PropriedadeRN.getInstance().getPropriedadeBoolean(Contexto.getInstance().getSessao().getFilial(), 711);
        boolean financeiroControlaSaldoDevolucao = FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.SALDO_DEVOLUCAO_CONTROLADO_FINANCEIRO);
        if (!financeiroControlaSaldoDevolucao) {
            historico.setSaldoDevolucao(DevolucaoRN.getInstance().getSaldoDevolucao(idCliente));
        }
        historico.setCreditoAtual(FinanceiroDadoRN.getInstance().buscaSaldoPorEntidade(idCliente, false));
        if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.LIMITE_CREDITO_FORMA_PGMTO)) {
            ArrayList listaLimites = new ArrayList(LimiteCreditoFormaPgmtoRN.getInstance().buscaPorCliente(idCliente));
            Long idEntidade = idCliente;
            Entidade dependentePai = EntidadeDependenteRN.getInstance().getPaiDoDependente(idCliente);
            if (dependentePai != null && Util.listNullOrEmpty(listaLimites)) {
                idEntidade = dependentePai.getId();
                listaLimites.addAll(LimiteCreditoFormaPgmtoRN.getInstance().buscaPorCliente(idEntidade));
            }
            for (LimiteCreditoFormaPgmto limiteCreditoFormaPgmto : listaLimites) {
                LimiteCreditoEntidade limiteCredito2 = EntidadeRN.getInstance().buscaLimiteCredito(idEntidade, limiteCreditoFormaPgmto.getIdFormaPgmto(), consideraPedidosLimiteCredito, consideraOrcamentosLimiteCredito, consideraOrdensServicoLimiteCredito, consideraVendasAVistaLimiteCredito);
                limiteCreditoFormaPgmto.setValorLimiteCredito(limiteCredito2.getLimiteCredito());
                limiteCreditoFormaPgmto.setDivida(limiteCredito2.getDivida());
                limiteCreditoFormaPgmto.setDividaDependentes(limiteCredito2.getDividaDependentes());
                limiteCreditoFormaPgmto.setCreditoDisponivel(limiteCredito2.getLimiteCreditoDisponivel());
                if (limiteCredito2.getLimiteCreditoPai() != null) {
                    limiteCreditoFormaPgmto.setDividaPai(limiteCredito2.getLimiteCreditoPai().getDividaTotal().subtract(limiteCredito2.getDivida()));
                    limiteCreditoFormaPgmto.setValorLimiteCreditoPai(limiteCredito2.getLimiteCreditoPai().getLimiteCredito());
                }
                creditoUtilizadoFormaPgmto = creditoUtilizadoFormaPgmto.add(limiteCreditoFormaPgmto.getValorLimiteCredito().subtract(limiteCreditoFormaPgmto.getCreditoDisponivel()));
            }
            historico.setListaLimites(listaLimites);
        }
        historico.setDividaAtual((limiteCredito = EntidadeRN.getInstance().buscaLimiteCredito(idCliente, consideraPedidosLimiteCredito, consideraOrcamentosLimiteCredito, consideraOrdensServicoLimiteCredito, consideraVendasAVistaLimiteCredito)).getDivida() != null ? limiteCredito.getDivida() : BigDecimal.ZERO);
        historico.setDividaDependentes(limiteCredito.getDividaDependentes() != null ? limiteCredito.getDividaDependentes() : BigDecimal.ZERO);
        historico.setLimiteDisponivel(Util.bigDecimalNullOrZero((BigDecimal)creditoUtilizadoFormaPgmto) ? limiteCredito.getLimiteCreditoDisponivel() : limiteCredito.getLimiteCredito().subtract(limiteCredito.getDividaTotal().subtract(creditoUtilizadoFormaPgmto)));
        historico.setLimiteCredito(limiteCredito.getLimiteCredito());
        historico.setDataPrimeiraCompra((LocalDate)EntidadeRN.getInstance().buscarDataValorCompraCliente(idCliente, TipoRetornoDataValorCompraCliente.DATA_PRIMEIRA_COMPRA));
        historico.setDataUltimaCompra((LocalDate)EntidadeRN.getInstance().buscarDataValorCompraCliente(idCliente, TipoRetornoDataValorCompraCliente.DATA_ULTIMA_COMPRA));
        BigDecimal valorPrimeiraCompra = (BigDecimal)EntidadeRN.getInstance().buscarDataValorCompraCliente(idCliente, TipoRetornoDataValorCompraCliente.VALOR_PRIMEIRA_COMPRA);
        historico.setValorPrimeiraCompra(valorPrimeiraCompra == null ? BigDecimal.ZERO : valorPrimeiraCompra);
        BigDecimal valorUltimaCompra = (BigDecimal)EntidadeRN.getInstance().buscarDataValorCompraCliente(idCliente, TipoRetornoDataValorCompraCliente.VALOR_ULTIMA_COMPRA);
        historico.setValorUltimaCompra(valorUltimaCompra == null ? BigDecimal.ZERO : valorUltimaCompra);
        return historico;
    }
}

