/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.expedicao.notatransferenciacupom;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.OperadorLogico;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.sql.usql.Separador;
import br.intelidata.commons.core.util.EnumSimNao;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Item;
import br.intelidata.commons.domain.pojo.enuns.TipoKit;
import br.intelidata.commons.domain.pojo.enuns.TipoRetiradaEntregaItem;
import br.intelidata.commons.domain.pojo.enuns.pafecf.StatusNfce;
import br.intelidata.commons.domain.pojo.enuns.pafecf.TipoOperacao;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalRN;
import br.intelidata.commons.modulo.pdv.regranegocio.ItemRN;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/notas-transferencia-cupom"})
@SubMenuMapping(MENU="SubMenuEstoqueExpedicao", NOME="Gerar nota fiscal de transfer\u00eancia do PDV", ROTA="/expedicoes/notas-transferencia-cupom", PROGRAMA=318, ICONE="icon-transferencia")
public class NotaTransferenciaCupomCrudController
extends CrudController<Item, ItemRN> {
    @Autowired
    public NotaTransferenciaCupomCrudController() {
        super((AbstractRegraNegocio)ItemRN.getInstance(), Item::new, true, true, false);
    }

    protected GridBuilder<ItemRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("data", "data", "Data", 120, true, new String[]{"fk_item_operacao"}));
        colunas.add(new ColunaSQL("codigo", "codigoproduto", "C\u00f3digo", 120, true, new String[]{"fk_item_produto"}));
        colunas.add(new ColunaSQL("nome", "nomeproduto", "Produto", 300, true, new String[]{"fk_item_produto"}));
        colunas.add(new ColunaSQL("codigo", "codigounidademedida", "UN", 80, true, new String[]{"fk_item_unidademedida"}));
        colunas.add(new ColunaSQL("quantidade", "quantidade", "Quantidade", 150, true, new String[0]));
        colunas.add(new ColunaSQL("precounitario", "precounitario", "Pre\u00e7o unit\u00e1rio", 150, true, new String[0]));
        colunas.add(new ColunaSQL("precoliquido", "totalitem", "Total item", 150, true, new String[0]));
        colunas.add(new ColunaSQL("valorliquido", "total", "Total venda", 150, true, new String[]{"fk_item_operacao"}));
        colunas.add(new ColunaSQL("nome", "nomecliente", "Cliente", 300, true, new String[]{"fk_item_operacao", "fk_operacao_entidade"}));
        colunas.add(new ColunaSQL("razaosocial", "nomefilialretiradaentrega", "Filial entrega/retirada", 200, true, new String[]{"fk_item_filialretirada"}));
        colunas.add(new ColunaSQL("nome", "cidadeentrega", "Cidade entrega/retirada", 200, true, new String[]{"fk_item_operacao", "fk_operacao_entrega_cidade"}));
        GridBuilder grid = new GridBuilder(ItemRN.getInstance().getTabela(), colunas);
        grid.addReferenciaDefault(new Referencia("statusnfce", "statusnfce", new String[]{"fk_item_operacao"}));
        grid.addReferenciaDefault(new Referencia("id", "idfilial", new String[]{"fk_item_operacao", "fk_operacao_filial"}));
        grid.addReferenciaDefault(new Referencia("tipoentrega", "tipoentrega", new String[]{"fk_item_operacao"}));
        grid.addReferenciaDefault(new Referencia("tiporetiradaentregaitem", "tiporetiradaentrega"));
        grid.addReferenciaDefault(new Referencia("idnotafiscalexpedicao"));
        grid.addReferenciaDefault(new Referencia("cancelado", "canceladoitem"));
        grid.addReferenciaDefault(new Referencia("cancelado", "canceladooperacao", new String[]{"fk_item_operacao"}));
        grid.addReferenciaDefault(new Referencia("tipo", "tipooperacao", new String[]{"fk_item_operacao"}));
        grid.addReferenciaDefault(new Referencia("id", "idcliente", new String[]{"fk_item_operacao", "fk_operacao_entidade"}));
        grid.addReferenciaDefault(new Referencia("kit", "kit"));
        grid.addReferenciaDefault(new Referencia("idfilialretirada", "idfilialretiradaentrega"));
        grid.addReferenciaDefault(new Referencia("manualordem", "manualordem", new String[]{"fk_item_operacao"}));
        grid.addReferenciaDefault(new Referencia("nfce", "nfce", new String[]{"fk_item_operacao"}));
        grid.addReferenciaDefault(new Referencia("coo", "coo", new String[]{"fk_item_operacao"}));
        grid.addReferenciaDefault(new Referencia("pdv", "pdv", new String[]{"fk_item_operacao"}));
        grid.addReferenciaDefault(new Referencia("modelonfce", "modelonfce", new String[]{"fk_item_operacao"}));
        grid.addReferenciaDefault(new Referencia("satserie", "satserie", new String[]{"fk_item_operacao"}));
        grid.addReferenciaDefault(new Referencia("serienfce", "serienfce", new String[]{"fk_item_operacao"}));
        grid.addReferenciaDefault(new Referencia("numeronfce", "numeronfce", new String[]{"fk_item_operacao"}));
        Long idFilial = SessaoUtil.getSessao().getIdFilial();
        grid.addCodicaoDefault(new Condicao("idfilial", Operador.IGUAL, idFilial));
        grid.addCodicaoDefault(new Condicao("idfilialretiradaentrega", Operador.DIFERENTE, idFilial));
        grid.addCodicaoDefault(new Condicao("kit", Operador.CONTIDO_EM, new Integer[]{TipoKit.KIT_COMPONENTE.getId(), TipoKit.SEM_KIT.getId()}));
        grid.addCodicaoDefault(new Condicao("tiporetiradaentrega", Operador.CONTIDO_EM, new Integer[]{TipoRetiradaEntregaItem.ENTREGA.getId(), TipoRetiradaEntregaItem.RETIRADA.getId()}));
        grid.addCodicaoDefault(new Condicao("tipooperacao", Operador.CONTIDO_EM, new Integer[]{TipoOperacao.VENDA.getId(), TipoOperacao.VENDA_MANUAL.getId()}));
        grid.addCodicaoDefault(new Condicao("canceladoitem", Operador.IGUAL, EnumSimNao.NAO.getId().intValue()));
        grid.addCodicaoDefault(new Condicao("canceladooperacao", Operador.IGUAL, EnumSimNao.NAO.getId().intValue()));
        grid.addCodicaoDefault(new Condicao(OperadorLogico.E));
        grid.addCodicaoDefault(new Condicao(Separador.ABRE_PARENTESIS));
        grid.addCodicaoDefault(new Condicao("nfce", Operador.IGUAL, EnumSimNao.NAO.getId().intValue()));
        grid.addCodicaoDefault(new Condicao(OperadorLogico.OU));
        grid.addCodicaoDefault(new Condicao(Separador.ABRE_PARENTESIS));
        grid.addCodicaoDefault(new Condicao("nfce", Operador.IGUAL, EnumSimNao.SIM.getId().intValue()));
        grid.addCodicaoDefault(new Condicao(OperadorLogico.E));
        grid.addCodicaoDefault(new Condicao("statusnfce", Operador.CONTIDO_EM, new Integer[]{StatusNfce.AUTORIZADA.getId(), StatusNfce.AUTORIZADA_COM_PENDENCIA.getId(), StatusNfce.EMITIDA_EM_CONTIGENCIA.getId()}));
        grid.addCodicaoDefault(new Condicao(Separador.FECHA_PARENTESIS));
        grid.addCodicaoDefault(new Condicao(Separador.FECHA_PARENTESIS));
        grid.addCodicaoDefault(new Condicao(OperadorLogico.E));
        grid.addCodicaoDefault(new Condicao(Separador.ABRE_PARENTESIS));
        grid.addCodicaoDefault(new Condicao("idnotafiscalexpedicao", Operador.IGUAL, Long.valueOf(0L)));
        grid.addCodicaoDefault(new Condicao(OperadorLogico.OU));
        grid.addCodicaoDefault(new Condicao("idnotafiscalexpedicao", Operador.IS_NULL));
        grid.addCodicaoDefault(new Condicao(Separador.FECHA_PARENTESIS));
        grid.addOrdem(new Ordem("data"));
        return grid;
    }

    @RequestMapping(value={"/gerar-nota-fiscal"}, method={RequestMethod.POST})
    @DBTransaction
    public void gerarNotaFiscal(@RequestBody List<Long> ids) throws UnicoMensagemUsuarioException {
        if (!Util.listNullOrEmpty(ids)) {
            List itens = ids.stream().map(idItem -> (Item)ItemRN.getInstance().buscarPorId(idItem)).collect(Collectors.toList());
            NotaFiscalRN.getInstance().importarCuponsTransferenciaExpedicao(SessaoUtil.getSessao(), itens);
        }
    }

    protected String getCacheId() {
        return "notas-transferencia-cupom";
    }
}

