/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.fechamentopdv;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.LicencaManager;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.enuns.pafecf.StatusFechamentoPdv;
import br.intelidata.commons.domain.pojo.pafecf.CalculadoraFechamentoPdv;
import br.intelidata.commons.domain.pojo.pafecf.FechamentoPdv;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.CalculadoraFechamentoPdvCommonRN;
import br.intelidata.commons.domain.regranegocio.FechamentoPdvCommonRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.ContaCorrenteLancamentoRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.GeraFinanceiroFechamentoPdv;
import br.intelidata.commons.modulo.financeiro.relatorio.FechamentoPdvRelatorio;
import br.intelidata.commons.modulo.financeiro.relatorio.fechamento.novo.FechamentoPdvModel;
import br.intelidata.commons.modulo.financeiro.relatorio.fechamento.novo.FechamentoPdvParam;
import br.intelidata.commons.modulo.financeiro.relatorio.fechamento.novo.GeraFechamentoPdv;
import br.intelidata.commons.modulo.pdv.regranegocio.PendenciaProcessamentoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.FilterField;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.RelatorioUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.client.print.SaidaImpressaoWrapper;
import br.intelidata.uniplusweb.web.rest.app.client.report.SaidaRelatorio;
import br.intelidata.uniplusweb.web.rest.app.crud.fechamentopdv.FechamentoPdvCaixa;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/fechamento-pdv"})
@SubMenuMapping(MENU="SubMenuPdvGeral", NOME="Controle de fechamento do PDV", ICONE="icon icon-e-moeda", ROTA="/pdvs/fechamento-pdv", PROGRAMA=1437)
public class FechamentoPdvCrudCotroller
extends CrudController<FechamentoPdv, FechamentoPdvCommonRN> {
    public FechamentoPdvCrudCotroller() {
        super((AbstractRegraNegocio)FechamentoPdvCommonRN.getInstance(), FechamentoPdv::new, true, true);
    }

    @RequestMapping(value={"/buscar"})
    @DBAutoCommit
    public FechamentoPdv buscarPorId(@RequestParam Long idFechamento) throws UnicoMensagemUsuarioException {
        FechamentoPdv fechamentoPdv = (FechamentoPdv)((FechamentoPdvCommonRN)this.rn).buscarPorId(idFechamento);
        if (fechamentoPdv.getStatus() == StatusFechamentoPdv.FECHADO) {
            throw new UnicoMensagemUsuarioException("WPDV1043", "Fechamento de Origem est\u00e1 conferido.");
        }
        this.carregarFechamento(fechamentoPdv);
        return fechamentoPdv;
    }

    @RequestMapping(value={"/buscar-por-codigo"})
    @DBAutoCommit
    public FechamentoPdv buscarPorCodigo(@RequestParam String codigo) throws UnicoMensagemUsuarioException {
        FechamentoPdv fechamentoPdv = (FechamentoPdv)((FechamentoPdvCommonRN)this.rn).buscarPorCodigo(codigo);
        if (fechamentoPdv == null) {
            throw new UnicoMensagemUsuarioException("WPDV1026", "Fechamento de Destino n\u00e3o encontrado.");
        }
        this.carregarFechamento(fechamentoPdv);
        return fechamentoPdv;
    }

    @RequestMapping(value={"/calculadora"})
    @DBAutoCommit
    public CalculadoraFechamentoPdv carregarCalculadora(@RequestParam Long idFechamento) throws UnicoMensagemUsuarioException {
        FechamentoPdv fechamento = (FechamentoPdv)FechamentoPdvCommonRN.getInstance().buscarPorId(idFechamento);
        CalculadoraFechamentoPdv calculadora = CalculadoraFechamentoPdvCommonRN.getInstance().buscarPorIdOperacao(Util.firstNonNull((Long)fechamento.getIdOperacao(), (Long)0L));
        if (calculadora == null) {
            throw new UnicoMensagemUsuarioException("WPDV631", "N\u00e3o existe dados na calculadora para confer\u00eancia.");
        }
        return calculadora;
    }

    @RequestMapping(value={"/calculadora_alterar"}, method={RequestMethod.PUT})
    @DBAutoCommit
    public void alterarCalculadora(@RequestBody CalculadoraFechamentoPdv calculadora) throws UnicoMensagemUsuarioException {
        CalculadoraFechamentoPdvCommonRN.getInstance().alterar((AbstractPojo)calculadora, SessaoUtil.getSessao());
    }

    @RequestMapping(value={"/validar-alteracao"})
    @DBAutoCommit
    public void validarAlteracao(@RequestParam Long id, @RequestParam int modo) throws UnicoMensagemUsuarioException {
        FechamentoPdv fechamento = (FechamentoPdv)FechamentoPdvCommonRN.getInstance().buscarPorId(id);
        if (fechamento != null && !fechamento.getStatus().equals((Object)StatusFechamentoPdv.PENDENTE_SUPRIMENTO)) {
            throw new UnicoMensagemUsuarioException("WDV652", "Altera\u00e7\u00e3o permitida somente para fechamento com status pendente de suprimento.");
        }
    }

    @RequestMapping(value={"/conferencia"})
    @DBAutoCommit
    public FechamentoPdv conferir(@RequestParam Long id) throws UnicoMensagemUsuarioException {
        FechamentoPdv fechamento = (FechamentoPdv)FechamentoPdvCommonRN.getInstance().buscarPorId(id);
        if (fechamento != null) {
            if (fechamento.isFechado()) {
                throw new UnicoMensagemUsuarioException("WPDV594", "Caixa j\u00e1 est\u00e1 conferido.");
            }
            if ((fechamento.isAberto() || fechamento.isPendenteFechamento()) && PendenciaProcessamentoRN.getInstance().existePendenciaProcessamento()) {
                throw new UnicoMensagemUsuarioException("WPDV732", "Imposs\u00edvel continuar. Resolva todas as opera\u00e7\u00f5es com pend\u00eancia de processamento primeiro.");
            }
            if (fechamento.getUsuarioCaixa() == null) {
                throw new UnicoMensagemUsuarioException("WPDV656", "O fechamento n\u00e3o possui operador. Imposs\u00edvel de fechar.");
            }
            FechamentoPdv fechamentoAnterior = FechamentoPdvCommonRN.getInstance().buscarFechamentoRetroativoAbertoPorUsuario(fechamento.getIdUsuario(), fechamento.getData(), fechamento.getId());
            if (fechamentoAnterior != null) {
                throw new UnicoMensagemUsuarioException("WPDV628", "Existe fechamento PDV em aberto para esse usu\u00e1rio! Verifique fechamento n\u00ba " + fechamentoAnterior.getCodigo() + " da filial " + fechamentoAnterior.getFilial().getCodigo() + ".");
            }
            return fechamento;
        }
        return null;
    }

    @RequestMapping(value={"/reabrir"})
    @DBAutoCommit
    public void reabrirFechamento(@RequestParam Long id) throws UnicoMensagemUsuarioException {
        FechamentoPdv fechamento = (FechamentoPdv)((FechamentoPdvCommonRN)this.rn).buscarPorId(id);
        if (!fechamento.isFechado()) {
            throw new UnicoMensagemUsuarioException("WPDV674", "Documento n\u00e3o pode ser reaberto pois n\u00e3o est\u00e1 fechado.");
        }
        FechamentoPdvCommonRN.getInstance().reabrirFechamento(fechamento, SessaoUtil.getSessao());
    }

    @RequestMapping(value={"/lancamentos-caixa"})
    @DBAutoCommit
    public FechamentoPdvCaixa buscarLancamentoCaixa(@RequestParam Long idFechamento) throws UnicoMensagemUsuarioException {
        FechamentoPdv fechamentoPdv = (FechamentoPdv)((FechamentoPdvCommonRN)this.rn).buscarPorId(idFechamento);
        Long[] idEventos = ((FechamentoPdvCommonRN)this.rn).getIdEventos(fechamentoPdv);
        Long idCaixa = ContaCorrenteLancamentoRN.getInstance().getIdCaixa(idEventos);
        return new FechamentoPdvCaixa(idEventos, idCaixa);
    }

    @RequestMapping(value={"/financeiro"})
    @DBAutoCommit
    public void validaFinanceiro(@RequestParam Long idFechamento) throws UnicoMensagemUsuarioException {
        FechamentoPdv fechamentoPdv = (FechamentoPdv)((FechamentoPdvCommonRN)this.rn).buscarPorId(idFechamento);
        if (fechamentoPdv.getValorDescontado().compareTo(BigDecimal.ZERO) <= 0) {
            throw new UnicoMensagemUsuarioException("WPDV1434", "O Fechamento n\u00e3o possui valor de desconto.");
        }
    }

    @RequestMapping(value={"/extrato"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> imprimir(@RequestBody SaidaImpressaoWrapper saida, @RequestParam Long idFechamento) throws UnicoMensagemUsuarioException {
        Remessa remessa = new FechamentoPdvRelatorio(new FechamentoPdvParam(idFechamento)).imprimir(saida.getSaida());
        return RelatorioUtil.visualizar((Remessa)remessa, (ResponseEntityService)this.responseEntityService, (SaidaRelatorio)saida.getSaidaRelatorio(), (String)"extrato-fechamento");
    }

    protected void read(FechamentoPdv fechamentoPdv, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (fechamentoPdv != null) {
            FechamentoPdvParam param = new FechamentoPdvParam();
            param.setIdFechamento(fechamentoPdv.getId());
            FechamentoPdvModel model = new GeraFechamentoPdv(param).gerar();
            fechamentoPdv.setEntrada(model.getHistorico().getTotalEntrada());
            fechamentoPdv.setSaida(model.getHistorico().getTotalSaida());
            fechamentoPdv.setDetalhes(model.getHistorico().getDetalhes());
            fechamentoPdv.setFinalizador(model.getFinalizadores().getLista());
            if (model.getHistorico().getValorFalta().compareTo(BigDecimal.ZERO) > 0) {
                fechamentoPdv.setLblHistoricoFaltaSobra("Falta de caixa");
                fechamentoPdv.setValorHistoricoFaltaSobra(model.getHistorico().getValorFalta());
            } else if (model.getHistorico().getValorSobra().compareTo(BigDecimal.ZERO) > 0) {
                fechamentoPdv.setLblHistoricoFaltaSobra("Sobra");
                fechamentoPdv.setValorHistoricoFaltaSobra(model.getHistorico().getValorSobra());
            } else {
                fechamentoPdv.setLblHistoricoFaltaSobra("");
                fechamentoPdv.setValorHistoricoFaltaSobra(BigDecimal.ZERO);
            }
            fechamentoPdv.setTotalPagamentos(model.getFinalizadores().getValorTotal());
            fechamentoPdv.setQtdPagamentos(model.getFinalizadores().getQtdTotal());
        }
    }

    protected void beforeSave(FechamentoPdv fechamentoPdv, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (fechamentoPdv.getStatus().equals((Object)StatusFechamentoPdv.FECHADO) && fechamentoPdv.getSaldoConferido().compareTo(BigDecimal.ZERO) == 0) {
            throw new UnicoMensagemUsuarioException("WPDV632", "N\u00e3o \u00e9 poss\u00edvel fazer o fechamento com o valor conferido zerado! Verifique.");
        }
    }

    protected void beforeCreate(FechamentoPdv fechamentoPdv, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        FechamentoPdv fechamentoAberto;
        if (!LicencaManager.getInstance().isEnterprise() && NumberUtil.longNullOuZero((Long)fechamentoPdv.getIdFilial())) {
            fechamentoPdv.setIdFilial(SessaoUtil.getSessao().getFilial().getId());
        }
        if ((fechamentoAberto = FechamentoPdvCommonRN.getInstance().buscarFechamentoAbertoOuPendente(fechamentoPdv.getIdFilial(), fechamentoPdv.getIdUsuario(), fechamentoPdv.getData())) != null && NumberUtil.longNullOuZero((Long)fechamentoPdv.getId())) {
            throw new UnicoMensagemUsuarioException("wPDV650", "Inclus\u00e3o n\u00e3o permitida, pois j\u00e1 existe um registro em aberto, codigo: " + fechamentoAberto.getCodigo() + ".");
        }
    }

    protected void afterSave(FechamentoPdv fechamentoPdv, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (fechamentoPdv.getStatus() == StatusFechamentoPdv.FECHADO) {
            new GeraFinanceiroFechamentoPdv(SessaoUtil.getSessao(), fechamentoPdv).gerar();
        }
    }

    protected String getCacheId() {
        return "fechamento-pdv";
    }

    protected GridBuilder<?> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "id"));
        colunas.add(new ColunaSQL("idFilial", "Filial", 0, false));
        colunas.add(new ColunaSQL("status", "status"));
        colunas.add(new ColunaSQL("data", "data_"));
        colunas.add(new ColunaSQL("pdv", "pdv_"));
        colunas.add(new ColunaSQL("codigo", "codigo_"));
        colunas.add(new ColunaSQL("nome", "usuario_", new String[]{"fk_fechamento_pdv_usuario"}));
        colunas.add(new ColunaSQL("codigo", "codigofilial", "Filial", 150, true, new String[]{"fk_fechamento_pdv_filial"}));
        colunas.add(new ColunaSQL("data", "Data", 150, true));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 150, true));
        colunas.add(new ColunaSQL("pdv", "PDV", 100, true));
        colunas.add(new ColunaSQL("idUsuario", "Operador", 10, false));
        colunas.add(new ColunaSQL("nome", "nomeUsuario", "Operador", 150, true, new String[]{"fk_fechamento_pdv_usuario"}));
        colunas.add(new ColunaSQL("codigo", "codUsuario", "codUsuario", 150, false, new String[]{"fk_fechamento_pdv_usuario"}));
        colunas.add(new ColunaSQL("status", "Status", 150, true, StatusFechamentoPdv.class));
        colunas.add(new ColunaSQL("saldoConferido", "Valor conferido", 150, true));
        colunas.add(new ColunaSQL("sobra", "Sobra de caixa", 150, true));
        colunas.add(new ColunaSQL("falta", "Falta de caixa", 150, true));
        colunas.add(new ColunaSQL("valordescontado", "Valor descontado", 150, true));
        colunas.add(new ColunaSQL("valorabonado", "Valor abonado", 150, true));
        colunas.add(new ColunaSQL("idOperacao", "idOperacaoFechamento", 0, false));
        GridBuilder grid = new GridBuilder(((FechamentoPdvCommonRN)this.rn).getTabela(), colunas, "FechamentoPdv");
        grid.addReferenciaDefault(new Referencia("idfilial", "idfilial"));
        grid.addOrdem(new Ordem("idfilial"));
        grid.addOrdem(new Ordem("data_", true));
        grid.addOrdem(new Ordem("usuario_"));
        grid.addOrdem(new Ordem("codigo_", true));
        return grid;
    }

    protected void afterLoadGrid(List<ColunaSQL> colunas, List<Object[]> dados, List<FilterField> filters, MultiValueMap<String, String> parameters) throws UnicoMensagemUsuarioException {
        dados.forEach(dado -> {
            int idxSaldoApurado;
            String status = (String)dado[this.getIndexColuna("status", colunas)];
            if (!status.equalsIgnoreCase(StatusFechamentoPdv.FECHADO.name()) && (idxSaldoApurado = this.getIndexColuna("saldoapurado", colunas)) >= 0) {
                Long id = (Long)dado[this.getIndexColuna("id", colunas)];
                FechamentoPdv fechamento = (FechamentoPdv)FechamentoPdvCommonRN.getInstance().buscarPorId(id);
                if (fechamento != null && fechamento.getUsuarioCaixa() != null) {
                    BigDecimal saldo = FechamentoPdvCommonRN.getInstance().getSaldo(fechamento);
                    dado[idxSaldoApurado] = saldo;
                }
            }
        });
    }

    private FechamentoPdv carregarFechamento(FechamentoPdv fechamentoPdv) {
        fechamentoPdv.setUsuario(fechamentoPdv.getUsuarioCaixa().getNome());
        fechamentoPdv.setStatusDescricao(fechamentoPdv.getStatus().getDescricao());
        BigDecimal saldo = fechamentoPdv.getSaldoApurado();
        if (NumberUtil.bigDecimalNullOrZero((BigDecimal)saldo)) {
            saldo = FechamentoPdvCommonRN.getInstance().getSaldo(fechamentoPdv);
            fechamentoPdv.setSaldoApurado(saldo);
        }
        return fechamentoPdv;
    }
}

