/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.financeiro.cobrancaescritural.remessa;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.uboleto.enums.BancoDisponivel;
import br.intelidata.commons.domain.pojo.Banco;
import br.intelidata.commons.domain.pojo.FinanceiroDado;
import br.intelidata.commons.domain.pojo.SimpleController;
import br.intelidata.commons.domain.pojo.financeiro.ContaCorrente;
import br.intelidata.commons.domain.pojo.financeiro.ContaCorrenteAcaoCobranca;
import br.intelidata.commons.domain.pojo.financeiro.ContaCorrenteAcaoGeracaoRemessa;
import br.intelidata.commons.domain.pojo.financeiro.ContaCorrenteCarteira;
import br.intelidata.commons.domain.pojo.financeiro.cobranca.ArquivoRemessa;
import br.intelidata.commons.domain.regranegocio.ArquivoRemessaCommonRN;
import br.intelidata.commons.domain.regranegocio.BancoCommonRN;
import br.intelidata.commons.domain.regranegocio.financeiro.cobranca.CobrancaEscrituralRN;
import br.intelidata.commons.domain.regranegocio.financeiro.cobranca.RemessaCobrancaEscritural;
import br.intelidata.commons.domain.wrapper.GeracaoRemessaWrapper;
import br.intelidata.commons.domain.wrapper.NotificacaoCompartilhamento;
import br.intelidata.commons.modulo.cobrancaescritural.regranegocio.DocumentoCobrancaRN;
import br.intelidata.commons.modulo.cobrancaescritural.relatorio.FrancesinhaRemessaRelatorio;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.financeiro.bancoonline.BancoOnlineRetornoBoleto;
import br.intelidata.commons.modulo.financeiro.regranegocio.ContaCorrenteAcaoCobrancaRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.ContaCorrenteRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.FinanceiroDadoRN;
import br.intelidata.commons.modulo.notafiscal.nfe.NotificacaoNotaFiscalCliente;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.service.StorageService;
import br.intelidata.uniplusweb.web.rest.app.crud.financeiro.IFileFinanceiro;
import br.intelidata.uniplusweb.web.rest.app.crud.financeiro.cobrancaescritural.remessa.IGeraRemessa;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/gerar-remessas"})
@SubMenuMapping(MENU="SubMenuFinanceiroGeral", ICONE="icon-descendente", NOME="Remessa para cobran\u00e7a", ROTA="/financeiros/gerar-remessas", PROGRAMA=420)
public class GeracaoRemessaSimpleController
extends SimpleController
implements IGeraRemessa,
IFileFinanceiro {
    private final ResponseEntityService responseEntityService;
    private final StorageService storageService;

    public GeracaoRemessaSimpleController(ResponseEntityService responseEntityService, StorageService storageService) {
        this.responseEntityService = responseEntityService;
        this.storageService = storageService;
    }

    @RequestMapping(value={"/gerar-remessas"}, method={RequestMethod.POST})
    @DBTransaction
    public RemessaCobrancaEscritural gerarRemessa(@RequestBody GeracaoRemessaWrapper remessaWrapper, @RequestParam(defaultValue="true", required=false) boolean validar) throws UnicoMensagemUsuarioException {
        ContaCorrente contaCorrente = (ContaCorrente)ContaCorrenteRN.getInstance().buscarPorId(remessaWrapper.getIdContaCorrenteRemessa());
        if (validar) {
            this.validarRemessa(remessaWrapper, contaCorrente, true);
        }
        remessaWrapper.setDocumentos(FinanceiroDadoRN.getInstance().atualizaDocumentosCobranca(remessaWrapper.getDocumentos()));
        ContaCorrenteCarteira contaCarteira = this.getContaCorrenteCarteira(remessaWrapper, false);
        Banco banco = (Banco)BancoCommonRN.getInstance().buscarPorId(contaCorrente.getIdbanco());
        ContaCorrenteAcaoCobranca contaAcao = (ContaCorrenteAcaoCobranca)ContaCorrenteAcaoCobrancaRN.getInstance().buscarPorId(remessaWrapper.getIdAcaoCobrancaRemessa());
        ContaCorrenteAcaoGeracaoRemessa contaAcaoRemessa = new ContaCorrenteAcaoGeracaoRemessa();
        contaAcaoRemessa.setAcaoCobranca(contaAcao);
        Sessao sessao = SessaoUtil.getSessao();
        this.gravarPreferenciaDesconto(sessao, remessaWrapper.getPercentualDescontoPagamentoAteVencimento());
        return CobrancaEscrituralRN.getInstance().gerarRemessaWeb(sessao, remessaWrapper.getDocumentos(), contaCorrente, contaCarteira, banco, false, null, contaAcaoRemessa, remessaWrapper.getTipoImpressao(), remessaWrapper.getPercentualDescontoPagamentoAteVencimento(), remessaWrapper.getInstrucaoProtesto(), remessaWrapper.getDiasInstrucao(), remessaWrapper.getObservacao());
    }

    @RequestMapping(value={"/gerar-remessas-online"}, method={RequestMethod.POST})
    @DBAutoCommit
    public RemessaCobrancaEscritural gerarRemessaOline(@RequestBody GeracaoRemessaWrapper remessaWrapper, @RequestParam(defaultValue="true", required=false) boolean validar) throws UnicoMensagemUsuarioException {
        return this.remessaOline(remessaWrapper, validar, this.carregarArquivo(this.storageService));
    }

    @RequestMapping(value={"/imprimir-boletos"}, method={RequestMethod.POST})
    @DBTransaction
    public RemessaCobrancaEscritural imprimirBoleto(@RequestBody GeracaoRemessaWrapper remessaWrapper) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        ContaCorrente contaCorrente = (ContaCorrente)ContaCorrenteRN.getInstance().buscarPorId(remessaWrapper.getIdContaCorrenteRemessa());
        this.validarRemessa(remessaWrapper, contaCorrente, false);
        Banco banco = (Banco)BancoCommonRN.getInstance().buscarPorId(contaCorrente.getIdbanco());
        boolean isAsaas = BancoDisponivel.isAsaas((String)banco.getCodigo());
        if (!ContaCorrenteRN.getInstance().isContaCorrenteImprimeBoleto(remessaWrapper.getIdContaCorrenteRemessa())) {
            throw new UnicoMensagemUsuarioException("WWW665", "Esta conta corrente n\u00e3o emite boletos.");
        }
        if (ContaCorrenteRN.getInstance().possuiIntegracaoOnline(contaCorrente)) {
            RemessaCobrancaEscritural remessaCobrancaEscritural = this.gerarRemessaOline(remessaWrapper, false);
            if (isAsaas) {
                List boletos = remessaCobrancaEscritural.getBancoOnlineRetorno().getBoletos();
                for (BancoOnlineRetornoBoleto retorno : boletos) {
                    remessaWrapper.getDocumentos().stream().filter(doc -> doc.getIdFinanceiroDado() == Long.parseLong(retorno.getIdentificacaoBoletoEmpresa()) && doc.getNossoNumero().equals(retorno.getNossoNumero())).findFirst().ifPresent(documento -> documento.setUrlDocumento(retorno.getUrlDocumento()));
                }
                ArquivoRemessaCommonRN.getInstance().gravaNossoNumero(sessao, contaCorrente, remessaWrapper.getDocumentos(), remessaWrapper.getIdContaCorrenteRemessa(), remessaWrapper.getObservacao());
                return new RemessaCobrancaEscritural(remessaCobrancaEscritural.getIdArquivoGerado(), "boletos", null, remessaWrapper.getDocumentos());
            }
        }
        ContaCorrenteCarteira contaCarteira = this.getContaCorrenteCarteira(remessaWrapper, isAsaas);
        ContaCorrenteAcaoCobranca contaAcao = (ContaCorrenteAcaoCobranca)ContaCorrenteAcaoCobrancaRN.getInstance().buscarPorId(remessaWrapper.getIdAcaoCobrancaRemessa());
        ContaCorrenteAcaoGeracaoRemessa contaAcaoRemessa = new ContaCorrenteAcaoGeracaoRemessa();
        contaAcaoRemessa.setAcaoCobranca(contaAcao);
        this.gravarPreferenciaDesconto(sessao, remessaWrapper.getPercentualDescontoPagamentoAteVencimento());
        return CobrancaEscrituralRN.getInstance().imprimirBoletosWeb(sessao, remessaWrapper.getDocumentos(), contaCorrente, contaCarteira, banco, false, remessaWrapper.getTipoSaidaBoleto(), contaAcaoRemessa, remessaWrapper.getTipoImpressao(), remessaWrapper.getPercentualDescontoPagamentoAteVencimento(), remessaWrapper.getInstrucaoProtesto(), remessaWrapper.getDiasInstrucao(), remessaWrapper.getObservacao());
    }

    @RequestMapping(value={"/impressao-francesinha"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> getFrancesinha(@RequestBody Long idArquivoRemessa) throws UnicoMensagemUsuarioException {
        ArquivoRemessa arquivoRemessa = (ArquivoRemessa)ArquivoRemessaCommonRN.getInstance().buscarPorId(idArquivoRemessa);
        if (arquivoRemessa != null) {
            arquivoRemessa.setDocumentosCobranca(DocumentoCobrancaRN.getInstace().buscarPorArquivoRemessa(idArquivoRemessa));
            return this.responseEntityService.createPDFResponse(FrancesinhaRemessaRelatorio.getInstance().getRelatorio(Collections.singletonList(arquivoRemessa)).getMalote().extrai("pdf"), "francesinha");
        }
        throw new UnicoMensagemUsuarioException("CBE190", "Remessa n\u00e3o encontrada");
    }

    @RequestMapping(value={"/preparar-compartilhamento"}, method={RequestMethod.POST})
    @DBAutoCommit
    public NotificacaoCompartilhamento prepararCompartilhamento(@RequestBody NotificacaoCompartilhamento notificacao) throws UnicoMensagemUsuarioException {
        FinanceiroDado financeiro = (FinanceiroDado)FinanceiroDadoRN.getInstance().buscarPorId((Long)notificacao.getIdsDocumentos().get(0));
        if (financeiro == null) {
            throw new UnicoMensagemUsuarioException("WWW749", "Documento n\u00e3o encontrado.");
        }
        Map mapCliente = EntidadeRN.getInstance().getDadosNotificacaoWeb(Collections.singletonList(financeiro.getIdEntidade()), notificacao.getTipo());
        if (!mapCliente.isEmpty()) {
            NotificacaoNotaFiscalCliente notificacaoCliente = (NotificacaoNotaFiscalCliente)mapCliente.get(financeiro.getIdEntidade());
            notificacao.setEmail(notificacaoCliente.getEmailEnvio());
            notificacao.setCopiaPara(notificacaoCliente.getEmailCC());
            notificacao.setCelular(notificacaoCliente.getFoneEnvio());
            notificacao.setAssunto("Boletos - " + notificacaoCliente.getNomeCliente());
        }
        return notificacao;
    }
}

