/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.financeiro.eventofinanceiro;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.EventoFinanceiro;
import br.intelidata.commons.domain.pojo.FinanceiroDado;
import br.intelidata.commons.domain.pojo.Operacao;
import br.intelidata.commons.domain.pojo.enuns.TipoAcaoFinanceiro;
import br.intelidata.commons.domain.pojo.enuns.TipoEventoFinanceiro;
import br.intelidata.commons.domain.pojo.enuns.TipoPessoa;
import br.intelidata.commons.domain.pojo.financeiro.ContaCorrente;
import br.intelidata.commons.domain.pojo.financeiro.ContaCorrenteLancamento;
import br.intelidata.commons.domain.pojo.financeiro.TipoFinanceiro;
import br.intelidata.commons.domain.regranegocio.OperacaoCommonRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.ContaCorrenteLancamentoRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.ContaCorrenteRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.EventoFinanceiroRN;
import br.intelidata.commons.modulo.pdv.regranegocio.OperacaoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.financeiro.eventofinanceiro.EventoFinanceiroWrapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/eventos-financeiros"})
public class EventoFinanceiroCrudController
extends SimpleCrudController<EventoFinanceiro, EventoFinanceiroRN> {
    @RequestMapping(value={"{id}"}, method={RequestMethod.GET})
    @DBAutoCommit
    public EventoFinanceiro read(@PathVariable Long id) throws UnicoMensagemUsuarioException {
        return EventoFinanceiroRN.getInstance().buscarPorId(id);
    }

    @RequestMapping(value={"/buscar-documentos"})
    @DBAutoCommit
    public List<FinanceiroDado> buscarDocumentos(@RequestParam Long idEvento) throws UnicoMensagemUsuarioException {
        EventoFinanceiro eventoFinanceiro = EventoFinanceiroRN.getInstance().buscarPorId(idEvento);
        if (eventoFinanceiro != null) {
            if (eventoFinanceiro.getOrigem() == 1 && eventoFinanceiro.getTipoevento().equals(TipoEventoFinanceiro.BAIXA.getId())) {
                String msg = "Estorno n\u00e3o permitido.";
                Operacao operacao = (Operacao)OperacaoRN.getInstance().buscarPorId(eventoFinanceiro.getIdOrigem());
                if (operacao != null) {
                    msg = "Para estornar o documento PDV: " + operacao.getPdv() + ", ";
                    msg = operacao.isNfce() ? (operacao.getModeloNfce().equals("65") ? msg + "N\u00ba NFCe: " + operacao.getNumeroNfce() + ", acessar PDV > Fiscal > Consulta NFC-e" : msg + "N\u00ba SAT: " + operacao.getNumeroNfce() + ", acessar PDV > Fiscal > Consulta CF-e") : msg + "COO: " + operacao.getCoo() + ", acessar PDV > Geral > Opera\u00e7\u00f5es realizadas";
                }
                throw new UnicoMensagemUsuarioException("WFIN97", "Estorno n\u00e3o permitido. " + msg);
            }
            return eventoFinanceiro.getListaDocumentos();
        }
        return Collections.emptyList();
    }

    @RequestMapping(value={"/buscar-dados-forma-pagamento"})
    @DBAutoCommit
    public List<EventoFinanceiroWrapper> buscarDadosFormaPagamento(@RequestParam Long idEvento, @RequestParam TipoFinanceiro tipoFinanceiroOrigemChamada) throws UnicoMensagemUsuarioException {
        EventoFinanceiro evento = EventoFinanceiroRN.getInstance().buscarPorId(idEvento);
        if (evento == null) {
            throw new UnicoMensagemUsuarioException("FIN302", "Financeiros n\u00e3o encontrados");
        }
        ArrayList<EventoFinanceiroWrapper> eventos = new ArrayList<EventoFinanceiroWrapper>();
        List formasPagamento = evento.getListaDestinos();
        if (this.carregarPagamentosPdv(evento)) {
            formasPagamento = OperacaoCommonRN.getInstance().buscarFormasPagamentoPdv(evento.getIdOrigem());
            for (FinanceiroDado fD : formasPagamento) {
                if (Util.stringNullOrEmpty((String)fD.getDocumento())) continue;
                String doc = evento.getListaDestinos().stream().filter(dest -> dest.getDocumento() != null && dest.getDocumento().contains(fD.getDocumento())).map(FinanceiroDado::getDocumento).findFirst().orElse("");
                fD.setDocumento(Util.stringNullOrEmpty((String)doc) ? fD.getDocumento() : doc);
            }
        }
        if (evento.getListaDestinos() != null) {
            for (FinanceiroDado fd : formasPagamento) {
                BigDecimal valor;
                TipoAcaoFinanceiro acaoFinanceiro;
                if (fd.getTipo() != null && !fd.getTipo().equals(evento.getTipo())) continue;
                TipoAcaoFinanceiro tipoAcaoFinanceiro = acaoFinanceiro = fd.getTipoDocumento() != null ? fd.getTipoDocumento().getAcao() : null;
                if (TipoAcaoFinanceiro.TROCA_ENDOSSO.equals((Object)acaoFinanceiro)) {
                    for (FinanceiroDado documentoEndossado : evento.getListaDocumentos()) {
                        if (documentoEndossado.getTipo().equals(tipoFinanceiroOrigemChamada.getId())) continue;
                        Entidade cliente = (Entidade)EntidadeRN.getInstance().buscarPorId(documentoEndossado.getIdEntidade());
                        EventoFinanceiroWrapper eventoFinanceiroWrapper = new EventoFinanceiroWrapper();
                        if (cliente != null) {
                            eventoFinanceiroWrapper.setNomeCliente(TipoPessoa.JURIDICA.equals((Object)cliente.getTipoPessoa()) ? cliente.getRazaoSocial() : cliente.getNome());
                        }
                        if (fd.getTipoDocumento() != null && !NumberUtil.longNullOuZero((Long)fd.getTipoDocumento().getId())) {
                            eventoFinanceiroWrapper.setIdTipoDocumento(fd.getTipoDocumento().getId());
                            eventoFinanceiroWrapper.setTipoDocumento(fd.getTipoDocumento().getDescricao());
                        }
                        eventoFinanceiroWrapper.setDocumento(documentoEndossado.getDocumento());
                        eventoFinanceiroWrapper.setEmissao(documentoEndossado.getRegistro());
                        eventoFinanceiroWrapper.setVencimento(documentoEndossado.getVencimento());
                        eventoFinanceiroWrapper.setValor(Util.bigDecimalNullOrZero((BigDecimal)documentoEndossado.getValorPago()) ? documentoEndossado.getValor().setScale(2, RoundingMode.HALF_EVEN) : documentoEndossado.getValorPago().setScale(2, RoundingMode.HALF_EVEN));
                        eventos.add(eventoFinanceiroWrapper);
                    }
                    continue;
                }
                Entidade cliente = (Entidade)EntidadeRN.getInstance().buscarPorId(fd.getIdEntidade());
                boolean inclusao = false;
                EventoFinanceiroWrapper eventoFinanceiroWrapper = this.buscaEventoExistentePorTipoDocumento(eventos, fd.getTipoDocumento() != null ? fd.getTipoDocumento().getId() : null, fd.getDocumento(), fd.getEmissao(), fd.getVencimento());
                if (eventoFinanceiroWrapper == null) {
                    ContaCorrente conta;
                    ContaCorrenteLancamento contaCorrenteLancamento;
                    inclusao = true;
                    eventoFinanceiroWrapper = new EventoFinanceiroWrapper();
                    eventoFinanceiroWrapper.setNomeCliente(cliente != null ? cliente.getRazaoSocial() : "");
                    if (fd.getTipoDocumento() != null && !NumberUtil.longNullOuZero((Long)fd.getTipoDocumento().getId())) {
                        eventoFinanceiroWrapper.setIdTipoDocumento(fd.getTipoDocumento().getId());
                        eventoFinanceiroWrapper.setTipoDocumento(fd.getTipoDocumento().getDescricao());
                    }
                    eventoFinanceiroWrapper.setDocumento(fd.getDocumento());
                    eventoFinanceiroWrapper.setEmissao(fd.getRegistro());
                    eventoFinanceiroWrapper.setVencimento(fd.getVencimento());
                    Long idContaCorrente = fd.getIdContaCorrente();
                    if (!Util.longNullOuZero((Long)fd.getIdContaCorrenteLancamento()) && (contaCorrenteLancamento = (ContaCorrenteLancamento)ContaCorrenteLancamentoRN.getInstance().buscarPorId(fd.getIdContaCorrenteLancamento())) != null) {
                        idContaCorrente = contaCorrenteLancamento.getIdcontacorrente();
                    }
                    if (!Util.longNullOuZero((Long)idContaCorrente) && (conta = (ContaCorrente)ContaCorrenteRN.getInstance().buscarPorId(idContaCorrente)) != null) {
                        eventoFinanceiroWrapper.setConta(conta.getDescricao());
                    }
                }
                if ((valor = eventoFinanceiroWrapper.getValor()) == null) {
                    valor = BigDecimal.ZERO;
                }
                valor = valor.add(fd.getValor() != null && fd.getValor().compareTo(BigDecimal.ZERO) > 0 ? fd.getValor().setScale(2, RoundingMode.HALF_EVEN) : fd.getValorPago().setScale(2, RoundingMode.HALF_EVEN));
                eventoFinanceiroWrapper.setValor(valor);
                if (!inclusao) continue;
                eventos.add(eventoFinanceiroWrapper);
            }
        }
        return eventos;
    }

    @RequestMapping(value={"/estornar-documentos-baixados"}, method={RequestMethod.POST})
    @DBTransaction
    public boolean estornaDocumentosBaixados(@RequestBody EventoFinanceiroWrapper eventoFinanceiroWrapper) throws UnicoMensagemUsuarioException {
        EventoFinanceiroRN.getInstance().estornaDocumentosBaixadosEvento(SessaoUtil.getSessao(), eventoFinanceiroWrapper.getIdEvento(), eventoFinanceiroWrapper.getDocumentos());
        return true;
    }

    private EventoFinanceiroWrapper buscaEventoExistentePorTipoDocumento(List<EventoFinanceiroWrapper> dados, Long idTipoDocumento, String documento, LocalDate dataEmissao, LocalDate dataVencimento) {
        EventoFinanceiroWrapper evento = null;
        if (dados != null) {
            for (EventoFinanceiroWrapper eventoFinanceiroWrapper : dados) {
                if ((documento != null || eventoFinanceiroWrapper.getDocumento() != null) && (documento == null || !documento.equals(eventoFinanceiroWrapper.getDocumento())) || !Util.equals((Object)dataEmissao, (Object)eventoFinanceiroWrapper.getEmissao()) || !Util.equals((Object)dataVencimento, (Object)eventoFinanceiroWrapper.getVencimento()) || !idTipoDocumento.equals(eventoFinanceiroWrapper.getIdTipoDocumento())) continue;
                evento = eventoFinanceiroWrapper;
                break;
            }
        }
        return evento;
    }

    private boolean carregarPagamentosPdv(EventoFinanceiro evento) {
        return evento.getOrigem() == 1 && evento.getTipoevento().equals(TipoEventoFinanceiro.BAIXA.getId());
    }
}

