/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.geracaosped;

import br.intelidata.api.batch.AbstractJob;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.JSONUtil;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.ConfiguracaoCampos;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.fiscal.InventarioSped;
import br.intelidata.commons.modulo.cadastros.regranegocio.ConfiguracaoCamposRN;
import br.intelidata.commons.modulo.custo.regranegocio.CustoMedioDiarioRN;
import br.intelidata.commons.sped.fiscal.TipoGeracaoInventario;
import br.intelidata.commons.sped.regranegocio.InventarioSpedRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ICreateTask;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.geracaosped.GeradorSpedFiscalWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.geracaosped.JobGeracaoSped;
import java.time.temporal.Temporal;
import java.util.Collections;
import java.util.List;
import org.json.JSONObject;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public abstract class SpedJobsCrudController
extends SimpleCrudController<GeradorSpedFiscalWrapper, ConfiguracaoCamposRN>
implements ICreateTask {
    private final TaskManager taskManager;

    public SpedJobsCrudController(TaskManager taskManager) {
        this.taskManager = taskManager;
    }

    public Class<? extends AbstractJob> job() {
        return JobGeracaoSped.class;
    }

    public TaskManager taskManager() {
        return this.taskManager;
    }

    @DBAutoCommit
    public GeradorSpedFiscalWrapper get(Long parentId) throws UnicoMensagemUsuarioException {
        ConfiguracaoCampos configuracaoCampos = ConfiguracaoCamposRN.getInstance().buscarPorIdFilialTabela(SessaoUtil.getSessao().getIdFilial(), this.nomeTabela());
        if (configuracaoCampos != null) {
            configuracaoCampos.getCamposSerializados().remove("filial");
            GeradorSpedFiscalWrapper geradorSpedFiscalWrapper = (GeradorSpedFiscalWrapper)JSONUtil.getObject((JSONObject)configuracaoCampos.getCamposSerializados(), GeradorSpedFiscalWrapper.class);
            geradorSpedFiscalWrapper.setDataInicial(DataHoraFactory.getLocalDateInicioMes());
            geradorSpedFiscalWrapper.setDataFinal(DataHoraFactory.getLocalDateFimMes());
            geradorSpedFiscalWrapper.setTiposProduto(Collections.emptyList());
            return geradorSpedFiscalWrapper;
        }
        GeradorSpedFiscalWrapper geradorSpedFiscalWrapper = new GeradorSpedFiscalWrapper();
        geradorSpedFiscalWrapper.setDataInicial(DataHoraFactory.getLocalDateInicioMes());
        geradorSpedFiscalWrapper.setDataFinal(DataHoraFactory.getLocalDateFimMes());
        return geradorSpedFiscalWrapper;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/create"})
    @DBTransaction
    public Long createSped(@RequestBody GeradorSpedFiscalWrapper geracaoSped) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        this.validarDados(geracaoSped);
        ConfiguracaoCamposRN.getInstance().gravarConfiguracaoPorFilial(sessao, (Object)geracaoSped, this.nomeTabela());
        this.createTask((Object)geracaoSped, this.resumoFiltros(geracaoSped));
        return 0L;
    }

    private void validarDados(GeradorSpedFiscalWrapper geracaoSped) throws UnicoMensagemUsuarioException {
        if (geracaoSped != null) {
            List inventarios;
            if (geracaoSped.getDataInicial() == null) {
                throw new UnicoMensagemUsuarioException("COM236606", "Informe a data inicial.");
            }
            if (geracaoSped.getDataFinal() == null) {
                throw new UnicoMensagemUsuarioException("COM236607", "Informe a data final.");
            }
            if (geracaoSped.getDataInicial().getYear() != geracaoSped.getDataFinal().getYear() || geracaoSped.getDataInicial().getMonthValue() != geracaoSped.getDataFinal().getMonthValue()) {
                throw new UnicoMensagemUsuarioException("WSPEDF248", "A data inicial e final devem estar no mesmo per\u00edodo.");
            }
            if (geracaoSped.isGerarRegistro1601() && Util.listNullOrEmpty((List)geracaoSped.getTipo1601List())) {
                throw new UnicoMensagemUsuarioException("WCOM23669826", "Nenhum instrumento do Registro 1601 foi selecionado! Verifique.");
            }
            List<Filial> filiais = Collections.singletonList(SessaoUtil.getSessao().getFilial());
            if (geracaoSped.getTipoGeracaoInventario().equals((Object)TipoGeracaoInventario.FINAL_PERIODO)) {
                CustoMedioDiarioRN.getInstance().validarCustoMedio(geracaoSped.getTipoCalculoCusto(), geracaoSped.getDataInventario(), geracaoSped.getDataInventario(), filiais);
            } else if (geracaoSped.getTipoGeracaoInventario().equals((Object)TipoGeracaoInventario.CADASTRO) && !Util.listNullOrEmpty((List)(inventarios = InventarioSpedRN.getInstance().buscaListaPorPeriodo(geracaoSped.getDataInicial(), SessaoUtil.getSessao().getFilial().getId(), false)))) {
                for (InventarioSped inventarioSped : inventarios) {
                    CustoMedioDiarioRN.getInstance().validarCustoMedio(inventarioSped.getTipoCalculo(), inventarioSped.getDataInventario(), inventarioSped.getDataInventario(), filiais);
                }
            }
        }
    }

    private String resumoFiltros(GeradorSpedFiscalWrapper parametros) {
        return "Periodo: " + StringUtil.formataDataHora((Temporal)parametros.getDataInicial(), (String)"dd/MM/yy") + " \u00e0 " + StringUtil.formataDataHora((Temporal)parametros.getDataFinal(), (String)"dd/MM/yy");
    }

    protected abstract String nomeTabela();
}

