/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.localestoque;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.LocalEstoque;
import br.intelidata.commons.domain.pojo.Usuario;
import br.intelidata.commons.domain.pojo.enuns.EEventos;
import br.intelidata.commons.domain.pojo.enuns.TipoLocalEstoque;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.EntidadeCommonRN;
import br.intelidata.commons.domain.regranegocio.FilialCommonRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.PerfilPermissaoRN;
import br.intelidata.commons.modulo.estoque.regranegocio.LocalEstoqueRN;
import br.intelidata.commons.sped.fiscal.PosseItem;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/locais-estoques"})
@SubMenuMapping(MENU="SubMenuEstoqueGeral", NOME="Locais de estoque", ROTA="/estoques/locais-estoques", PROGRAMA=66, ICONE="icon-local-estoque")
public class LocalEstoqueCrudController
extends CrudController<LocalEstoque, LocalEstoqueRN> {
    @Autowired
    public LocalEstoqueCrudController() {
        super((AbstractRegraNegocio)LocalEstoqueRN.getInstance(), LocalEstoque::new, true, true);
    }

    @RequestMapping(value={"/local-estoque-filtrar-filial"})
    @DBAutoCommit
    public List<LocalEstoque> filtrarPorFilial(@RequestParam Long idFilial, @RequestParam(required=false) Long idEntidade, @RequestParam(defaultValue="false") boolean mostrarInativos) throws UnicoMensagemUsuarioException {
        if (NumberUtil.longNullOuZero((Long)idFilial) && NumberUtil.longNullOuZero((Long)idEntidade)) {
            throw new UnicoMensagemUsuarioException("WWW192", "Por favor informe a filial para a busca de local de estoque");
        }
        if (NumberUtil.longNullOuZero((Long)idFilial) && !NumberUtil.longNullOuZero((Long)idEntidade)) {
            Entidade entidade = (Entidade)EntidadeCommonRN.getInstance().buscarPorId(idEntidade);
            if (entidade == null || !entidade.isPertenceFilial()) {
                return Collections.emptyList();
            }
            Filial filial = FilialCommonRN.getInstance().buscarFilialPorEntidade(idEntidade);
            if (filial != null) {
                idFilial = filial.getId();
            } else {
                return Collections.emptyList();
            }
        }
        return LocalEstoqueRN.getInstance().getComboPorIdFilialWeb(SessaoUtil.getSessao(), idFilial, mostrarInativos);
    }

    @RequestMapping(value={"/local-estoque-filtrar-filiais"})
    @DBAutoCommit
    public List<LocalEstoque> buscarListaPorFiliais(@RequestParam(required=false) List<Long> idFiliais, @RequestParam(defaultValue="false") boolean mostrarInativos) {
        Sessao sessao = SessaoUtil.getSessao();
        if (ListMapUtil.listNullOrEmpty(idFiliais)) {
            idFiliais = Collections.singletonList(sessao.getIdFilial());
        }
        return LocalEstoqueRN.getInstance().getComboPorFiliaisWeb(sessao, idFiliais, mostrarInativos);
    }

    @RequestMapping(value={"/local-estoque-filial-logada"})
    @DBAutoCommit
    public List<LocalEstoque> filtrarPorFilialLogada() {
        return LocalEstoqueRN.getInstance().getComboPorIdFilialWeb(SessaoUtil.getSessao(), SessaoUtil.getSessao().getIdFilial(), false);
    }

    protected void beforeSave(LocalEstoque localEstoque, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        localEstoque.setIdFilial(SessaoUtil.getSessao().getIdFilial());
    }

    protected GridBuilder<LocalEstoqueRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 0, true));
        colunas.add(new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 0, true));
        colunas.add(new ColunaSQL("tipo", "Tipo", 0, true, TipoLocalEstoque.class));
        colunas.add(new ColunaSQL("posse", "Posse", 0, true, PosseItem.class));
        GridBuilder grid = new GridBuilder(LocalEstoqueRN.getInstance().getTabela(), colunas);
        grid.addReferenciaDefault(new Referencia("idfilial"));
        grid.addCodicaoDefault(new Condicao("idfilial", Operador.IGUAL, SessaoUtil.getSessao().getIdFilial()));
        Usuario usuario = SessaoUtil.getSessao().getUsuario();
        Condicao condicao = PerfilPermissaoRN.getInstance().perfilPermissaoFiltro(usuario.getIdPerfil(), EEventos.LOCAL_ESTOQUE, "id", usuario.isAdministrador());
        if (condicao != null) {
            grid.addCondicao(condicao);
        }
        return grid;
    }

    protected String getCacheId() {
        return "locais-estoques".concat("_FILIAL_").concat(SessaoUtil.getSessao().getIdFilial().toString()).concat("_ADM_").concat(Boolean.toString(SessaoUtil.getSessao().getUsuario().isAdministrador()));
    }

    @RequestMapping(value={"/lista"})
    @DBTransaction
    public List<LocalEstoque> buscarLista() {
        return LocalEstoqueRN.getInstance().buscarLista();
    }
}

