/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.notafiscal;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.CacheSistema;
import br.intelidata.commons.domain.pojo.Custo;
import br.intelidata.commons.domain.pojo.NaturezaOperacao;
import br.intelidata.commons.domain.pojo.ParametrosNotaFiscalInterface;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.compras.PedidoCompraItem;
import br.intelidata.commons.domain.pojo.enuns.StatusPrecoCompra;
import br.intelidata.commons.domain.pojo.enuns.TipoEmissaoNotaFiscal;
import br.intelidata.commons.domain.pojo.enuns.TipoNotaFiscal;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscalItem;
import br.intelidata.commons.domain.regranegocio.notafiscal.UtilNotaFiscal;
import br.intelidata.commons.domain.wrapper.ImpostoWrapper;
import br.intelidata.commons.modulo.compras.regranegocio.PedidoCompraItemRN;
import br.intelidata.commons.modulo.custo.regranegocio.CustoRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NaturezaOperacaoRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalItemRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.uniplusweb.core.coreinterfaces.TratamentoDadoImpostoInterface;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import br.intelidata.uniplusweb.web.rest.app.calculoimposto.CalculoImpostoService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="tratar-dados-nf")
public class NotaFiscalTratamentoImposto
implements TratamentoDadoImpostoInterface<NotaFiscalItem> {
    private final CalculoImpostoService<NotaFiscalItem> calculoImpostoService;
    private final FuncionalidadeService funcionalidadeService;

    @Autowired
    public NotaFiscalTratamentoImposto(CalculoImpostoService<NotaFiscalItem> calculoImpostoService, FuncionalidadeService funcionalidadeService) {
        this.calculoImpostoService = calculoImpostoService;
        this.funcionalidadeService = funcionalidadeService;
    }

    public void tratarObjeto(ImpostoWrapper<NotaFiscalItem> impostoWrapper) throws UnicoMensagemUsuarioException {
        Produto produto;
        Sessao sessao = SessaoUtil.getSessao();
        NotaFiscalItem item = (NotaFiscalItem)impostoWrapper.getItem();
        NaturezaOperacao naturezaOperacao = NaturezaOperacaoRN.getInstance().buscarPorId(item.getIdCfop());
        if (naturezaOperacao == null) {
            throw new UnicoMensagemUsuarioException("WWW181", "Natureza de opera\u00e7\u00e3o n\u00e3o encontrada");
        }
        boolean operacaoFiscal = this.calculoImpostoService.utilizaOperacaoFiscal(TipoEmissaoNotaFiscal.PROPRIA.equals((Object)impostoWrapper.getTipoEmissao()), sessao.getIdFilial());
        ParametrosNotaFiscalInterface parametrosNotaFiscalInterface = this.calculoImpostoService.getParametrosNotaFiscalInterface(impostoWrapper.getIdParametrosNF(), operacaoFiscal);
        boolean operacaoPodeExigirUnidadeTributavel = UtilNotaFiscal.isCfopExigeUnidadeMedidaTributavel((ParametrosNotaFiscalInterface)parametrosNotaFiscalInterface, (NaturezaOperacao)naturezaOperacao, (Produto)(produto = (Produto)ProdutoRN.getInstance().buscarPorId(item.getIdProduto())));
        if (operacaoPodeExigirUnidadeTributavel) {
            item.setQuantidadeTributavel(NotaFiscalItemRN.getInstance().calcularQuantidadeTributavel(item.getQuantidade(), item.getIdEmbalagemTributavel(), item.getIdEmbalagem()));
        } else {
            item.setQuantidadeTributavel(BigDecimal.ZERO);
        }
        item.setPermiteItemSemValor(naturezaOperacao.isPermiteNotaSemValor());
        PedidoCompraItem pedidoCompraItem = PedidoCompraItemRN.getInstance().buscaPorCodigoPedidoCompraNumeroItem(sessao, impostoWrapper.getIdEntidade(), item.getNumeroPedidoCompra(), item.getNumeroItemPedidoCompra(), false);
        if (pedidoCompraItem != null) {
            item.setIdPedidoCompraItem(pedidoCompraItem.getId());
        }
        item.setNaoConsiderarValorTotalNota(naturezaOperacao.isNaoConsiderarVlNotaFiscalItem());
        item.setCfop(naturezaOperacao.getCodigo());
        if (this.funcionalidadeService.isAtiva(Funcionalidade.TRIBUTACAO_ESPECIAL)) {
            item.setTributacaoEspecial(item.getCfop() != null && item.getCfop().startsWith("*") && !PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 372) ? item.getCfop() : null);
        }
        if (impostoWrapper.getTipoNotaFiscal().equals((Object)TipoNotaFiscal.ENTRADA)) {
            StatusPrecoCompra statusPrecoCompra = StatusPrecoCompra.SEM_ALTERACAO;
            if (!this.calculoImpostoService.isNotaCreditoOuTransferenciaCreditoIcms(parametrosNotaFiscalInterface)) {
                Custo custo = CustoRN.getInstance().getCustoAtualProdutoFilial(sessao.getFilial(), item.getIdProduto());
                BigDecimal precoUnitario = item.getPrecoUnitario().divide(item.getEmbalagem(), 6, RoundingMode.HALF_EVEN).setScale((int)CacheSistema.getInstance().getCasasDecimaisCustoProduto(item.getIdProduto()), RoundingMode.HALF_EVEN);
                if (custo.getPrecoUltimaCompra().compareTo(precoUnitario) != 0) {
                    statusPrecoCompra = StatusPrecoCompra.PRECO_ALTERADO;
                }
            }
            item.setStatusPrecoItem(statusPrecoCompra);
        }
    }
}

