/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.transmissao.documentodestinado.cancelado;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.DocumentoDestinado;
import br.intelidata.commons.domain.pojo.enuns.TipoAcaoExcluir;
import br.intelidata.commons.domain.pojo.enuns.TipoEmissaoNotaFiscal;
import br.intelidata.commons.domain.pojo.enuns.TipoLogAcaoUsuario;
import br.intelidata.commons.domain.pojo.enuns.TipoNotaFiscal;
import br.intelidata.commons.domain.pojo.enuns.TipoRegistroConsultaDocumentoDestinatario;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscal;
import br.intelidata.commons.modulo.notafiscal.regranegocio.DocumentoDestinadoRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.LogAcaoUsuarioRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalRN;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.transmissao.documentodestinado.DocumentoDestinadoCrudController;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/documentos-destinados-cancelados"})
public class DocumentoDestinadoCanceladoCrudController
extends DocumentoDestinadoCrudController {
    public DocumentoDestinadoCanceladoCrudController() {
        super(TipoRegistroConsultaDocumentoDestinatario.CANCELADO);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/cancelar"})
    @DBTransaction
    public void cancelarNfeNoSistema(@RequestParam Long idDocumento) throws UnicoMensagemUsuarioException {
        DocumentoDestinado doc = (DocumentoDestinado)DocumentoDestinadoRN.getInstance().buscarPorId(idDocumento);
        if (doc == null) throw new UnicoMensagemUsuarioException("WWW276", "Documento n\u00e3o encontrado.");
        NotaFiscal nf = NotaFiscalRN.getInstance().buscarPorChaveNFe(doc.getChaveAcesso());
        if (nf == null) throw new UnicoMensagemUsuarioException("WNTF370", "N\u00e3o foi encontrado nenhuma nota de entrada com a chave de acesso " + doc.getChaveAcesso());
        if (!nf.getTipoDocumento().equals((Object)TipoNotaFiscal.ENTRADA) || !nf.getTipoEmissao().equals((Object)TipoEmissaoNotaFiscal.TERCEIROS)) {
            throw new UnicoMensagemUsuarioException("WNTF369", "Nota fiscal encontrada n\u00e3o \u00e9 uma nota de entrada com emiss\u00e3o desmarcado. Por favor verifique.");
        }
        NotaFiscalRN.getInstance().cancelaNotaFiscal(SessaoUtil.getSessao(), nf.getId(), TipoAcaoExcluir.EXCLUIR, true);
        LogAcaoUsuarioRN.getInstance().incluirAcaoUsuarioCorrente(SessaoUtil.getSessao(), DocumentoDestinadoRN.getInstance().getTabela(), doc.getId(), "Excluiu nota " + doc.getChaveAcesso(), TipoLogAcaoUsuario.EXCLUIU_NFE_POR_DOCUMENTO_DESTINATARIO);
    }

    protected String getCacheId() {
        return "documentos-destinados-cancelados";
    }
}

