/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.outroslancamentossped;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.LicencaManager;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.fiscal.LancamentoSped;
import br.intelidata.commons.domain.pojo.fiscal.TipoRegistroSped;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.sped.fiscal.ObrigacaoIcmsRecolher;
import br.intelidata.commons.sped.regranegocio.LancamentoSpedRN;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.Optional;

public abstract class OutrosLancamentosSpedCrudController
extends CrudController<LancamentoSped, LancamentoSpedRN> {
    private boolean isEmpresa;

    public OutrosLancamentosSpedCrudController(boolean isEmpresa) {
        super((AbstractRegraNegocio)LancamentoSpedRN.getInstance(), LancamentoSped::new, true, true);
        this.isEmpresa = isEmpresa;
    }

    protected String getCacheId() {
        return "outros-lancamentos-sped".concat(this.isEmpresa ? "-empresa" : "-filial");
    }

    protected GridBuilder<LancamentoSpedRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("periodo", "Per\u00edodo", 0, true));
        colunas.add(new ColunaSQL("tipoRegistroSped", "Registro", 0, true));
        GridBuilder grid = new GridBuilder(LancamentoSpedRN.getInstance().getTabela(), colunas);
        grid.addOrdemDefault(new Ordem("periodo", true));
        grid.addReferenciaDefault(new Referencia("registroglobal", "registroglobal"));
        if (this.isEmpresa) {
            grid.addCodicaoDefault(new Condicao("registroglobal", Operador.IGUAL, 1));
            if (LicencaManager.getInstance().isEnterprise()) {
                grid.addReferenciaDefault(new Referencia("idempresa", "idempresa"));
                grid.addCodicaoDefault(new Condicao("idempresa", Operador.IGUAL, SessaoUtil.getSessao().getFilial().getIdEmpresa()));
            }
        } else {
            grid.addCodicaoDefault(new Condicao("registroglobal", Operador.IGUAL, 0));
            grid.addReferenciaDefault(new Referencia("idfilial", "idfilial"));
            grid.addCodicaoDefault(new Condicao("idfilial", Operador.IGUAL, SessaoUtil.getSessao().getIdFilial()));
        }
        return grid;
    }

    protected void beforeSave(LancamentoSped lancamentoSped, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        lancamentoSped.setIdFilial(SessaoUtil.getSessao().getIdFilial());
        lancamentoSped.setIdEmpresa(SessaoUtil.getSessao().getFilial().getIdEmpresa());
        lancamentoSped.setRegistroGlobal(lancamentoSped.getTipoRegistroSped().equals((Object)TipoRegistroSped.M211_M611));
        if (lancamentoSped.getTipoRegistroSped().equals((Object)TipoRegistroSped.E250)) {
            for (ObrigacaoIcmsRecolher obrigacao : ObrigacaoIcmsRecolher.values()) {
                if (!obrigacao.name().equalsIgnoreCase(lancamentoSped.getTexto3())) continue;
                lancamentoSped.setTexto3(obrigacao.getId());
                break;
            }
        }
        super.beforeSave((AbstractPojo)lancamentoSped, parentId);
    }

    protected void beforeRead(LancamentoSped lancamentoSped, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (lancamentoSped.getTipoRegistroSped().equals((Object)TipoRegistroSped.E250) && !Util.stringNullOrEmpty((String)lancamentoSped.getTexto3())) {
            lancamentoSped.setTexto3(((ObrigacaoIcmsRecolher)EnumUtils.getPorId(ObrigacaoIcmsRecolher.class, (Object)lancamentoSped.getTexto3())).name());
        }
        super.beforeRead((AbstractPojo)lancamentoSped, modo, parentId);
    }
}

