/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.parametrosnfcesat;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.NaturezaOperacao;
import br.intelidata.commons.domain.pojo.ParametroNfceSat;
import br.intelidata.commons.domain.pojo.enuns.FormaEmissaoNfe;
import br.intelidata.commons.domain.pojo.enuns.TipoImagem;
import br.intelidata.commons.domain.pojo.enuns.ValidacaoCfopNfce;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NaturezaOperacaoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import unipaf.servidor.nfce.StatusPdvFilialHelper;

@RestController
@RequestMapping(value={"/api/parametros-nfce-sat"})
@SubMenuMapping(MENU="SubMenuPdvAuxiliar", NOME="Par\u00e2metros da NFC-e / SAT", ROTA="/pdvs/parametros-nfce-sat", PROGRAMA=1000016)
public class ParametroNfceSatCrudController
extends SimpleCrudController<ParametroNfceSat, FilialRN> {
    public ParametroNfceSatCrudController() {
        super((AbstractRegraNegocio)FilialRN.getInstance(), TipoArquivoArmazenado.Danfe);
    }

    @DBAutoCommit
    public ParametroNfceSat get(Long parentId) {
        ParametroNfceSat parametro = ((Filial)FilialRN.getInstance().buscarPorIdLazy(SessaoUtil.getSessao().getIdFilial())).getParametroNfceSat();
        if (!StringUtil.stringNullOrEmpty((String)parametro.getLogoTipoComprovante())) {
            String url = this.saveFile.publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Danfe, TipoImagem.Pequena, parametro.getLogoTipoComprovante(), parametro.getImagemNfce());
            parametro.setLogoTipoComprovante(url);
        }
        return parametro;
    }

    @RequestMapping(method={RequestMethod.POST})
    @DBTransaction
    public Long create(@RequestBody ParametroNfceSat entity) throws UnicoMensagemUsuarioException {
        Filial filial = SessaoUtil.getSessao().getFilial();
        entity.setNumeroTokenNfce(StringUtil.zeroEsquerda((String)entity.getNumeroTokenNfce(), (int)6));
        ParametroNfceSat parametrosOriginais = filial.getParametroNfceSat();
        if (parametrosOriginais != null && !StringUtil.stringNullOrEmpty((String)parametrosOriginais.getLogoTipoComprovante())) {
            String arquivoRelativo = this.saveFile.publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Danfe, TipoImagem.Pequena, parametrosOriginais.getLogoTipoComprovante());
            if (StringUtil.stringNullOrEmpty((String)entity.getLogoTipoComprovante()) || !entity.getLogoTipoComprovante().equals(arquivoRelativo)) {
                this.saveFile.excluirImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Danfe, parametrosOriginais.getLogoTipoComprovante());
                if (StringUtil.stringNullOrEmpty((String)entity.getLogoTipoComprovante())) {
                    entity.setImagemNfce(null);
                }
            } else {
                entity.setLogoTipoComprovante(parametrosOriginais.getLogoTipoComprovante());
            }
        }
        filial.setParametroNfceSat(entity);
        filial.setNaoGravarListas(true);
        FilialRN.getInstance().gravar(1, filial, SessaoUtil.getSessao());
        StatusPdvFilialHelper.alterarFormaEmissao((String)filial.getCodigo(), (FormaEmissaoNfe)entity.getFormaEmissaoNfce());
        return filial.getId();
    }

    @RequestMapping(value={"/valida-cfop"})
    @DBAutoCommit
    public void validaCfop(@RequestParam(value="cfop") Long cfop, @RequestParam(value="tipo") int tipo) throws UnicoMensagemUsuarioException {
        if (NumberUtil.longNullOuZero((Long)cfop)) {
            return;
        }
        NaturezaOperacao naturezaOperacao = NaturezaOperacaoRN.getInstance().buscarPorId(cfop);
        if (!ValidacaoCfopNfce.isCfopValida((String)NumberUtil.apenasNumeros((String)naturezaOperacao.getCodigo()), (int)tipo)) {
            throw new UnicoMensagemUsuarioException("WPDV475", "Cfop " + naturezaOperacao.getCodigo() + " inv\u00e1lida, permitido somente " + ValidacaoCfopNfce.buscaCfopPorTipo((int)tipo));
        }
    }

    public boolean isGravarArquivoTabela() {
        return true;
    }
}

