/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.patchs;

import br.intelidata.commons.domain.pojo.SimpleController;
import br.intelidata.commons.domain.pojo.financeiro.ContaCorrenteLancamento;
import br.intelidata.commons.modulo.financeiro.regranegocio.ContaCorrenteLancamentoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.web.rest.app.crud.patchs.Filtro;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/patch-corrigir-caixa-banco-sem-filial"})
public class PatchCorrigirCaixaBancoSemFilialController
extends SimpleController {
    @PostMapping(value={"/buscar-dados"})
    @DBAutoCommit
    public List<ContaCorrenteLancamento> getDados(@RequestBody Filtro filtro) {
        return ContaCorrenteLancamentoRN.getInstance().buscaLancamentosSemFilial(filtro.getIdContaCorrente(), filtro.getDataInicial(), filtro.getDataFinal());
    }

    @PostMapping(value={"/gravar"})
    @DBTransaction
    public void corrigirLancamentosSemFilial(@RequestBody List<Map<String, Long>> dados) {
        List lista = dados.stream().map(item -> {
            ContaCorrenteLancamento lancamento = new ContaCorrenteLancamento();
            lancamento.setId((Long)item.get("id"));
            lancamento.setIdFilial((Long)item.get("idFilial"));
            return lancamento;
        }).collect(Collectors.toList());
        ContaCorrenteLancamentoRN.getInstance().corrigirLancamentosSemFilial(lista);
    }
}

