/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.pdv.sangriasuprimento;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.periferico.impressoraNaoFiscal.ImpressoraNaoFiscal;
import br.intelidata.commons.core.periferico.impressoraNaoFiscal.ImpressoraNaoFiscalFactory;
import br.intelidata.commons.core.periferico.impressoraNaoFiscal.ModeloImpressoraNaoFiscal;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.Operacao;
import br.intelidata.commons.domain.pojo.Pagamento;
import br.intelidata.commons.domain.pojo.ParametroNfceSat;
import br.intelidata.commons.domain.pojo.enuns.StatusTransacaoCarteiraDigital;
import br.intelidata.commons.domain.pojo.enuns.pafecf.TipoOperacao;
import br.intelidata.commons.domain.pojo.pafecf.FechamentoPdv;
import br.intelidata.commons.domain.pojo.pafecf.MotivoSangriaSuprimento;
import br.intelidata.commons.domain.regranegocio.FechamentoPdvCommonRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.financeiro.enums.TipoResumoItensFechamento;
import br.intelidata.commons.modulo.financeiro.regranegocio.TransacaoCarteiraDigitaRN;
import br.intelidata.commons.modulo.financeiro.relatorio.fechamento.model.FechamentoECFModel;
import br.intelidata.commons.modulo.pdv.regranegocio.MotivoSangriaSuprimentoRN;
import br.intelidata.commons.modulo.pdv.regranegocio.OperacaoRN;
import br.intelidata.commons.modulo.pdv.regranegocio.PagamentoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.web.rest.app.crud.nfcesat.NfceUtil;
import br.intelidata.uniplusweb.web.rest.app.crud.pdv.sangriasuprimento.SangriaSuprimentoAbstract;
import br.intelidata.uniplusweb.web.rest.app.crud.pdv.sangriasuprimento.SangriaSuprimentoFactory;
import br.intelidata.uniplusweb.web.rest.app.crud.pdv.sangriasuprimento.SangriaSuprimentoWrapper;
import java.math.BigDecimal;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import unipaf.nfce.ImpressaoDanfePDF;

@RestController
@RequestMapping(value={"/api/sangria-suprimento"})
public class SangriaSuprimentoController {
    private final ResponseEntityService responseEntityService;

    public SangriaSuprimentoController(ResponseEntityService responseEntityService) {
        this.responseEntityService = responseEntityService;
    }

    @RequestMapping(method={RequestMethod.POST})
    @DBTransaction
    public Long lancar(@RequestBody SangriaSuprimentoWrapper wrapper) throws UnicoMensagemUsuarioException {
        MotivoSangriaSuprimento motivo = (MotivoSangriaSuprimento)MotivoSangriaSuprimentoRN.getInstance().buscarPorId(wrapper.getIdMotivo());
        SangriaSuprimentoAbstract rotina = SangriaSuprimentoFactory.getRotina((boolean)wrapper.isSangria(), (boolean)wrapper.isFechamento());
        rotina.setMotivo(motivo);
        return rotina.lancar(SessaoUtil.getSessao(), wrapper.getValor());
    }

    @RequestMapping(value={"imprimir-pdf"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> imprimirPDF(@RequestBody Long idOperacao, @RequestParam boolean isFechamento, @RequestParam boolean isRelatorio) throws UnicoMensagemUsuarioException {
        return this.responseEntityService.createPDFResponse(this.impressao(ModeloImpressoraNaoFiscal.PDF, idOperacao, false, 0, "", isFechamento, isRelatorio));
    }

    @RequestMapping(value={"imprimir-nao-fiscal"})
    @DBAutoCommit
    public String imprimirNaoFiscal(@RequestParam Long idOperacao, @RequestParam ModeloImpressoraNaoFiscal modelo, @RequestParam String pagina, @RequestParam boolean removeAcentos, @RequestParam int linhas, @RequestParam boolean isFechamento, @RequestParam boolean isRelatorio) throws UnicoMensagemUsuarioException {
        return Base64.getEncoder().encodeToString(this.impressao(modelo, idOperacao, removeAcentos, linhas, pagina, isFechamento, isRelatorio));
    }

    private byte[] impressao(ModeloImpressoraNaoFiscal modelo, Long idOperacao, boolean removeAcentos, int linhas, String pagina, boolean isFechameto, boolean isRelatorio) throws UnicoMensagemUsuarioException {
        Filial filial;
        Long idFechamento;
        Operacao operacao = (Operacao)OperacaoRN.getInstance().buscarPorId(idOperacao);
        MotivoSangriaSuprimento motivo = null;
        if (operacao != null) {
            idFechamento = operacao.getIdFechamento();
            filial = (Filial)FilialRN.getInstance().buscarPorCodigo(operacao.getFilial());
            motivo = MotivoSangriaSuprimentoRN.getInstance().buscarPorCodigo(operacao.getMotivo());
        } else {
            Sessao sessao = SessaoUtil.getSessao();
            FechamentoPdv fechamentoPdv = FechamentoPdvCommonRN.getInstance().buscarFechamentoAbertoUsuario(sessao, sessao.getIdUsuario());
            idFechamento = fechamentoPdv.getId();
            filial = (Filial)FilialRN.getInstance().buscarPorCodigo(sessao.getCodigoFilial());
        }
        ImpressoraNaoFiscal inf = ImpressoraNaoFiscalFactory.getImpressora((ModeloImpressoraNaoFiscal)modelo);
        List comprovante = isFechameto ? this.relatorioFechamentoPDv(SessaoUtil.getSessao(), inf.getColunas()[1].intValue(), idFechamento, isRelatorio) : this.geraComprovante(operacao, operacao.getHistorico(), motivo != null ? motivo.getDescricao() : "", inf.getColunas()[1].intValue());
        if (!modelo.equals((Object)ModeloImpressoraNaoFiscal.PDF)) {
            inf.setNaoCriarPrintService(true);
            inf.setRemoveAcentos(removeAcentos);
            inf.inicializa("", linhas, pagina, true);
        }
        inf.setCabecalho(ImpressaoDanfePDF.getCabecalhoPadrao((Filial)filial));
        inf.setLogoTipo(NfceUtil.getLogoTipo((ParametroNfceSat)filial.getParametroNfceSat()));
        return inf.getBytesImpressao(this.getLinhasImpressas(comprovante));
    }

    @RequestMapping(value={"fechamento"})
    @DBAutoCommit
    public String relatorioFechamento(@RequestParam Long idOperacao, @RequestParam boolean isRelatorio) throws UnicoMensagemUsuarioException {
        Long idFechamento;
        Sessao sessao = SessaoUtil.getSessao();
        Operacao operacao = (Operacao)OperacaoRN.getInstance().buscarPorId(idOperacao);
        if (operacao != null) {
            idFechamento = operacao.getIdFechamento();
        } else {
            FechamentoPdv fechamentoPdv = FechamentoPdvCommonRN.getInstance().buscarFechamentoAbertoUsuario(sessao, sessao.getIdUsuario());
            if (fechamentoPdv == null) {
                throw new UnicoMensagemUsuarioException("WWW715", "O caixa est\u00e1 fechado. Para abrir o caixa, fa\u00e7a um suprimento ou uma venda.");
            }
            idFechamento = fechamentoPdv.getId();
        }
        return this.getLinhasImpressas(this.relatorioFechamentoPDv(sessao, 75, idFechamento, isRelatorio));
    }

    private List<String> geraComprovante(Operacao operacao, String historico, String motivo, int numeroColunas) {
        Pagamento pagamento = (Pagamento)PagamentoRN.getInstance().buscarListaPorOperacao(operacao.getId()).get(0);
        String nomeComprovante = operacao.getTipo().equals((Object)TipoOperacao.SANGRIA) ? "SANGRIA" : "SUPRIMENTO";
        ArrayList<String> linhasImpressas = new ArrayList<String>(this.getCabecalhoComprovante(nomeComprovante, numeroColunas));
        linhasImpressas.add("N\u00famero do comprovante: " + operacao.getCoo());
        linhasImpressas.add("Data: " + Util.formataDataHora((Temporal)operacao.getHoraInicial(), (String)"dd/MM/yyyy HH:mm:ss"));
        linhasImpressas.add("Pdv: " + operacao.getPdv() + " Operador: " + SessaoUtil.getSessao().getUsuario().getCodigo());
        if (!Util.stringNullOrEmpty((String)historico)) {
            linhasImpressas.add("Hist\u00f3rico: " + historico);
        }
        if (!Util.stringNullOrEmpty((String)motivo)) {
            linhasImpressas.add("Motivo: " + motivo);
        }
        linhasImpressas.add("Formas de pagamento:");
        String txtNomeFinalizador = pagamento.getNomeFinalizador();
        String txtValorPagamento = "R$" + Util.formataNumero((BigDecimal)pagamento.getValorTotal(), (String)"#,###,###,##0.00", (int)10);
        linhasImpressas.add(Util.padSeparar((String)txtNomeFinalizador, (String)txtValorPagamento, (int)numeroColunas));
        linhasImpressas.add(Util.padSeparar((String)"Valor Total", (String)txtValorPagamento, (int)numeroColunas));
        return linhasImpressas;
    }

    private List<String> getCabecalhoComprovante(String nomeComprovante, int colunas) {
        ArrayList<String> linhas = new ArrayList<String>();
        linhas.add(Util.replicate((char)'-', (int)colunas));
        linhas.add(Util.padc((String)"COMPROVANTE N\u00c3O-FISCAL", (int)colunas));
        linhas.add(Util.padc((String)nomeComprovante, (int)colunas));
        linhas.add(Util.replicate((char)'-', (int)colunas));
        return linhas;
    }

    private String getLinhasImpressas(List<String> linhasImpressas) {
        StringBuilder sb = new StringBuilder(linhasImpressas.size() * 50);
        for (String str : linhasImpressas) {
            sb.append(str).append("\n");
        }
        linhasImpressas.clear();
        return sb.toString();
    }

    private List<String> relatorioFechamentoPDv(Sessao sessao, int colunas, Long idFechamento, boolean isRelatorio) {
        FechamentoPdv fechamentoPdv = (FechamentoPdv)FechamentoPdvCommonRN.getInstance().buscarPorId(idFechamento);
        FechamentoECFModel model = this.getFechamentoModel(sessao, fechamentoPdv);
        Map fechamentosECF = model.getFechamento();
        ArrayList<String> rel = new ArrayList<String>();
        rel.add(Util.replicate((String)"-", (int)colunas));
        rel.add(isRelatorio ? "EXTRATO DO FECHAMENTO DO PDV" : "FECHAMENTO DO PDV");
        rel.add("C\u00d3DIGO   : " + fechamentoPdv.getCodigo());
        rel.add("PDV      : " + sessao.getUsuario().getPreferenciaUsuario().getPdv());
        rel.add("USU\u00c1RIO  : " + sessao.getUsuario().getCodigo() + " - " + sessao.getUsuario().getNome());
        rel.add("DATA/HORA: " + Util.formataDataHora((Temporal)DataHoraFactory.getDataHora(), (String)"dd/MM/yy HH:mm:ss"));
        for (FechamentoECFModel.FechamentoECF fechamento : fechamentosECF.values()) {
            this.imprimirDados("SUPRIMENTO AUTOMATICO", fechamento, TipoOperacao.SUPRIMENTO_AUTOMATICO, rel, colunas, model);
            this.imprimirDados("SUPRIMENTO", fechamento, TipoOperacao.SUPRIMENTO, rel, colunas, model);
            this.imprimirDados("VENDA", fechamento, TipoOperacao.VENDA, rel, colunas, model);
            this.imprimirDados("VENDA MANUAL", fechamento, TipoOperacao.VENDA_MANUAL, rel, colunas, model);
            this.imprimirDados("VENDA RPS", fechamento, TipoOperacao.RPS, rel, colunas, model);
            this.imprimirDados("RECEBIMENTO", fechamento, TipoOperacao.RECEBIMENTO, rel, colunas, model);
            this.imprimirDados("TROCO COMO REPIQUE", fechamento, TipoOperacao.TROCO_REPIQUE, rel, colunas, model);
            this.imprimirDados("RESGATE CARTAO FIDELIDADE", fechamento, TipoOperacao.RESGATE_CARTAO_FIDELIDADE, rel, colunas, model);
            this.imprimirDados("CORRESPONDENTE BANCARIO", fechamento, TipoOperacao.CORRESPONDENTE_BANCARIO, rel, colunas, model);
            this.imprimirDados("RECARGA DE CELULAR", fechamento, TipoOperacao.RECARGA_CELULAR, rel, colunas, model);
            this.imprimirDados("ADIANTAMENTO", fechamento, TipoOperacao.ADIANTAMENTO, rel, colunas, model);
            this.imprimirDados("PR\u00c9-PAGO", fechamento, TipoOperacao.PRE_PAGO, rel, colunas, model);
            this.imprimirDados("VALE PRESENTE", fechamento, TipoOperacao.VALE_PRESENTE, rel, colunas, model);
            this.imprimirDados("SANGRIA", fechamento, TipoOperacao.SANGRIA, rel, colunas, model);
            this.imprimirDados("SOBRA DE CAIXA", fechamento, TipoOperacao.SOBRA_CAIXA, rel, colunas, model);
            this.imprimirDados("FALTA DE CAIXA", fechamento, TipoOperacao.FALTA_CAIXA, rel, colunas, model);
            this.imprimirValor("TROCO EM DINHEIRO", fechamento.getTrocoDinheiro(), rel, colunas);
            this.imprimirValor("TROCO EM CONTRAVALE", fechamento.getTrocoContraVale(), rel, colunas);
            this.imprimirValor("RESTITUIDO", fechamento.getRestituido(), rel, colunas);
            this.imprimirValor("TOTAL EM CHEQUE", fechamento.getTotalCheque(), rel, colunas);
            this.imprimirCancelamentos(fechamento, colunas, rel);
            this.imprimirDinheiroEmCaixa(fechamento, colunas, rel, isRelatorio);
            this.imprimirResumoCartoes(fechamento, colunas, rel, model);
            this.imprimirResumoCarteiraDigital(fechamento, colunas, rel, model);
            rel.add(Util.replicate((String)"-", (int)colunas));
            rel.add("DESCONTOS/ACRESCIMOS");
            rel.add(Util.replicate((String)"-", (int)colunas));
            rel.add(Util.padSeparar((String)"Total descontos :", (String)Util.formataNumero((BigDecimal)fechamento.getDescontos(), (String)"#,###,###,##0.00", (int)15), (int)colunas));
            rel.add(Util.padSeparar((String)"Total acrescimos:", (String)Util.formataNumero((BigDecimal)fechamento.getAcrescimos(), (String)"#,###,###,##0.00", (int)15), (int)colunas));
            this.imprimeItens("ITEM VENDIDO", fechamento.getItensVendidos(), colunas, rel);
            this.imprimeItens("ITEM CANCELADO", fechamento.getItensCancelados(), colunas, rel);
        }
        return rel;
    }

    private void imprimirDados(String titulo, FechamentoECFModel.FechamentoECF fechamento, TipoOperacao tipoOperacao, List<String> rel, int colunas, FechamentoECFModel model) {
        FechamentoECFModel.FechamentoECFOperacao operacao = (FechamentoECFModel.FechamentoECFOperacao)fechamento.getOperacoes().get(tipoOperacao);
        if (operacao == null || Util.mapNullOrEmpty((Map)operacao.getFinalizadores())) {
            return;
        }
        List historicos = (List)fechamento.getHistorico().get(tipoOperacao);
        rel.add(Util.replicate((String)"-", (int)colunas));
        int tamTitulo = this.imprimeCabecalho(titulo, "VALOR", "QTD", 15, 5, colunas, rel);
        rel.add(Util.replicate((String)"-", (int)colunas));
        if (!Util.collectionNullOrEmpty((Collection)historicos)) {
            BigDecimal valorTotal = BigDecimal.ZERO;
            for (FechamentoECFModel.FechamentoECFDetalhe historico : historicos) {
                rel.add(Util.padl((String)Util.left((String)historico.getDescricao(), (int)tamTitulo), (int)tamTitulo) + Util.formataNumero((BigDecimal)historico.getValorTotal(), (String)"#,###,###,##0.00", (int)15));
                valorTotal = valorTotal.add(historico.getValorTotal());
            }
            rel.add(Util.padl((String)"TOTAL", (int)tamTitulo) + Util.formataNumero((BigDecimal)valorTotal, (String)"#,###,###,##0.00", (int)15));
            rel.add(Util.replicate((String)"-", (int)colunas));
        }
        int qtdTotal = 0;
        BigDecimal valorTotal = BigDecimal.ZERO;
        for (FechamentoECFModel.FechamentoECFDetalhe detalhe : model.getDetalheOrdenado((Map)operacao.getFinalizadores(), FechamentoECFModel.FechamentoECFDetalhe::getDescricao, false)) {
            rel.add(Util.padl((String)Util.left((String)detalhe.getDescricao(), (int)tamTitulo), (int)tamTitulo) + Util.formataNumero((BigDecimal)detalhe.getValorTotal(), (String)"#,###,###,##0.00", (int)15) + Util.padr((String)String.valueOf(detalhe.getNumeroOperacoes()), (int)5));
            valorTotal = valorTotal.add(detalhe.getValorTotal());
            qtdTotal += detalhe.getNumeroOperacoes();
        }
        if (Util.collectionNullOrEmpty((Collection)historicos)) {
            rel.add(Util.padl((String)"TOTAL", (int)tamTitulo) + Util.formataNumero((BigDecimal)valorTotal, (String)"#,###,###,##0.00", (int)15) + Util.padr((String)String.valueOf(qtdTotal), (int)5));
        }
        rel.add("");
    }

    private void imprimirDinheiroEmCaixa(FechamentoECFModel.FechamentoECF fechamento, int colunas, List<String> rel, boolean isRelatorio) {
        rel.add(Util.replicate((String)"*", (int)colunas));
        if (!isRelatorio) {
            rel.add("PDV FECHADO");
        } else {
            BigDecimal saldo = fechamento.getDinheiroEmCaixa();
            rel.add(Util.padc((String)("DINHEIRO NO PDV " + Util.formataNumero((BigDecimal)saldo, (String)"#,###,###,##0.00", (int)15)), (int)colunas));
        }
        rel.add(Util.replicate((String)"*", (int)colunas));
    }

    private void imprimirCancelamentos(FechamentoECFModel.FechamentoECF fechamentoECF, int colunas, List<String> rel) {
        if (fechamentoECF.getCancelamento().isEmpty()) {
            return;
        }
        rel.add(Util.replicate((String)"-", (int)colunas));
        rel.add("CANCELAMENTOS");
        rel.add(Util.replicate((String)"-", (int)colunas));
        for (FechamentoECFModel.FechamentoECFCancelamento cancelado : fechamentoECF.getCancelamento()) {
            rel.add("  Tipo: " + Util.padl((String)cancelado.getTipo(), (int)25));
            rel.add("   Qtd: " + cancelado.getQuantidadeRegistro());
            if (cancelado.getValorTotalCancelamento().compareTo(BigDecimal.ZERO) > 0) {
                rel.add(" Total: " + Util.padl((String)Util.formataNumero((String)cancelado.getValorTotalCancelamento().toString(), (String)"#,###,###,##0.00", (int)15), (int)15));
            }
            rel.add(Util.replicate((String)"-", (int)colunas));
        }
    }

    private void imprimirResumoCarteiraDigital(FechamentoECFModel.FechamentoECF fechamento, int colunas, List<String> rel, FechamentoECFModel model) {
        List listaTransacoesPendentes;
        if (!fechamento.getCarteirasDigitais().isEmpty()) {
            rel.add("RESUMO POR");
            String txtTitulo = colunas <= 32 ? "CART. DIG." : "CARTEIRAS DIGITAIS";
            this.imprimeDados(txtTitulo, model.getDetalheOrdenado(fechamento.getCarteirasDigitais(), FechamentoECFModel.FechamentoECFDetalhe::getValorTotal, true), colunas, rel);
            rel.add("");
        }
        if (!(listaTransacoesPendentes = TransacaoCarteiraDigitaRN.getInstance().buscarListaPorStatus(StatusTransacaoCarteiraDigital.TIME_OUT)).isEmpty()) {
            rel.add(this.destacarNoCentro("TRANSACOES COM CARTEIRA", colunas));
            rel.add(this.destacarNoCentro("DIGITAL PENDENTES DE", colunas));
            rel.add(this.destacarNoCentro("CANCELAMENTO", colunas));
            rel.add("");
        }
    }

    private void imprimirResumoCartoes(FechamentoECFModel.FechamentoECF fechamento, int colunas, List<String> rel, FechamentoECFModel model) {
        if (!fechamento.getOperadorasCartao().isEmpty()) {
            rel.add("RESUMO POR");
            String txtTitulo = colunas <= 32 ? "ADM CART\u00c3O" : "ADMINISTRADORA DE CART\u00c3O";
            this.imprimeDados(txtTitulo, model.getDetalheOrdenado(fechamento.getOperadorasCartao(), FechamentoECFModel.FechamentoECFDetalhe::getValorTotal, true), colunas, rel);
            rel.add("");
        }
    }

    private void imprimeItens(String titulo, List<FechamentoECFModel.FechamentoECFItem> itens, int colunas, List<String> rel) {
        if (!Util.listNullOrEmpty(itens)) {
            rel.add("");
            rel.add(Util.replicate((String)"-", (int)colunas));
            int tamTitulo = this.imprimeCabecalho(titulo, "QTD", "UN", 15, 6, colunas, rel);
            rel.add(Util.replicate((String)"-", (int)colunas));
            for (FechamentoECFModel.FechamentoECFItem item : itens) {
                String mascaraQtd = Util.getMascaraQuantidade((int)item.getDecimaisQuantidade());
                String nome = Util.padl((String)Util.left((String)item.getNome(), (int)tamTitulo), (int)tamTitulo);
                String qtd = Util.formataNumero((BigDecimal)item.getQuantidade(), (String)mascaraQtd, (int)15);
                String un = Util.padr((String)item.getUnidade(), (int)6);
                rel.add(nome + qtd + un);
            }
        }
    }

    private void imprimeDados(String titulo, List<FechamentoECFModel.FechamentoECFDetalhe> detalhes, int colunas, List<String> rel) {
        if (Util.listNullOrEmpty(detalhes)) {
            return;
        }
        BigDecimal valorTotal = BigDecimal.ZERO;
        int qtdTotal = 0;
        rel.add(Util.replicate((String)"-", (int)colunas));
        int tamTitulo = this.imprimeCabecalho(titulo, "VALOR", "QTD", 15, 5, colunas, rel);
        rel.add(Util.replicate((String)"-", (int)colunas));
        for (FechamentoECFModel.FechamentoECFDetalhe detalhe : detalhes) {
            rel.add(Util.padl((String)detalhe.getDescricao(), (int)tamTitulo) + Util.formataNumero((BigDecimal)detalhe.getValorTotal(), (String)"#,###,###,##0.00", (int)15) + Util.padr((String)String.valueOf(detalhe.getNumeroOperacoes()), (int)5));
            valorTotal = valorTotal.add(detalhe.getValorTotal());
            qtdTotal += detalhe.getNumeroOperacoes();
        }
        rel.add(Util.padl((String)"TOTAL", (int)tamTitulo) + Util.formataNumero((BigDecimal)valorTotal, (String)"#,###,###,##0.00", (int)15) + Util.padr((String)String.valueOf(qtdTotal), (int)5));
        rel.add("");
    }

    private void imprimirValor(String titulo, BigDecimal valor, List<String> rel, int colunas) {
        if (valor.compareTo(BigDecimal.ZERO) > 0) {
            rel.add(Util.replicate((String)"-", (int)colunas));
            rel.add(Util.padl((String)titulo, (int)(colunas - 25)) + Util.formataNumero((BigDecimal)valor, (String)"#,###,###,##0.00", (int)20));
        }
    }

    private FechamentoECFModel getFechamentoModel(Sessao sessao, FechamentoPdv fechamentoPdv) {
        FechamentoECFModel model = new FechamentoECFModel();
        model.setCodigoFilial(sessao.getFilial().getCodigo());
        model.setAgrupaVendaCartaoNomeBandeira(true);
        model.setTipoResumoItens(TipoResumoItensFechamento.NENHUM);
        model.setLocal(true);
        if (fechamentoPdv != null) {
            model.setIdFechamento(fechamentoPdv.getId());
        } else {
            model.setIdFechamento(Long.valueOf(Long.MIN_VALUE));
        }
        return model;
    }

    private int imprimeCabecalho(String coluna1, String coluna2, String coluna3, int tamColuna2, int tamColuna3, int colunas, List<String> rel) {
        String cabecalho = Util.padr((String)coluna2, (int)tamColuna2) + Util.padr((String)coluna3, (int)tamColuna3);
        int tamColuna1 = colunas - cabecalho.length();
        rel.add(Util.padl((String)Util.left((String)coluna1, (int)tamColuna1), (int)tamColuna1) + cabecalho);
        return tamColuna1;
    }

    private String destacarNoCentro(String texto, int colunas) {
        int espacoLivre = Math.max(colunas - texto.length(), 0);
        int numEstrelhasEsquerda = espacoLivre / 2;
        int numEstrelhasDireita = espacoLivre - numEstrelhasEsquerda;
        return Util.replicate((String)"*", (int)numEstrelhasEsquerda) + texto + Util.replicate((String)"*", (int)numEstrelhasDireita);
    }
}

