/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.pendenciasistema;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.domain.pojo.EventoSistema;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.modulo.ferramentas.centralpendencias.pojo.PendenciaSistemaFilial;
import br.intelidata.commons.modulo.ferramentas.centralpendencias.regranegocio.PendenciaSistemaRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.config.UnipluswebProperties;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.service.socket.NotificationService;
import br.intelidata.uniplusweb.service.socket.NotificationType;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.crud.pendenciasistema.PendenciaSistemaCache;
import br.intelidata.uniplusweb.web.rest.app.crud.pendenciasistema.PendenciaSistemaController;
import br.intelidata.uniplusweb.web.rest.app.crud.pendenciasistema.PendenciaSistemaImprimeListaWeb;
import br.intelidata.uniplusweb.web.rest.app.crud.pendenciasistema.PendenciaSistemaWrapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/pendencias-sistema"})
@SubMenuMapping(MENU="SubMenuFerramentasAuxiliar", NOME="Pend\u00eancias do sistema", ROTA="/ferramentas/pendencias-sistema", ICONE="icon-mensagem-aviso", PROGRAMA=1000049)
public class PendenciaSistemaController {
    private final ResponseEntityService responseEntityService;
    private final NotificationService notificationService;
    private final TaskManager taskManager;
    private final UnipluswebProperties unipluswebProperties;

    @Autowired
    public PendenciaSistemaController(ResponseEntityService responseEntityService, NotificationService notificationService, TaskManager taskManager, UnipluswebProperties unipluswebProperties) {
        this.responseEntityService = responseEntityService;
        this.notificationService = notificationService;
        this.taskManager = taskManager;
        this.unipluswebProperties = unipluswebProperties;
    }

    @RequestMapping(value={"/buscar"})
    @DBAutoCommit
    public List<PendenciaSistemaFilial> buscar(@RequestParam boolean recarregar) {
        List pendencias = PendenciaSistemaCache.getInstance().getPendencias(ContextoHolder.getTenant());
        if (recarregar || pendencias.isEmpty()) {
            Sessao sessao = SessaoUtil.getSessaoSistema();
            PendenciaSistemaRN pendenciaSistemaRN = new PendenciaSistemaRN();
            pendencias = pendenciaSistemaRN.verificaPendencias(sessao, true, this.unipluswebProperties.getConfiguracaoSchedulers().isHabilitarEnvioEmailPendenciaSistema(), null);
            PendenciaSistemaCache.getInstance().setPendencias(ContextoHolder.getTenant(), pendencias);
            int totalPendencias = pendencias.stream().mapToInt(PendenciaSistemaFilial::getQuantidade).sum();
            this.notificationService.notifyTenantNow(NotificationType.PENDENCIAS_SISTEMA, (Object)totalPendencias);
        }
        return pendencias;
    }

    @PostMapping(value={"/verificar-permissao"})
    @DBAutoCommit
    public Map<String, Object> verificarPermissao(@RequestBody PendenciaSistemaWrapper wrapper) {
        HashMap<String, Object> retorno = new HashMap<String, Object>();
        Sessao sessao = SessaoUtil.getSessao();
        boolean mesmaFilialLogada = wrapper.getPendencia().getFilial().getId().compareTo(sessao.getFilial().getId()) == 0;
        boolean podeExecutar = wrapper.getEvento().getAcao().isUsuarioPermitido(sessao.getUsuario()) && (mesmaFilialLogada || wrapper.getEvento().getAcao().isAcaoGlobal());
        retorno.put("podeExecutar", podeExecutar);
        if (podeExecutar) {
            retorno.put("dica", "Verificar pend\u00eancia");
        } else if (!mesmaFilialLogada) {
            retorno.put("dica", "\u00c9 necess\u00e1rio estar logado na filial para verificar a pend\u00eancia.");
        } else {
            retorno.put("dica", "Usu\u00e1rio logado n\u00e3o possui permiss\u00e3o para resolver essa pend\u00eancia.");
        }
        return retorno;
    }

    @PostMapping(value={"/imprimir"})
    @DBAutoCommit
    public ResponseEntity<byte[]> imprimir(@RequestBody EventoSistema evento) throws UnicoMensagemUsuarioException {
        PendenciaSistemaImprimeListaWeb imprime = new PendenciaSistemaImprimeListaWeb();
        Remessa remessa = null;
        Filial filial = SessaoUtil.getSessao().getFilial();
        switch (2.$SwitchMap$br$intelidata$commons$modulo$ferramentas$centralpendencias$enums$PendenciaSistemaAcaoEnum[evento.getAcao().ordinal()]) {
            case 1: {
                remessa = imprime.acaoBlocoXCadastrosInconsistentes(evento.getParametros());
                break;
            }
            case 2: {
                remessa = imprime.imprimirAdvertencias(evento.getParametros(), "Estoque fora dos limites\nFilial " + filial.getCodigo() + " - " + filial.getRazaoSocialCompleta());
                break;
            }
            case 3: {
                remessa = imprime.imprimirAdvertencias(evento.getParametros(), "Estoque zerado\nFilial " + filial.getCodigo() + " - " + filial.getRazaoSocialCompleta());
                break;
            }
            case 4: {
                remessa = imprime.imprimirAdvertencias(evento.getParametros(), "Estoque negativo\nFilial " + filial.getCodigo() + " - " + filial.getRazaoSocialCompleta());
                break;
            }
            case 5: {
                remessa = imprime.imprimirAdvertencias(evento.getParametros(), "Motoristas com a CNH vencida ");
                break;
            }
        }
        if (remessa != null) {
            return this.responseEntityService.createPDFResponse(remessa.getMalote().extrai("pdf"));
        }
        return null;
    }

    @RequestMapping(value={"/implantar-hash"})
    @DBAutoCommit
    public void implantarHash(@RequestParam boolean nfce) throws UnicoMensagemUsuarioException {
        1 createTask = new /* Unavailable Anonymous Inner Class!! */;
        createTask.createTask(null);
    }

    static /* synthetic */ TaskManager access$000(PendenciaSistemaController x0) {
        return x0.taskManager;
    }
}

