/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.planocontasoperacao;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.contabil.PlanoContaOperacao;
import br.intelidata.commons.domain.pojo.enuns.pafecf.TipoOperacao;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.PlanoContaOperacaoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/plano-contas-operacao"})
@SubMenuMapping(MENU="SubMenuPdvAuxiliar", NOME="Plano de contas por opera\u00e7\u00e3o", ROTA="/pdvs/plano-contas-operacao", PROGRAMA=1000089)
public class PlanoContasOperacaoSimpleController
extends SimpleCrudController<PlanoContaOperacao, PlanoContaOperacaoRN> {
    public PlanoContasOperacaoSimpleController() {
        super((AbstractRegraNegocio)PlanoContaOperacaoRN.getInstance());
    }

    @GetMapping(value={"/read"})
    @DBAutoCommit
    public List<PlanoContaOperacao> carregarPlanos() {
        Long idFilial = SessaoUtil.getSessao().getIdFilial();
        return PlanoContaOperacaoRN.getInstance().buscarListaPorFilial(idFilial);
    }

    @PostMapping(value={"/gravar"})
    @DBAutoCommit
    public void gravar(@RequestBody List<PlanoContaOperacao> plano) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        for (PlanoContaOperacao pco : plano) {
            Long idPlanoConta = pco.getIdPlanoConta();
            if (idPlanoConta == null) {
                this.excluir(pco.getTipoOperacao(), sessao);
                continue;
            }
            this.gravarPlano(pco.getTipoOperacao(), idPlanoConta, sessao);
        }
    }

    private void excluir(TipoOperacao tipoOperacao, Sessao sessao) throws UnicoMensagemUsuarioException {
        PlanoContaOperacao planoOperacao = PlanoContaOperacaoRN.getInstance().getPlanoContaPorTipo(sessao.getIdFilial(), tipoOperacao);
        if (planoOperacao != null) {
            PlanoContaOperacaoRN.getInstance().excluir((AbstractPojo)planoOperacao, sessao);
        }
    }

    private void gravarPlano(TipoOperacao tipoOperacao, Long idPlanoConta, Sessao sessao) throws UnicoMensagemUsuarioException {
        PlanoContaOperacao planoOperacao = PlanoContaOperacaoRN.getInstance().getPlanoContaPorTipo(sessao.getIdFilial(), tipoOperacao);
        if (planoOperacao == null) {
            planoOperacao = new PlanoContaOperacao();
        }
        planoOperacao.setIdFilial(sessao.getIdFilial());
        planoOperacao.setTipoOperacao(tipoOperacao);
        planoOperacao.setIdPlanoConta(idPlanoConta);
        if (planoOperacao.getId() == null) {
            PlanoContaOperacaoRN.getInstance().incluir((AbstractPojo)planoOperacao, sessao);
        } else {
            PlanoContaOperacaoRN.getInstance().alterar((AbstractPojo)planoOperacao, sessao);
        }
    }
}

