/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.produto.alteracaomassa;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.ProdutoAlteracaoEmMassa;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.TributacaoProduto;
import br.intelidata.commons.domain.regranegocio.MotivoDesoneracaoIcmsPafRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.service.CacheInterfaceService;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import java.util.List;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/alteracoes-produtos"})
public class ProdutoAlteracaoMassaSimpleController
extends SimpleCrudController<ProdutoAlteracaoEmMassa, ProdutoRN> {
    private final CacheInterfaceService cacheInterfaceService;

    public ProdutoAlteracaoMassaSimpleController(CacheInterfaceService cacheInterfaceService) {
        this.cacheInterfaceService = cacheInterfaceService;
    }

    @PostMapping(value={"/gravar"})
    @DBTransaction
    public List<String> gravarAlteracaoEmMassa(@RequestBody ProdutoAlteracaoEmMassa produtoAlteracaoEmMassa) throws UnicoMensagemUsuarioException {
        MotivoDesoneracaoIcmsPafRN.getInstance().validarMotivoDesoneracaoIcms(produtoAlteracaoEmMassa.getTributacaoEspecialNfceSat(), produtoAlteracaoEmMassa.getTributacao() != null ? (TributacaoProduto)EnumUtils.getPorId(TributacaoProduto.class, (Object)produtoAlteracaoEmMassa.getTributacao()) : null, produtoAlteracaoEmMassa.getMotivoDesoneracaoIcms());
        if (!NumberUtil.longNullOuZero((Long)produtoAlteracaoEmMassa.getIdValorNutricional())) {
            produtoAlteracaoEmMassa.setValorEnergetico(null);
            produtoAlteracaoEmMassa.setCarboidratos(null);
            produtoAlteracaoEmMassa.setProteinas(null);
            produtoAlteracaoEmMassa.setGordurasSaturadas(null);
            produtoAlteracaoEmMassa.setGordurastotais(null);
            produtoAlteracaoEmMassa.setGordurasTrans(null);
            produtoAlteracaoEmMassa.setFibraalimentar(null);
            produtoAlteracaoEmMassa.setSodio(null);
        }
        if (produtoAlteracaoEmMassa.getFiltroGrid() != null) {
            List ids = this.cacheInterfaceService.getListaIDs("produtos", produtoAlteracaoEmMassa.getFiltroGrid().getQuery(), produtoAlteracaoEmMassa.getFiltroGrid().getFilter());
            produtoAlteracaoEmMassa.setListaIdsProdutos(ids);
        }
        return ProdutoRN.getInstance().gravarAlteracaoEmMassa(SessaoUtil.getSessao(), produtoAlteracaoEmMassa);
    }

    @PostMapping(value={"/quantidade-registro-alteracao"})
    @DBTransaction
    public int getQuantidadeRegistrosAlteracaoEmMassa(@RequestBody ProdutoAlteracaoEmMassa produtoAlteracaoEmMassa) throws UnicoMensagemUsuarioException {
        if (produtoAlteracaoEmMassa.getFiltroGrid() != null) {
            List ids = this.cacheInterfaceService.getListaIDs("produtos", produtoAlteracaoEmMassa.getFiltroGrid().getQuery(), produtoAlteracaoEmMassa.getFiltroGrid().getFilter());
            produtoAlteracaoEmMassa.setListaIdsProdutos(ids);
        }
        return produtoAlteracaoEmMassa.getListaIdsProdutos().size();
    }
}

