/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.produto.ean;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.EnumSimNao;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.ProdutoEan;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoEanRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/eans-produto"})
public class ProdutoEanCrudController
extends CrudController<ProdutoEan, ProdutoEanRN> {
    public ProdutoEanCrudController() {
        super((AbstractRegraNegocio)ProdutoEanRN.getInstance(), ProdutoEan::new);
    }

    @RequestMapping(value={"/ativar"}, method={RequestMethod.PUT})
    @DBTransaction
    public void ativarEan(@RequestBody ProdutoEan produtoEan) throws UnicoMensagemUsuarioException {
        this.validar(produtoEan);
        produtoEan.setInativo(EnumSimNao.NAO.getId());
        produtoEan.setIdUsuarioAtivo(SessaoUtil.getSessao().getIdUsuario());
        produtoEan.setDataUltimoAtivo(DataHoraFactory.getDataHora());
        ProdutoEanRN.getInstance().alterar((AbstractPojo)produtoEan, SessaoUtil.getSessao());
    }

    @RequestMapping(value={"/inativar"}, method={RequestMethod.PUT})
    @DBTransaction
    public void inativarEan(@RequestBody ProdutoEan produtoEan) throws UnicoMensagemUsuarioException {
        produtoEan.setInativo(EnumSimNao.SIM.getId());
        produtoEan.setIdUsuarioInativo(SessaoUtil.getSessao().getIdUsuario());
        produtoEan.setDataUltimoInativo(DataHoraFactory.getDataHora());
        ProdutoEanRN.getInstance().alterar((AbstractPojo)produtoEan, SessaoUtil.getSessao());
    }

    @RequestMapping(value={"/validar-codigo-barras"})
    @DBAutoCommit
    public boolean validarCodigoBarra(@RequestParam(value="value") String codigoBarras, @RequestParam(value="codigoProduto", required=false) String codigoProduto, @RequestParam(value="validarProdutoAtual") boolean validarProdutoAtual) throws UnicoMensagemUsuarioException {
        if (codigoBarras == null || codigoBarras.isEmpty()) {
            return true;
        }
        ProdutoRN.getInstance().validarCodigoEAN(SessaoUtil.getSessao(), codigoBarras, codigoProduto, validarProdutoAtual);
        return true;
    }

    protected GridBuilder<ProdutoEanRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 10, false));
        colunas.add(new ColunaSQL("idProduto", "idproduto", 10, false));
        colunas.add(new ColunaSQL("variacao", "variacao", 10, false));
        colunas.add(new ColunaSQL("ean", "C\u00f3digo de barras", 80, true));
        colunas.add(new ColunaSQL("descricaoVariacao", "Varia\u00e7\u00e3o", 100, true));
        colunas.add(new ColunaSQL("inativo", "Inativo", 15, true));
        return new GridBuilder(ProdutoEanRN.getInstance().getTabela(), colunas);
    }

    protected void beforeSave(ProdutoEan produtoEan, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        this.validar(produtoEan);
    }

    protected String getCacheId() {
        return "eans-produto";
    }

    private void validar(ProdutoEan produtoEan) throws UnicoMensagemUsuarioException {
        Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(produtoEan.getIdProduto());
        if (produto != null) {
            if (NumberUtil.longNullOuZero((Long)produtoEan.getId()) && !StringUtil.stringNullOrEmpty((String)produtoEan.getEan()) && ProdutoEanRN.getInstance().buscaPorEanProduto(produto.getId(), produtoEan.getEan()) != null) {
                throw new UnicoMensagemUsuarioException("WPRD153", "O c\u00f3digo de barras digitado j\u00e1 foi inclu\u00eddo na lista");
            }
        } else {
            throw new UnicoMensagemUsuarioException("WWW422", "Produto n\u00e3o encontrado");
        }
        ProdutoRN.getInstance().isEanValido(produtoEan.getEan(), produtoEan.getVariacao(), produto.getCodigo(), SessaoUtil.getSessao());
    }
}

