/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.produto.mvaestado;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.ModalidadeDeterminacaoBcIcmsSt;
import br.intelidata.commons.domain.pojo.ProdutoMVAEstado;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoMVAEstadoRN;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/mva-estados-produtos"})
public class ProdutoMvaEstadoCrudController
extends CrudController<ProdutoMVAEstado, ProdutoMVAEstadoRN> {
    public ProdutoMvaEstadoCrudController() {
        super((AbstractRegraNegocio)ProdutoMVAEstadoRN.getInstance(), ProdutoMVAEstado::new);
        this.dependsOn("idProduto");
    }

    protected GridBuilder<ProdutoMVAEstadoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idProduto", "idProduto", 0, false));
        colunas.add(new ColunaSQL("idEstadoDestino", "idEstadoDestino", 0, false));
        colunas.add(new ColunaSQL("idIncentivoFiscalDestino", "idIncentivoFiscalDestino", 0, false));
        colunas.add(new ColunaSQL("idEstadoOrigem", "idEstadoOrigem", 0, false));
        colunas.add(new ColunaSQL("idIncentivoFiscalOrigem", "idIncentivoFiscalOrigem", 0, false));
        colunas.add(new ColunaSQL("idTipoEntidade", "idTipoEntidade", 0, false));
        colunas.add(new ColunaSQL("codigo", "codigoEstadoOrigem", "UF origem", 30, true, new String[]{"fk_prodmvaestado_estadoo"}));
        colunas.add(new ColunaSQL("nome", "nomeIncentivoFiscalOrigem", "Incentivo origem", 30, true, new String[]{"fk_prodmvaestado_ifiscal_o"}));
        colunas.add(new ColunaSQL("codigo", "codigoEstadoDestino", "UF destino", 30, true, new String[]{"fk_prodmvaestado_estadod"}));
        colunas.add(new ColunaSQL("nome", "nomeIncentivoFiscalDestino", "Incentivo destino", 30, true, new String[]{"fk_prodmvaestado_ifiscal_d"}));
        colunas.add(new ColunaSQL("descricao", "descricaoTipoEntidade", "Tipo cliente/fornecedor", 30, true, new String[]{"fk_prodmvaestado_tpentidade"}));
        colunas.add(new ColunaSQL("modalidadeBcIcmsSt", "Mod. BC do ICMS ST", 0, true, ModalidadeDeterminacaoBcIcmsSt.class));
        colunas.add(new ColunaSQL("percMva", "% MVA/Pauta", 0, true));
        colunas.add(new ColunaSQL("percRedMva", "% Red. MVA", 0, true));
        return new GridBuilder(ProdutoMVAEstadoRN.getInstance().getTabela(), colunas);
    }

    protected void beforeSave(ProdutoMVAEstado produtoMVAEstado, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        this.validarAoGravar(produtoMVAEstado);
    }

    protected String getCacheId() {
        return "mva-estados-produtos";
    }

    private void validarAoGravar(ProdutoMVAEstado produtoMva) throws UnicoMensagemUsuarioException {
        if (NumberUtil.longNullOuZero((Long)produtoMva.getIdProduto())) {
            throw new UnicoMensagemUsuarioException("WWW42", "Produto n\u00e3o informado.");
        }
        if (NumberUtil.longNullOuZero((Long)produtoMva.getIdEstadoOrigem()) && NumberUtil.longNullOuZero((Long)produtoMva.getIdIncentivoFiscalOrigem())) {
            throw new UnicoMensagemUsuarioException("WWPRD165", "Por favor, informe o estado ou a Zona Franca/ALC de origem! ");
        }
        if (NumberUtil.longNullOuZero((Long)produtoMva.getIdEstadoDestino()) && NumberUtil.longNullOuZero((Long)produtoMva.getIdIncentivoFiscalDestino())) {
            throw new UnicoMensagemUsuarioException("WWPRD166", "Por favor, informe o estado ou a Zona Franca/ALC de destino! ");
        }
        List produtosMvaGravados = ProdutoMVAEstadoRN.getInstance().buscarPorProduto(produtoMva.getIdProduto());
        ProdutoMVAEstadoRN.getInstance().validarListaProdutoMvaEstado(produtoMva, produtosMvaGravados);
    }
}

