/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.servico;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.Modulo;
import br.intelidata.commons.core.licenca.ProdutoLicenca;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.util.MapResultSet;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Extras;
import br.intelidata.commons.domain.pojo.FeedGoogle;
import br.intelidata.commons.domain.pojo.JsonWrapped;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.ProdutoLicencaIntelidataDTO;
import br.intelidata.commons.domain.pojo.Unidademedida;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.InformacaoInstalacaoLicenca;
import br.intelidata.commons.domain.pojo.enuns.QuantidadeCampoExtra;
import br.intelidata.commons.domain.pojo.enuns.TipoProduto;
import br.intelidata.commons.domain.pojo.enuns.TipoRegistroProduto;
import br.intelidata.commons.domain.pojo.enuns.TipoUsoLicenca;
import br.intelidata.commons.domain.pojo.enuns.TributacaoServico;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.ProdutoPautaPrecoRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.ExtrasRN;
import br.intelidata.commons.modulo.intelidata.enums.TipoComboLicenca;
import br.intelidata.commons.modulo.intelidata.enums.TipoLicenca;
import br.intelidata.commons.modulo.intelidata.enums.TipoLicenciamento;
import br.intelidata.commons.modulo.intelidata.enums.TipoSistemaLicenca;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.UnidademedidaRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.ConfiguracaoCampoExtra;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.JsonUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import br.intelidata.uniplusweb.service.ModuloService;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@ConfiguracaoCampoExtra(TABELA="cad_servico", QUANTIDADE=QuantidadeCampoExtra.SERVICO)
@RestController
@RequestMapping(value={"/api/servicos"})
@SubMenuMapping(MENU="SubMenuCadastroGeral", NOME="Servi\u00e7os", ICONE="icon-servico", PROGRAMA=7, ROTA="/servicos-module/servicos")
public class ServicoCrudController
extends CrudController<Produto, ProdutoRN> {
    private final ModuloService moduloService;
    private final FuncionalidadeService funcionalidadeService;

    @Autowired
    public ServicoCrudController(ModuloService moduloService, FuncionalidadeService funcionalidadeService) {
        super((AbstractRegraNegocio)ProdutoRN.getInstance(), Produto::new);
        this.moduloService = moduloService;
        this.funcionalidadeService = funcionalidadeService;
    }

    @RequestMapping(value={"buscar-servico-cto"})
    @DBAutoCommit
    public List<MapResultSet> buscarProdutosDTOs(@RequestParam(required=false) String query, @RequestParam(required=false) Long idHierarquia, @RequestParam(required=false) Long idNcm, @RequestParam(required=false, defaultValue="6") int limit) {
        return ProdutoRN.getInstance().buscarProdutoDTOWeb(query, idHierarquia, idNcm, limit, TipoRegistroProduto.SERVICO);
    }

    public Extras getCampoExtra(String nome, String tabela) {
        if (tabela.equals(ProdutoRN.getInstance().getTabela())) {
            return ExtrasRN.getInstance().buscarPorNomeTabela("cad_servico");
        }
        return null;
    }

    protected GridBuilder<ProdutoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 250, true));
        colunas.add(new ColunaSQL("nome", "Nome", 0, true));
        colunas.add(new ColunaSQL("preco", "Pre\u00e7o unit\u00e1rio", 250, true));
        colunas.add(new ColunaSQL("tributacao", "Tributa\u00e7\u00e3o", 250, true, TributacaoServico.class));
        colunas.add(new ColunaSQL("casasDecimais", "Casas decimais", 0, false));
        GridBuilder grid = new GridBuilder(ProdutoRN.getInstance().getTabela(), colunas, "cad_servico");
        grid.addReferenciaDefault(new Referencia("tipo", "tipo"));
        grid.addReferenciaDefault(new Referencia("preco", "precoproduto"));
        grid.addReferenciaDefault(new Referencia("precocusto", "precocustoproduto"));
        grid.addReferenciaDefault(new Referencia("precoultimacompra", "precoultimacompraproduto"));
        grid.addReferenciaDefault(new Referencia("customedio", "customedioproduto"));
        grid.addReferencia(new Referencia("inativo", "servicoInativo"));
        grid.addCodicaoDefault(new Condicao("tipo", Operador.IGUAL, TipoRegistroProduto.SERVICO.getId()));
        grid.addOrdemDefault(new Ordem("nome"));
        return grid;
    }

    protected void beforeSave(Produto servico, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        Unidademedida unidade = (Unidademedida)UnidademedidaRN.getInstance().buscarPorId(servico.getIdUnidadeMedida());
        servico.setUnidadeMedida(unidade != null ? unidade.getCodigo() : null);
        servico.setTipo(TipoRegistroProduto.SERVICO);
        servico.setTipoProduto(TipoProduto.SERVICOS);
        servico.setFeedGoogle(new JsonWrapped(JsonUtil.toJson((Object)new FeedGoogle())));
        if (this.moduloService.isAtivo(Modulo.INTELIDATA)) {
            ProdutoLicenca produtoLicenca;
            if (!Util.stringNullOrEmpty((String)servico.getPrefixoLicencaDTO()) && (produtoLicenca = (ProdutoLicenca)EnumUtils.getPorNomeConstante(ProdutoLicenca.class, (String)servico.getPrefixoLicencaDTO())) != null) {
                servico.setPrefixoLicenca(produtoLicenca.getPrefixo());
            }
            if (!Util.stringNullOrEmpty((String)servico.getPrefixoLicencaValidacaoCnpjDTO()) && (produtoLicenca = (ProdutoLicenca)EnumUtils.getPorNomeConstante(ProdutoLicenca.class, (String)servico.getPrefixoLicencaValidacaoCnpjDTO())) != null) {
                servico.setPrefixoLicencaValidacaoCnpj(produtoLicenca.getPrefixo());
            }
            if (!Util.stringNullOrEmpty((String)servico.getInformacaoInstalacaoDTO())) {
                servico.setInformacaoInstalacao((InformacaoInstalacaoLicenca)EnumUtils.getPorNomeConstante(InformacaoInstalacaoLicenca.class, (String)servico.getInformacaoInstalacaoDTO()));
            }
            if (!Util.stringNullOrEmpty((String)servico.getTipoUsoLicencaDTO())) {
                servico.setTipoUsoLicenca((TipoUsoLicenca)EnumUtils.getPorNomeConstante(TipoUsoLicenca.class, (String)servico.getTipoUsoLicencaDTO()));
            }
            if (!Util.stringNullOrEmpty((String)servico.getTipoComboLicencaDTO())) {
                servico.setTipoComboLicenca((TipoComboLicenca)EnumUtils.getPorNomeConstante(TipoComboLicenca.class, (String)servico.getTipoComboLicencaDTO()));
            }
            if (!Util.stringNullOrEmpty((String)servico.getTipoLicencaDTO())) {
                servico.setTipoLicenca((TipoLicenca)EnumUtils.getPorNomeConstante(TipoLicenca.class, (String)servico.getTipoLicencaDTO()));
            }
            if (!Util.stringNullOrEmpty((String)servico.getTipoLicenciamentoDTO())) {
                servico.setTipoLicenciamento((TipoLicenciamento)EnumUtils.getPorNomeConstante(TipoLicenciamento.class, (String)servico.getTipoLicenciamentoDTO()));
            }
            if (!Util.stringNullOrEmpty((String)servico.getTipoSistemaLicencaDTO())) {
                servico.setTipoSistemaLicenca((TipoSistemaLicenca)EnumUtils.getPorNomeConstante(TipoSistemaLicenca.class, (String)servico.getTipoSistemaLicencaDTO()));
            }
        }
    }

    protected void beforeRead(Produto servico, int modo, Optional<Long> parentId) {
        Map pautas;
        TributacaoServico tributacao;
        if (7 == modo) {
            servico.setId(null);
            servico.setCodigo(null);
        }
        if (!StringUtil.stringNullOrEmpty((String)servico.getTributacao()) && (tributacao = (TributacaoServico)EnumUtils.getPorId(TributacaoServico.class, (Object)servico.getTributacao())) != null) {
            servico.setTributacao(tributacao.name());
        }
        if (this.moduloService.isAtivo(Modulo.INTELIDATA)) {
            ProdutoLicenca produtoLicenca;
            if (!Util.stringNullOrEmpty((String)servico.getPrefixoLicenca()) && (produtoLicenca = (ProdutoLicenca)EnumUtils.getPorCampo(ProdutoLicenca.class, (String)"prefixo", (Object)servico.getPrefixoLicenca())) != null) {
                servico.setPrefixoLicencaDTO(produtoLicenca.name());
            }
            if (!Util.stringNullOrEmpty((String)servico.getPrefixoLicencaValidacaoCnpj()) && (produtoLicenca = (ProdutoLicenca)EnumUtils.getPorCampo(ProdutoLicenca.class, (String)"prefixo", (Object)servico.getPrefixoLicencaValidacaoCnpj())) != null) {
                servico.setPrefixoLicencaValidacaoCnpjDTO(produtoLicenca.name());
            }
            if (servico.getInformacaoInstalacao() != null) {
                servico.setInformacaoInstalacaoDTO(servico.getInformacaoInstalacao().name());
            }
            if (servico.getTipoUsoLicenca() != null) {
                servico.setTipoUsoLicencaDTO(servico.getTipoUsoLicenca().name());
            }
            if (servico.getTipoComboLicenca() != null) {
                servico.setTipoComboLicencaDTO(servico.getTipoComboLicenca().name());
            }
            if (servico.getTipoLicenca() != null) {
                servico.setTipoLicencaDTO(servico.getTipoLicenca().name());
            }
            if (servico.getTipoLicenciamento() != null) {
                servico.setTipoLicenciamentoDTO(servico.getTipoLicenciamento().name());
            }
            if (servico.getTipoSistemaLicenca() != null) {
                servico.setTipoSistemaLicencaDTO(servico.getTipoSistemaLicenca().name());
            }
        }
        if (modo != 7 && this.funcionalidadeService.isAtiva(Funcionalidade.PAUTA_PRECO_CADASTRO) && (pautas = ProdutoPautaPrecoRN.getInstance().buscarListaPorIdProduto(servico.getId())) != null) {
            pautas.forEach((chave, lista) -> lista.forEach(pauta -> pauta.setDecimaisPreco(servico.getCasasDecimais().intValue())));
            servico.setPautasPreco(pautas);
        }
    }

    protected String getCacheId() {
        return "servicos".concat("_").concat(TipoRegistroProduto.SERVICO.name());
    }

    @RequestMapping(value={"buscar-servico-pacote-licenca-dto"})
    @DBAutoCommit
    public List<MapResultSet> buscarProdutosPacoteLicencaDTOs(@RequestParam(required=false) String query, @RequestParam(required=false) Long idHierarquia, @RequestParam(required=false) Long idNcm, @RequestParam(required=false, defaultValue="1000") int limit) {
        return ProdutoRN.getInstance().buscarProdutoDTOWeb(query, idHierarquia, idNcm, Boolean.valueOf(false), 1000, TipoRegistroProduto.SERVICO, true);
    }

    @RequestMapping(value={"buscar-produto-licenca"})
    @DBAutoCommit
    public List<ProdutoLicencaIntelidataDTO> buscarProdutoLicenca(@RequestParam(required=false) boolean incluirInativos, @RequestParam(required=false) boolean apenasBase) {
        return ProdutoRN.getInstance().buscarProdutoLicencaIntelidataDTOWeb(incluirInativos, apenasBase);
    }

    @RequestMapping(value={"buscar-sistemas-disponiveis-novidade"})
    @DBAutoCommit
    public List<ProdutoLicencaIntelidataDTO> buscarSistemasDisponiveis() {
        return ProdutoRN.getInstance().buscarSistemasDisponiveisNovidades();
    }
}

