/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.intelidata.contrato;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.model.Coluna;
import br.intelidata.commons.core.sql.model.Visao;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.dicionario.outros.VinculacaoPafIntelidataVW;
import br.intelidata.commons.domain.pojo.enuns.StatusVinculacaoPaf;
import br.intelidata.commons.domain.pojo.relatorioconfigurado.RelatorioConfiguradoColunaWeb;
import br.intelidata.commons.domain.pojo.vendas.ContratoVenda;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.GridControleVisaoRN;
import br.intelidata.commons.domain.regranegocio.VinculacaoPafRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/vinculacao-paf-intelidata"})
@SubMenuMapping(MENU="SubMenuPortalCanalGeral", ICONE="icon-html", NOME="Vincula\u00e7\u00e3o do PAF", ROTA="/intelidata/vinculacao-paf-intelidata", PROGRAMA=9000032)
public class VinculacaoPafCrudController
extends CrudController<ContratoVenda, VinculacaoPafRN> {
    @Autowired
    public VinculacaoPafCrudController() {
        super((AbstractRegraNegocio)VinculacaoPafRN.getInstance(), ContratoVenda::new, false);
    }

    protected String getCacheId() {
        return "vinculacao-paf-intelidata";
    }

    protected GridBuilder<GridControleVisaoRN> getGridBuilder() {
        GridControleVisaoRN visaoRN = new GridControleVisaoRN((Visao)new VinculacaoPafIntelidataVW());
        GridBuilder grid = new GridBuilder(visaoRN.getTabela(), ((VinculacaoPafRN)this.rn).getColunasPadraoGrid(), new ArrayList(), "vinculacao_paf_vw_web", true);
        grid.setCondicoes(((VinculacaoPafRN)this.rn).getCondicoesPadraoGrid());
        grid.setOrdensDefault(((VinculacaoPafRN)this.rn).getOrdenacoesPadraoGrid());
        return grid;
    }

    @RequestMapping(value={"/atualizar-vinculacao-paf"})
    @DBAutoCommit
    public void atualizarVinculacaoPafPorCnpj(@RequestParam String cnpj, @RequestParam StatusVinculacaoPaf vinculacaoPaf) throws UnicoMensagemUsuarioException {
        ((VinculacaoPafRN)this.rn).atualizarVinculacaoPafPorCnpj(cnpj, vinculacaoPaf);
    }

    protected List<RelatorioConfiguradoColunaWeb> getColunasOriginais(GridBuilder<?> gridBuilder) {
        return gridBuilder.getColunasSql().stream().filter(ColunaSQL::isVisivel).map(colunaSQL -> {
            Coluna coluna = gridBuilder.getDefinicaoColuna(gridBuilder.getTabela(), colunaSQL);
            if (colunaSQL.getTipoDadoBase() == null) {
                colunaSQL.setTipoDadoBase(coluna.getTipoDado());
            }
            return new RelatorioConfiguradoColunaWeb(colunaSQL, coluna.getTipoDado());
        }).collect(Collectors.toList());
    }
}

