/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.intelidata.estoque.movimentolicenca;

import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.domain.pojo.MovimentoLicenca;
import br.intelidata.commons.domain.pojo.enuns.TipoMovimentacaoLicenca;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.intelidata.regranegocio.MovimentoLicencaRN;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/movimentos-licenca"})
@SubMenuMapping(MENU="SubMenuPortalCanalGeral", ICONE="icon-html", NOME="Movimentos de licen\u00e7a", ROTA="/intelidata/movimentos-licenca", PROGRAMA=9000021)
public class MovimentoLicencaCrudController
extends CrudController<MovimentoLicenca, MovimentoLicencaRN> {
    public MovimentoLicencaCrudController() {
        super((AbstractRegraNegocio)MovimentoLicencaRN.getInstance(), MovimentoLicenca::new);
        this.dependsOn("idCliente");
    }

    protected String getCacheId() {
        return "movimentos-licenca";
    }

    protected GridBuilder<MovimentoLicencaRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idCliente", "idCliente", 0, false));
        colunas.add(new ColunaSQL("nome", "nomeCliente", "Cliente", 250, true, new String[]{"fk_movlicenca_cliente"}));
        colunas.add(new ColunaSQL("nome", "produto", "Produto", 250, true, new String[]{"fk_movlicenca_produto"}));
        colunas.add(new ColunaSQL("dataHora", "Data e hora", 130, true));
        colunas.add(new ColunaSQL("tipo", "Tipo", 120, true, TipoMovimentacaoLicenca.class));
        colunas.add(new ColunaSQL("quantidade", "Quantidade", 100, true));
        colunas.add(new ColunaSQL("chaveAtivacao", "Chave ativa\u00e7\u00e3o", 180, true));
        colunas.add(new ColunaSQL("historico", "Hist\u00f3rico", 350, true));
        colunas.add(new ColunaSQL("nome", "nomeUsuario", "Usu\u00e1rio", 250, true, new String[]{"fk_movlicenca_usuario"}));
        GridBuilder grid = new GridBuilder(((MovimentoLicencaRN)this.rn).getTabela(), colunas);
        grid.setOrdemDefault(new Ordem("dataHora", true));
        return grid;
    }
}

