/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.intelidata.pdv.pendenciablocox;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.core.uviewer.SaidaRelatorio;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.RelatorioUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import unipaf.geracaoarquivo.blocox.BlocoXPendenciaAuxiliar;
import unipaf.geracaoarquivo.blocox.BlocoXPendenciaDesenvolvedor;
import unipaf.geracaoarquivo.blocox.BlocoXPendenciaRelatorio;
import unipaf.geracaoarquivo.blocox.BlocoXRN;
import unipaf.geracaoarquivo.blocox.ContratoVendaClienteFinalPOJO;
import unipaf.geracaoarquivo.blocox.wsdl.BlocoXWS;
import unipaf.geracaoarquivo.blocox.wsdl.response.RetornoConsultaPendenciaDesenvolvedor;

@RestController
@RequestMapping(value={"/api/pendencia-bloco-x"})
@SubMenuMapping(MENU="SubMenuPortalCanalGeral", ICONE="icon-html", NOME="Pend\u00eancia bloco x", ROTA="/intelidata/pendencia-bloco-x", PROGRAMA=1452)
public class PendenciaBlocoXCrudController
extends SimpleCrudController {
    private ResponseEntityService responseEntityService;

    public PendenciaBlocoXCrudController(ResponseEntityService responseEntityService) {
        this.responseEntityService = responseEntityService;
    }

    @RequestMapping(value={"/carregar"})
    @DBAutoCommit
    public BlocoXPendenciaAuxiliar carregarDados(@RequestParam boolean mostrarSemPendencia) throws UnicoMensagemUsuarioException {
        RetornoConsultaPendenciaDesenvolvedor retorno = BlocoXWS.getInstance().consultarPendenciaDesenvolvedor(SessaoUtil.getSessao(), null);
        return BlocoXRN.getInstance().getListaPendenciaDesenvolvedor(retorno.getEstabelecimentos(), mostrarSemPendencia, retorno.getSituacaoOperacaoCodigo(), retorno.getSituacaoOperacaoDescricao());
    }

    @RequestMapping(value={"/imprimir"}, method={RequestMethod.POST})
    public ResponseEntity<byte[]> imprimir(@RequestBody List<BlocoXPendenciaDesenvolvedor> pendencias) throws UnicoMensagemUsuarioException {
        SaidaRelatorio saida = new SaidaRelatorio(br.intelidata.uniplusweb.web.rest.app.client.report.SaidaRelatorio.EXCEL.getId().intValue(), "", false);
        Remessa remessa = new BlocoXPendenciaRelatorio().imprimir(saida, pendencias);
        return RelatorioUtil.visualizar((Remessa)remessa, (ResponseEntityService)this.responseEntityService, (br.intelidata.uniplusweb.web.rest.app.client.report.SaidaRelatorio)br.intelidata.uniplusweb.web.rest.app.client.report.SaidaRelatorio.EXCEL, (String)"Pend\u00eancias Bloco X");
    }

    @RequestMapping(value={"/atualizar-contratos"}, method={RequestMethod.POST})
    @DBTransaction
    public void atualizarContrato(@RequestBody List<ContratoVendaClienteFinalPOJO> contratos) {
        BlocoXRN.getInstance().atualizarDadosBlocoXContratos(contratos);
    }
}

