/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.recoverypassword;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.BCrypt;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.EnumSimNao;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Usuario;
import br.intelidata.commons.domain.pojo.UsuarioReseteSenha;
import br.intelidata.commons.domain.pojo.enuns.NivelPoliticaSeguranca;
import br.intelidata.commons.domain.regranegocio.ControleRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.UsuarioRN;
import br.intelidata.commons.modulo.intelidata.regranegocio.UsuarioReseteSenhaRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.util.BeanUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.recoverypassword.ResetPasswordEmailService;
import java.time.temporal.ChronoUnit;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/recuperar-senha"})
public class ResetPasswordController {
    private final ResetPasswordEmailService emailService;
    private final HttpServletRequest httpServletRequest;

    @Autowired
    public ResetPasswordController(ResetPasswordEmailService emailService, HttpServletRequest httpServletRequest) {
        this.emailService = emailService;
        this.httpServletRequest = httpServletRequest;
    }

    @RequestMapping(value={"/criar"}, method={RequestMethod.GET})
    @DBAutoCommit
    public void getRecuperaSenha(@RequestParam String userResetEmail, @RequestParam String version, @RequestParam String ambiente, @RequestParam String url) throws UnicoMensagemUsuarioException {
        Usuario usuario = UsuarioRN.getInstance().buscarPorEmail(userResetEmail, true);
        if (usuario == null || StringUtil.stringNullOrEmpty((String)userResetEmail)) {
            throw new UnicoMensagemUsuarioException("COM236603", "Aten\u00e7\u00e3o! Verifique se existe um usu\u00e1rio com esse e-mail.");
        }
        UsuarioReseteSenha usuarioRecuperaSenha = new UsuarioReseteSenha();
        usuarioRecuperaSenha.setIdUsuario(null);
        usuarioRecuperaSenha.setEmail(userResetEmail);
        usuarioRecuperaSenha.setData(DataHoraFactory.getData());
        String token = UUID.randomUUID().toString();
        usuarioRecuperaSenha.setToken(token);
        usuarioRecuperaSenha.setIpUsuario(BeanUtil.getClientIP((HttpServletRequest)this.httpServletRequest));
        UsuarioReseteSenhaRN.getInstance().incluir((AbstractPojo)usuarioRecuperaSenha, null);
        this.emailService.sendMail(usuarioRecuperaSenha, usuario.getNome(), version, ambiente, url);
    }

    @RequestMapping(value={"/validar-token"}, method={RequestMethod.GET})
    @DBAutoCommit
    public UsuarioReseteSenha validarToken(@RequestParam String token) throws UnicoMensagemUsuarioException {
        UsuarioReseteSenha userReset = new UsuarioReseteSenha();
        userReset.setToken(token);
        if (StringUtil.stringNullOrEmpty((String)token)) {
            throw new UnicoMensagemUsuarioException("COM236371", "N\u00e3o foi poss\u00edvel finalizar essa opera\u00e7\u00e3o, insira seu e-mail novamente por favor");
        }
        UsuarioReseteSenha usuarioRecuperaSenha = UsuarioReseteSenhaRN.getInstance().buscarPorToken(userReset.getToken());
        if (usuarioRecuperaSenha == null) {
            throw new UnicoMensagemUsuarioException("WWW303", "N\u00e3o foi poss\u00edvel encontrar a solicita\u00e7\u00e3o, insira seu e-mail novamente por favor");
        }
        if (StringUtil.stringNullOrEmpty((String)usuarioRecuperaSenha.getToken()) || !StringUtil.stringNullOrEmpty((String)usuarioRecuperaSenha.getNovasenha())) {
            throw new UnicoMensagemUsuarioException("WWW304", "J\u00e1 foi registrada uma solicita\u00e7\u00e3o, insira seu e-mail novamente por favor");
        }
        if (ChronoUnit.DAYS.between(usuarioRecuperaSenha.getData(), DataHoraFactory.getData()) > 1L) {
            throw new UnicoMensagemUsuarioException("COM236372", "A solicita\u00e7\u00e3o para resetar a senha est\u00e1 expirada");
        }
        return usuarioRecuperaSenha;
    }

    @RequestMapping(value={"/ativar"}, method={RequestMethod.POST})
    @DBAutoCommit
    public void resetarSenhaAcao(@RequestBody UsuarioReseteSenha resetSenha) throws UnicoMensagemUsuarioException {
        UsuarioReseteSenha usuarioRecuperaSenha = this.validarToken(resetSenha.getToken());
        NivelPoliticaSeguranca nivelPoliticaSeguranca = ControleRN.getInstance().getNivelPoliticaSeguranca();
        if (StringUtil.stringNullOrEmpty((String)resetSenha.getToken()) || StringUtil.stringNullOrEmpty((String)resetSenha.getNovasenha())) {
            throw new UnicoMensagemUsuarioException("WWW308", "O campo de senha n\u00e3o pode ser vazio. Verifique.");
        }
        if (!resetSenha.getNovasenha().equals(resetSenha.getConfirmasenha())) {
            throw new UnicoMensagemUsuarioException("WWW462", "A nova senha n\u00e3o confere com a confirma\u00e7\u00e3o. Verifique.");
        }
        if (!(nivelPoliticaSeguranca == NivelPoliticaSeguranca.BAIXA || NivelPoliticaSeguranca.validar((String)resetSenha.getNovasenha(), (String)nivelPoliticaSeguranca.getRegex()) && NivelPoliticaSeguranca.validar((String)resetSenha.getConfirmasenha(), (String)nivelPoliticaSeguranca.getRegex()))) {
            throw new UnicoMensagemUsuarioException("WWW463", "O valor informado n\u00e3o atende a pol\u00edtica de seguran\u00e7a configurada. Por favor verifique os crit\u00e9rios exigidos.");
        }
        Usuario usuario = UsuarioRN.getInstance().buscarPorEmail(usuarioRecuperaSenha.getEmail(), true);
        if (usuario == null || usuarioRecuperaSenha.getEmail() == null) {
            throw new UnicoMensagemUsuarioException("WWW464", "N\u00e3o foi poss\u00edvel identificar o usu\u00e1rio");
        }
        if (!StringUtil.stringNullOrEmpty((String)usuario.getSenha()) && BCrypt.checkpw((String)resetSenha.getNovasenha(), (String)usuario.getSenha())) {
            throw new UnicoMensagemUsuarioException("WWW466", "A nova senha deve ser diferente da atual. Verifique.");
        }
        usuarioRecuperaSenha.setNovasenha(BCrypt.hashpw((String)resetSenha.getNovasenha(), (String)BCrypt.gensalt()));
        usuarioRecuperaSenha.setUtilizado(EnumSimNao.SIM);
        UsuarioReseteSenhaRN.getInstance().alterar((AbstractPojo)usuarioRecuperaSenha, null);
        usuario.setSenha(usuarioRecuperaSenha.getNovasenha());
        usuario.setBloqueado(EnumSimNao.NAO.getId().intValue());
        usuario.setDataHoraDesbloqueio(null);
        usuario.setTentativasAcesso(0);
        usuario.setObservacaoBloqueio(null);
        UsuarioRN.getInstance().alterar(usuario, null);
    }
}

